/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.context;

import java.io.File;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.lifecycle.Initializable;

public class Workspace
implements Initializable {
    private static final String REGISTRY = "registry";
    private static final String WORKSPACE = "workspace";
    private static final String REPOSITORY = "repository";
    private File root;
    private final File repository;
    private final File registryRootPath;
    private String registryName;
    private boolean initialized = false;

    protected Workspace(File rootPath, String registryName) {
        this.root = rootPath;
        this.registryName = registryName;
        File reg = new File(this.root, REGISTRY);
        File workspace = new File(reg, WORKSPACE);
        this.registryRootPath = new File(workspace, this.registryName);
        this.repository = new File(this.registryRootPath, REPOSITORY);
    }

    public void init() throws LifeCycleException {
        if (this.isInitialized()) {
            return;
        }
        File rootPath = this.getRegistryRootPath();
        if (!rootPath.exists() && !rootPath.mkdirs()) {
            throw new LifeCycleException("Can not create registry root path");
        }
        File repoPath = this.getRepositoryRootPath();
        if (!repoPath.exists() && !repoPath.mkdirs()) {
            throw new LifeCycleException("Can not create repository path");
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void clean() {
    }

    public final File getRepositoryRootPath() {
        return this.repository;
    }

    public final File getRegistryRootPath() {
        return this.registryRootPath;
    }
}

