/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.lifecycle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private transient LifeCycle.STATE state = LifeCycle.STATE.NOT_INITIALIZED;
    protected Log log = LogFactory.getLog(AbstractLifeCycle.class);

    public final void init(Context context) throws LifeCycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initializing " + this.getClass().getName());
        }
        try {
            if (this.state != LifeCycle.STATE.NOT_INITIALIZED) {
                throw new LifeCycleException("Can not initialize in state " + (Object)((Object)this.state));
            }
            if (this.isInitialized()) {
                return;
            }
            this.state = LifeCycle.STATE.INITIALIZING;
            this.doInit(context);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized");
            }
            this.state = LifeCycle.STATE.INITIALIZED;
        }
        catch (LifeCycleException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("failed", e);
            }
            this.state = LifeCycle.STATE.FAILED;
            throw e;
        }
        catch (Error e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed", e);
            }
            this.state = LifeCycle.STATE.FAILED;
            throw e;
        }
    }

    protected void doInit(Context context) throws LifeCycleException {
    }

    protected void doStart() throws LifeCycleException {
    }

    protected void doStop() throws LifeCycleException {
    }

    public final void start() throws LifeCycleException {
        if (this.log.isInfoEnabled()) {
            this.log.debug("Starting " + this.getClass().getName());
        }
        if (!this.isInitialized()) {
            throw new LifeCycleException("Can not start if not initialized");
        }
        try {
            if (this.state == LifeCycle.STATE.STARTED) {
                return;
            }
            this.state = LifeCycle.STATE.STARTING;
            this.doStart();
            this.log.debug("Started");
            this.state = LifeCycle.STATE.STARTED;
        }
        catch (LifeCycleException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Fail to start", e);
            }
            this.state = LifeCycle.STATE.FAILED;
            throw e;
        }
        catch (Error e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to start", e);
            }
            this.state = LifeCycle.STATE.FAILED;
            throw e;
        }
    }

    public final void stop() throws LifeCycleException {
        if (this.log.isInfoEnabled()) {
            this.log.debug("Stopping " + this.getClass().getName());
        }
        if (!this.isRunning()) {
            throw new LifeCycleException("Can not stop if not running...");
        }
        try {
            if (this.state == LifeCycle.STATE.STOPPING || this.state == LifeCycle.STATE.STOPPED) {
                return;
            }
            this.state = LifeCycle.STATE.STOPPING;
            this.doStop();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopped");
            }
            this.state = LifeCycle.STATE.STOPPED;
        }
        catch (LifeCycleException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("failed", e);
            }
            this.state = LifeCycle.STATE.FAILED;
            throw e;
        }
        catch (Error e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed", e);
            }
            this.state = LifeCycle.STATE.FAILED;
            throw e;
        }
    }

    public boolean isRunning() {
        return this.state == LifeCycle.STATE.STARTED || this.state == LifeCycle.STATE.STARTING;
    }

    public boolean isStarted() {
        return this.state == LifeCycle.STATE.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.STATE.STOPPED;
    }

    public boolean isInitialized() {
        return this.state == LifeCycle.STATE.INITIALIZED;
    }

    public boolean isNotInitialized() {
        return this.state == LifeCycle.STATE.NOT_INITIALIZED;
    }

    public LifeCycle.STATE getState() {
        return this.state;
    }

    public void setState(LifeCycle.STATE state) {
        this.state = state;
    }
}

