/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static final Log logger = LogFactory.getLog(XMLUtil.class);
    private static final ThreadLocal<DocumentBuilder> documentBuilderThreadLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                return documentBuilder;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> transformerWithoutXmlDeclarationThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "yes");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> defaultTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "no");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };

    public static Document createDocumentFromString(String xml) {
        if (xml != null) {
            Document doc = null;
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                InputSource inputSource = new InputSource(in);
                doc = documentBuilderThreadLocal.get().parse(inputSource);
                doc.normalize();
            }
            catch (SAXException e) {
                logger.error("Bad XML fragment can't be transformed to a DOM tree.", e);
            }
            catch (IOException e) {
                logger.error("Unexpected Error", e);
            }
            return doc;
        }
        return null;
    }

    public static String createStringFromDOMDocument(Node document) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(document, false);
    }

    public static String createStringFromDOMNode(Node node) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(node, true);
    }

    public static String createStringFromDOMNode(Node node, boolean omitDeclaration) throws TransformerException {
        node.normalize();
        DOMSource source = new DOMSource(node);
        StringWriter out = new StringWriter();
        StreamResult resultStream = new StreamResult(out);
        if (omitDeclaration) {
            transformerWithoutXmlDeclarationThreadLocal.get().transform(source, resultStream);
        } else {
            defaultTransformerThreadLocal.get().transform(source, resultStream);
        }
        return out.toString();
    }
}

