/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AdminServiceClient;
import org.ow2.petals.jmx.ComponentClient;
import org.ow2.petals.jmx.DeploymentServiceClient;
import org.ow2.petals.jmx.EndpointRegistryClient;
import org.ow2.petals.jmx.InstallationServiceClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.JMXConnection;
import org.ow2.petals.jmx.PetalsAdminServiceClient;
import org.ow2.petals.jmx.RuntimeConfigurationComponentClient;
import org.ow2.petals.jmx.SystemMonitoringServiceClient;
import org.ow2.petals.jmx.exception.AdminDoesNotExistException;
import org.ow2.petals.jmx.exception.AdminServiceErrorException;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceErrorException;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;
import org.ow2.petals.jmx.exception.InstallerComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;
import org.ow2.petals.jmx.exception.RuntimeConfigurationDoesNotExistException;
import org.ow2.petals.jmx.exception.RuntimeConfigurationErrorException;
import org.ow2.petals.jmx.exception.SystemMonitoringDoesNotExistException;
import org.ow2.petals.jmx.exception.SystemMonitoringServiceErrorException;

public final class JMXClient {
    private static final String PETALS_DOMAIN = "Petals";
    private static final String OW2_PETALS_DOMAIN = "org.ow2.petals";
    private static final String JAVA_LANG_DOMAIN = "java.lang";
    private JMXConnection jmxConnection = null;

    public JMXClient(String host, Integer jndiPort, String username, String password) throws ConnectionErrorException {
        this.jmxConnection = new JMXConnection(host, jndiPort, username, password);
    }

    public PetalsAdminServiceClient getPetalsAdminServiceClient() throws PetalsAdminDoesNotExistException, PetalsAdminServiceErrorException, ConnectionErrorException {
        return new PetalsAdminServiceClient(PETALS_DOMAIN, this.jmxConnection.getMBeanServerConnection());
    }

    public AdminServiceClient getAdminServiceClient() throws AdminDoesNotExistException, AdminServiceErrorException, ConnectionErrorException {
        return new AdminServiceClient(PETALS_DOMAIN, this.jmxConnection.getMBeanServerConnection());
    }

    public InstallationServiceClient getInstallationServiceClient() throws InstallationServiceDoesNotExistException, InstallationServiceErrorException, ConnectionErrorException {
        return new InstallationServiceClient(PETALS_DOMAIN, this.jmxConnection.getMBeanServerConnection());
    }

    public DeploymentServiceClient getDeploymentServiceClient() throws DeploymentServiceDoesNotExistException, DeploymentServiceErrorException, ConnectionErrorException {
        return new DeploymentServiceClient(PETALS_DOMAIN, this.jmxConnection.getMBeanServerConnection());
    }

    public ComponentClient getComponentClient(String componentName) throws ComponentDoesNotExistException, ComponentErrorException, ConnectionErrorException {
        return new ComponentClient(OW2_PETALS_DOMAIN, componentName, this.jmxConnection.getMBeanServerConnection());
    }

    public ComponentClient getComponentClient(ObjectName componentMBeanName) throws ComponentDoesNotExistException, ComponentErrorException, ConnectionErrorException {
        if (!componentMBeanName.getDomain().equals(PETALS_DOMAIN)) {
            new ComponentDoesNotExistException("Domain name is not 'Petals'");
        }
        return new ComponentClient(componentMBeanName, this.jmxConnection.getMBeanServerConnection());
    }

    public InstallerComponentClient getInstallerComponentClient(String componentName) throws InstallerComponentDoesNotExistException, ComponentErrorException, ConnectionErrorException {
        return new InstallerComponentClient(PETALS_DOMAIN, componentName, this.jmxConnection.getMBeanServerConnection());
    }

    public EndpointRegistryClient getEndpointRegistryClient() throws ConnectionErrorException, EndpointRegistryServiceDoesNotExistException, EndpointRegistryServiceErrorException {
        return new EndpointRegistryClient(PETALS_DOMAIN, this.jmxConnection.getMBeanServerConnection());
    }

    public SystemMonitoringServiceClient getSystemMonitoringServiceClient() throws ConnectionErrorException, SystemMonitoringDoesNotExistException, SystemMonitoringServiceErrorException {
        return new SystemMonitoringServiceClient(JAVA_LANG_DOMAIN, this.jmxConnection.getMBeanServerConnection());
    }

    public RuntimeConfigurationComponentClient getRuntimeConfigurationClient(String dynamicComponentName) throws RuntimeConfigurationDoesNotExistException, RuntimeConfigurationErrorException, ConnectionErrorException {
        return new RuntimeConfigurationComponentClient(OW2_PETALS_DOMAIN, this.jmxConnection.getMBeanServerConnection(), dynamicComponentName);
    }

    public void disconnect() throws ConnectionErrorException {
        this.jmxConnection.disconnect();
    }

    public MBeanServerConnection getMBeanServerConnection() throws ConnectionErrorException {
        return this.jmxConnection.getMBeanServerConnection();
    }
}

