/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.api.IPetalsAdminService;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetalsAdminServiceClient
extends AbstractServiceClient
implements IPetalsAdminService {
    public PetalsAdminServiceClient(String petalsDomain, MBeanServerConnection beanServerConnection) throws PetalsAdminDoesNotExistException, PetalsAdminServiceErrorException {
        super(petalsDomain, beanServerConnection);
        try {
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(IPetalsAdminService.MBean.PETALSADMIN_OBJECT_NAME, null);
            if (objNames == null || objNames.size() != 1) {
                throw new PetalsAdminDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (IOException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
    }

    public void stopContainer() throws PetalsAdminServiceErrorException {
        try {
            this.performAction("stopContainer", null, null);
        }
        catch (PerformActionErrorException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
    }

    public void shutdownContainer() throws PetalsAdminServiceErrorException {
        try {
            this.performAction("shutdownContainer", null, null);
        }
        catch (PerformActionErrorException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
    }

    public Set<Map<String, String>> retrieveTopology() throws PetalsAdminServiceErrorException {
        Set result;
        try {
            result = (Set)this.performAction("retrieveTopology", null, null);
        }
        catch (PerformActionErrorException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new PetalsAdminServiceErrorException("Unexpected result type");
        }
        return result;
    }
}

