/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.jmx.exception.RuntimeConfigurationDoesNotExistException;
import org.ow2.petals.jmx.exception.RuntimeConfigurationErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeConfigurationComponentClient
extends AbstractServiceClient {
    private static final String RUNTIME_CONFIGURATION_JMX_NAME = "runtime_configuration_";
    private static final String RUNTIME_CONFIGURATION_JMX_TYPE = "custom";
    private String componentName = null;

    public RuntimeConfigurationComponentClient(String petalsDomain, MBeanServerConnection beanServerConnection, String componentName) throws RuntimeConfigurationDoesNotExistException, RuntimeConfigurationErrorException {
        super(petalsDomain, beanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            this.componentName = componentName;
            attributes.put("name", RUNTIME_CONFIGURATION_JMX_NAME + this.componentName);
            attributes.put("type", RUNTIME_CONFIGURATION_JMX_TYPE);
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new RuntimeConfigurationDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (IOException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
    }

    public Map<MBeanAttributeInfo, Object> getConfigurationMBeanAttributes() throws PerformActionErrorException, RuntimeConfigurationErrorException {
        MBeanAttributeInfo[] attrs = null;
        HashMap<MBeanAttributeInfo, Object> attributes = new HashMap<MBeanAttributeInfo, Object>();
        try {
            for (MBeanAttributeInfo info : attrs = this.mBeanServerConnection.getMBeanInfo(this.mbeanName).getAttributes()) {
                attributes.put(info, this.mBeanServerConnection.getAttribute(this.mbeanName, info.getName()));
            }
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (IOException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (MBeanException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        return attributes;
    }

    public void setAttributes(Map<MBeanAttributeInfo, Object> attributes) throws PerformActionErrorException, RuntimeConfigurationErrorException {
        AttributeList attributesList = new AttributeList();
        for (Map.Entry<MBeanAttributeInfo, Object> entry : attributes.entrySet()) {
            attributesList.add(new Attribute(entry.getKey().getName(), entry.getValue()));
        }
        try {
            this.mBeanServerConnection.setAttributes(this.mbeanName, attributesList);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
        catch (IOException e) {
            throw new RuntimeConfigurationErrorException(e);
        }
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }
}

