/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.generator.jbi.ws2jbi;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SaBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBeanForSa;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiXmlGenerator;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiZipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.petals.tools.generator.commons.Creator;
import org.ow2.petals.tools.generator.commons.CreatorFactory;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationEngine;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;
import org.ow2.petals.tools.generator.jbi.ws2jbi.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WS2Jbi
implements JBIGenerationEngine {
    private static final String CREATOR_CLASS_NAME = "org.ow2.petals.tools.generator.jbi.wscommons.Creator";
    private final Log logger = LogFactory.getLog(WS2Jbi.class);
    private final URI wsdlURI;
    private File outputDir;
    private final Map<String, String> extensions;
    private final SaBean saBean;
    private final List<SuBeanForSa> suBeans;

    public WS2Jbi(URI wsdlURI, Map<String, String> extensions) {
        this.wsdlURI = wsdlURI;
        this.extensions = extensions;
        this.saBean = new SaBean();
        this.suBeans = new ArrayList<SuBeanForSa>();
    }

    @Override
    public File generate() throws JBIGenerationException {
        File saDirectory;
        if (this.wsdlURI == null) {
            throw new JBIGenerationException("WSDL URI is null");
        }
        String componentVersion = this.extensions.get("component.version");
        if (componentVersion == null) {
            throw new JBIGenerationException("Component version is null");
        }
        Creator c = CreatorFactory.getInstance().getCreator(componentVersion, CREATOR_CLASS_NAME);
        if (c == null) {
            throw new JBIGenerationException("Can not find a valid creator in the classpath for component version " + componentVersion);
        }
        this.logger.info((Object)("Trying to generate JBI artefact for " + this.wsdlURI.toString()));
        if (this.extensions != null && this.extensions.get(Constants.OUTPUT_DIR) != null) {
            this.outputDir = new File(this.extensions.get(Constants.OUTPUT_DIR));
        }
        if (this.outputDir == null) {
            this.outputDir = new File(".");
        }
        this.logger.info((Object)("The JBI artefact file will be generated in " + this.outputDir.getAbsolutePath()));
        File tmpDir = null;
        try {
            tmpDir = File.createTempFile("petalstmpdir", "txt").getParentFile();
        }
        catch (IOException e1) {
            throw new JBIGenerationException(e1);
        }
        File workDirectory = new File(tmpDir, "PETALS-WS2JBI-" + System.currentTimeMillis());
        if (!workDirectory.exists()) {
            workDirectory.mkdirs();
        }
        if (!(saDirectory = new File(workDirectory, "sa")).exists()) {
            saDirectory.mkdirs();
        }
        Description desc = this.readWSDL();
        File wsdlFile = null;
        try {
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            String wsdlString = writer.writeWSDL(desc);
            wsdlFile = new File(workDirectory, "Service.wsdl");
            if (!wsdlFile.exists()) {
                wsdlFile.createNewFile();
            }
            FileWriter fw = new FileWriter(wsdlFile);
            fw.write(wsdlString);
            fw.flush();
            fw.close();
        }
        catch (WSDLException e) {
            throw new JBIGenerationException(e);
        }
        catch (IOException e) {
            throw new JBIGenerationException(e);
        }
        String saName = "SA-soap-" + System.currentTimeMillis();
        if (this.extensions != null && this.extensions.get(Constants.SA_NAME) != null) {
            saName = "SA-soap-" + this.extensions.get(Constants.SA_NAME);
        }
        this.saBean.setSaName(saName);
        this.saBean.setDescription("SA generated for the WSDL file " + this.wsdlURI.toString());
        ArrayList<File> suZipFiles = new ArrayList<File>();
        List services = desc.getServices();
        for (Service service : services) {
            QName serviceName = service.getQName();
            this.logger.info((Object)("Generating for service " + serviceName));
            List endpoints = service.getEndpoints();
            for (Endpoint endpoint : endpoints) {
                String suName = "su-soap-" + endpoint.getName() + "-WS2JBI";
                this.logger.info((Object)("Working on endpoint " + endpoint.getName() + ", address is " + endpoint.getAddress()));
                String endpointPrefix = this.extensions.get("soap.endpointprefix") != null ? this.extensions.get("soap.endpointprefix").toString() : "";
                String endpointName = endpointPrefix + endpoint.getName();
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("soap.endpointaddress", endpoint.getAddress());
                options.put("interface", ((InterfaceType)((Binding)endpoint.getBinding()).getInterface()).getQName().getLocalPart());
                options.put("interfacens", ((InterfaceType)((Binding)endpoint.getBinding()).getInterface()).getQName().getNamespaceURI());
                options.put("service", serviceName.getLocalPart());
                options.put("servicens", serviceName.getNamespaceURI());
                options.put("endpoint", endpointName);
                options.put("component.version", componentVersion);
                options.put("linktype", "");
                options.put("sutype", "");
                options.put("cdk.timeout", "60000");
                options.put("cdk.wsdlfile", wsdlFile.getName());
                SuBean suProvide = c.createSUProvide(options);
                String jbiXmlForSu = JbiXmlGenerator.getInstance().generateJbiXmlFileForSu(suProvide);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Generated JBI :");
                    this.logger.info((Object)jbiXmlForSu);
                }
                File suFile = null;
                File jbiSu = null;
                try {
                    File tempSuDirectory = new File(workDirectory, suName);
                    if (!tempSuDirectory.exists()) {
                        tempSuDirectory.mkdirs();
                    }
                    if (!(jbiSu = new File(tempSuDirectory, "jbi.xml")).exists()) {
                        jbiSu.createNewFile();
                    }
                    FileWriter writer = new FileWriter(jbiSu);
                    writer.write(jbiXmlForSu);
                    writer.close();
                    JbiZipper jbiZipper = JbiZipper.getInstance();
                    ArrayList<File> rootFiles = new ArrayList<File>();
                    rootFiles.add(jbiSu);
                    rootFiles.add(wsdlFile);
                    suFile = new File(this.outputDir, suName + ".zip");
                    suZipFiles.add(jbiZipper.createSuZipFile(suFile, rootFiles));
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage());
                    throw new JBIGenerationException(e);
                }
                SuBeanForSa suBeanForSa = new SuBeanForSa(suProvide);
                suBeanForSa.setZipArtifact(suFile.getName());
                suBeanForSa.setSuName(suName);
                suBeanForSa.setComponentName(c.getComponentName());
                this.suBeans.add(suBeanForSa);
                jbiSu.delete();
            }
        }
        this.saBean.setSus(this.suBeans);
        String jbiXmlForSa = JbiXmlGenerator.getInstance().generateJbiXmlFileForSa(this.saBean);
        File jbiSa = new File(saDirectory, "jbi.xml");
        File saZipFile = null;
        try {
            byte[] utf8 = jbiXmlForSa.getBytes("UTF-8");
            FileWriter writer = new FileWriter(jbiSa);
            writer.write(new String(utf8));
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            File saFile = new File(this.outputDir, saName + ".zip");
            saZipFile = jbiZipper.createSaZipFile(saFile, suZipFiles, jbiSa);
        }
        catch (IOException e) {
            throw new JBIGenerationException(e);
        }
        jbiSa.delete();
        for (File suFile : suZipFiles) {
            if (!suFile.exists()) continue;
            suFile.delete();
        }
        return saZipFile;
    }

    public Description readWSDL() throws JBIGenerationException {
        Description description = null;
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            description = wsdlReader.read(this.wsdlURI.toURL());
        }
        catch (WSDLException e) {
            throw new JBIGenerationException(e);
        }
        catch (MalformedURLException e) {
            throw new JBIGenerationException(e);
        }
        catch (IOException e) {
            throw new JBIGenerationException(e);
        }
        catch (URISyntaxException e) {
            throw new JBIGenerationException(e);
        }
        return description;
    }
}

