/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.attachment.AbstractAttachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.DefaultAttachmentStore;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.attachment.OutgoingAttachment;
import org.ws4d.java.configuration.AttachmentProperties;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.ObjectPool;

class InputStreamAttachment
extends AbstractAttachment
implements IncomingAttachment,
OutgoingAttachment {
    private static final ObjectPool STREAM_BUFFERS = new ObjectPool(new ObjectPool.InstanceCreator(){

        public Object createInstance() {
            return new byte[AttachmentProperties.getInstance().getStreamBufferSize()];
        }
    }, 1);
    private InputStream in;

    InputStreamAttachment(InputStream inputStream) {
        this(inputStream, (InternetMediaType)null);
    }

    InputStreamAttachment(InputStream inputStream, InternetMediaType internetMediaType) {
        this(inputStream, IDGenerator.getUUID(), internetMediaType);
    }

    InputStreamAttachment(InputStream inputStream, String string) {
        this(inputStream, IDGenerator.getUUID(), string);
    }

    InputStreamAttachment(InputStream inputStream, String string, InternetMediaType internetMediaType) {
        super(string, internetMediaType);
        this.in = inputStream;
    }

    InputStreamAttachment(InputStream inputStream, String string, String string2) {
        this(inputStream, string, InputStreamAttachment.maskContentType(string2));
    }

    public final int getType() throws AttachmentException {
        return 1;
    }

    public void dispose() {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            Log.warn("Unable to close attachment input stream on dispose: " + iOException);
            Log.printStackTrace(iOException);
        }
        this.in = null;
    }

    public InputStream getInputStream() throws AttachmentException, IOException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        return this.in;
    }

    public byte[] getBytes() throws AttachmentException, IOException {
        throw new AttachmentException("byte access not supported for stream attachments");
    }

    public long size() throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        if (this.in == null) {
            return 0L;
        }
        try {
            return this.in.available();
        }
        catch (IOException iOException) {
            throw new AttachmentException("unable to access attachment input stream: " + iOException);
        }
    }

    public void serialize(OutputStream outputStream) throws IOException {
        if (this.in == null) {
            return;
        }
        DefaultAttachmentStore.readOut(this.in, outputStream, (byte[])STREAM_BUFFERS.acquire());
        this.dispose();
    }

    public boolean isLocal() {
        return true;
    }

    public String getFilePath() throws AttachmentException {
        throw new AttachmentException("file system operations not supported for stream attachments");
    }

    public void save(String string) throws AttachmentException, IOException {
        throw new AttachmentException("file system operations not supported for stream attachments");
    }

    public boolean move(String string) throws AttachmentException {
        throw new AttachmentException("file system operations not supported for stream attachments");
    }
}

