/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.ContextID;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.types.URI;

public class DPWSProtocolData
extends ProtocolData {
    private static final Object INSTANCE_ID_LOCK = new Object();
    private static long instanceIdInc = 0L;
    private final Long instanceId;
    private final boolean connectionOriented;
    private final String iFace;
    private final String sourceHost;
    private int sourcePort;
    private final String destinationHost;
    private final int destinationPort;
    private volatile ContextID currentMIMEContext;
    private URI transportAddress = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DPWSProtocolData(String string, boolean bl, String string2, int n, String string3, int n2, boolean bl2) {
        super(bl);
        Object object = INSTANCE_ID_LOCK;
        synchronized (object) {
            this.instanceId = new Long(instanceIdInc++);
        }
        this.iFace = string;
        this.sourceHost = string2;
        this.sourcePort = n;
        this.destinationHost = string3;
        this.destinationPort = n2;
        this.connectionOriented = bl2;
    }

    private DPWSProtocolData(String string, boolean bl, String string2, int n, String string3, int n2, boolean bl2, Long l) {
        super(bl);
        this.instanceId = l;
        this.iFace = string;
        this.sourceHost = string2;
        this.sourcePort = n;
        this.destinationHost = string3;
        this.destinationPort = n2;
        this.connectionOriented = bl2;
    }

    public ProtocolData createSwappedProtocolData() {
        return new DPWSProtocolData(this.iFace, !this.direction, this.destinationHost, this.destinationPort, this.sourceHost, this.sourcePort, this.connectionOriented, this.instanceId);
    }

    public String getCommunicationManagerId() {
        return "DPWS";
    }

    public String getIFace() {
        return this.iFace;
    }

    public String getSourceAddress() {
        return this.getSourceHost() + '@' + this.getSourcePort();
    }

    public String getDestinationAddress() {
        return this.getDestinationHost() + '@' + this.getDestinationPort();
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public String getSourceHost() {
        return this.sourceHost;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public boolean isConnectionOriented() {
        return this.connectionOriented;
    }

    public ContextID getCurrentMIMEContext() {
        return this.currentMIMEContext;
    }

    public void setCurrentMIMEContext(ContextID contextID) {
        this.currentMIMEContext = contextID;
    }

    public void setSourcePort(int n) {
        if (this.sourcePort == 0) {
            this.sourcePort = n;
        } else if (this.sourcePort != n) {
            throw new RuntimeException("Attempt to overwrite a non-zero source port.");
        }
    }

    public String toString() {
        return "DPWSProtocolData [ id=" + this.getInstanceId() + ", from=" + this.getSourceAddress() + ", to=" + this.getDestinationAddress() + " ]";
    }

    public URI getTransportAddress() {
        return this.transportAddress;
    }

    public void setTransportAddress(URI uRI) {
        this.transportAddress = uRI;
    }
}

