/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.IncomingMessageListener;
import org.ws4d.java.communication.IncomingSOAPReceiver;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoredMessageReceiver;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.HTTPResponse;
import org.ws4d.java.communication.protocol.mime.MIMEBodyHeader;
import org.ws4d.java.communication.protocol.mime.MIMEEntityInput;
import org.ws4d.java.communication.protocol.mime.MIMEEntityOutput;
import org.ws4d.java.communication.protocol.mime.MIMEHandler;
import org.ws4d.java.communication.protocol.soap.SOAPResponse;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.SOAPMessageGeneratorFactory;
import org.ws4d.java.constants.SOAPConstants;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Queue;
import org.ws4d.java.util.ParameterUtil;

final class IncomingMIMEReceiver
implements MIMEHandler,
MessageReceiver {
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private final IncomingMessageListener listener;
    private final HashMap responses = new HashMap();

    static void storeMIMEContext(ParameterValue parameterValue, ProtocolData protocolData) {
        if (parameterValue != null && ParameterUtil.hasAttachment(parameterValue)) {
            ParameterUtil.setAttachmentScope(parameterValue, protocolData.getCurrentMIMEContext());
        }
    }

    IncomingMIMEReceiver(IncomingMessageListener incomingMessageListener) {
        this.listener = incomingMessageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(MIMEEntityInput mIMEEntityInput, Queue queue, ProtocolData protocolData, MonitoringContext monitoringContext) {
        MIMEEntityOutput mIMEEntityOutput;
        MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
        MessageReceiver messageReceiver = monitorStreamFactory != null ? new MonitoredMessageReceiver(this, monitoringContext) : this;
        SOAPMessageGeneratorFactory.getInstance().getSOAP2MessageGeneratorForCurrentThread().deliverMessage(mIMEEntityInput.getBodyInputStream(), messageReceiver, protocolData);
        HashMap hashMap = this.responses;
        synchronized (hashMap) {
            mIMEEntityOutput = (MIMEEntityOutput)this.responses.remove(Thread.currentThread());
        }
        if (mIMEEntityOutput != null) {
            queue.enqueue(mIMEEntityOutput);
        }
    }

    public void handleResponse(MIMEEntityInput mIMEEntityInput, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
    }

    public void receive(HelloMessage helloMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(ByeMessage byeMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(ProbeMessage probeMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(ResolveMessage resolveMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(GetMessage getMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(GetResponseMessage getResponseMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(SubscribeMessage subscribeMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(GetStatusMessage getStatusMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(RenewMessage renewMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receive(InvokeMessage invokeMessage, ProtocolData protocolData) {
        IncomingMIMEReceiver.storeMIMEContext(invokeMessage.getContent(), protocolData);
        IncomingSOAPReceiver.markIncoming(invokeMessage);
        try {
            InvokeMessage invokeMessage2 = this.listener.handle(invokeMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(invokeMessage, protocolData);
            this.respondWithMessage(invokeMessage2);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(invokeMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public OperationDescription getOperation(String string) {
        return this.listener.getOperation(string);
    }

    public void receive(FaultMessage faultMessage, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void receiveFailed(Exception exception, ProtocolData protocolData) {
        this.sendBadRequest();
    }

    public void sendFailed(Exception exception, ProtocolData protocolData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondWithMessage(final InvokeMessage invokeMessage) {
        if (invokeMessage != null) {
            IncomingSOAPReceiver.markOutgoing(invokeMessage);
            SimpleMIMEEntityOutput simpleMIMEEntityOutput = new SimpleMIMEEntityOutput(){

                public HTTPResponse getHTTPResponse() {
                    return new SOAPResponse(200, invokeMessage);
                }
            };
            HashMap hashMap = this.responses;
            synchronized (hashMap) {
                this.responses.put(Thread.currentThread(), simpleMIMEEntityOutput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondWithFault(SOAPException sOAPException) {
        final FaultMessage faultMessage = sOAPException.getFault();
        IncomingSOAPReceiver.markOutgoing(faultMessage);
        SimpleMIMEEntityOutput simpleMIMEEntityOutput = new SimpleMIMEEntityOutput(){

            public HTTPResponse getHTTPResponse() {
                if (SOAPConstants.SOAP_FAULT_SENDER.equals(faultMessage.getCode())) {
                    return new SOAPResponse(400, faultMessage);
                }
                return new SOAPResponse(500, faultMessage);
            }
        };
        HashMap hashMap = this.responses;
        synchronized (hashMap) {
            this.responses.put(Thread.currentThread(), simpleMIMEEntityOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBadRequest() {
        HashMap hashMap = this.responses;
        synchronized (hashMap) {
            this.responses.put(Thread.currentThread(), new SOAPResponse(400, null));
        }
    }

    private static abstract class SimpleMIMEEntityOutput
    implements MIMEEntityOutput {
        private SimpleMIMEEntityOutput() {
        }

        public void serialize(OutputStream outputStream) throws IOException {
        }

        public MIMEBodyHeader getEntityHeader() {
            return null;
        }
    }
}

