/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.util.Log;

public class TCPConnection {
    private final InputStream in;
    private final OutputStream out;
    private final Socket socket;
    private final DPWSProtocolData protocolData;
    private boolean closed = false;
    private boolean fstRead = true;
    private boolean fstWrite = true;

    public TCPConnection(InputStream inputStream, OutputStream outputStream, Socket socket) {
        this(inputStream, outputStream, socket, new DPWSProtocolData(null, false, socket.getLocalAddress().getAddressWithoutNicId(), socket.getLocalPort(), socket.getRemoteAddress().getAddressWithoutNicId(), socket.getRemotePort(), true));
    }

    public TCPConnection(InputStream inputStream, OutputStream outputStream, Socket socket, DPWSProtocolData dPWSProtocolData) {
        this.in = inputStream;
        this.out = outputStream;
        this.socket = socket;
        this.protocolData = dPWSProtocolData;
    }

    public InputStream getInputStream() {
        if (Log.isDebug()) {
            return new InputStreamWrapper(this.in, this);
        }
        return this.in;
    }

    public OutputStream getOutputStream() {
        if (Log.isDebug()) {
            return new OutputStreamWrapper(this.out, this);
        }
        return this.out;
    }

    public DPWSProtocolData getProtocolData() {
        return this.protocolData;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.out.flush();
        this.in.close();
        this.out.close();
        this.socket.close();
        this.closed = true;
    }

    public Long getIdentifier() {
        return this.protocolData.getInstanceId();
    }

    public String toString() {
        if (this.protocolData != null) {
            return "TCP Connection [ id = " + this.protocolData.getInstanceId() + " ]";
        }
        return "TCP Connection";
    }

    synchronized boolean isFirstRead() {
        return this.fstRead;
    }

    synchronized boolean isFirstWrite() {
        return this.fstWrite;
    }

    synchronized void firstRead() {
        this.fstRead = false;
    }

    synchronized void firstWrite() {
        this.fstWrite = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private class OutputStreamWrapper
    extends OutputStream {
        private OutputStream out = null;
        private TCPConnection connection = null;

        OutputStreamWrapper(OutputStream outputStream, TCPConnection tCPConnection2) {
            this.out = outputStream;
            this.connection = tCPConnection2;
        }

        public void write(int n) throws IOException {
            if (this.connection.isFirstWrite() && Log.isDebug()) {
                this.connection.firstWrite();
                Log.debug("<O-TCP> Sending data, " + this.connection, 1);
            }
            this.out.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            if (this.connection.isFirstWrite() && Log.isDebug()) {
                this.connection.firstWrite();
                Log.debug("<O-TCP> Sending data, " + this.connection, 1);
            }
            this.out.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.connection.isFirstWrite() && Log.isDebug()) {
                this.connection.firstWrite();
                Log.debug("<O-TCP> Sending data, " + this.connection, 1);
            }
            this.out.write(byArray, n, n2);
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void flush() throws IOException {
            this.out.flush();
        }
    }

    private class InputStreamWrapper
    extends InputStream {
        private InputStream in = null;
        private TCPConnection connection = null;

        InputStreamWrapper(InputStream inputStream, TCPConnection tCPConnection2) {
            this.in = inputStream;
            this.connection = tCPConnection2;
        }

        public int read() throws IOException {
            if (this.connection.isFirstRead() && Log.isDebug()) {
                this.connection.firstRead();
                Log.debug("<I-TCP> Reading data, " + this.connection, 1);
            }
            return this.in.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.connection.isFirstRead() && Log.isDebug()) {
                this.connection.firstRead();
                Log.debug("<I-TCP> Reading data, " + this.connection, 1);
            }
            return this.in.read(byArray, n, n2);
        }

        public int read(byte[] byArray) throws IOException {
            if (this.connection.isFirstRead() && Log.isDebug()) {
                this.connection.firstRead();
                Log.debug("<I-TCP> Reading data, " + this.connection, 1);
            }
            return this.in.read(byArray);
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public synchronized void mark(int n) {
            this.in.mark(n);
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        public long skip(long l) throws IOException {
            return this.in.skip(l);
        }
    }
}

