/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.ServerSocket;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.communication.connection.tcp.SocketFactory;
import org.ws4d.java.communication.connection.tcp.TCPConnection;
import org.ws4d.java.communication.connection.tcp.TCPConnectionHandler;
import org.ws4d.java.communication.monitor.MonitoredInputStream;
import org.ws4d.java.communication.monitor.MonitoredOutputStream;
import org.ws4d.java.configuration.IPProperties;
import org.ws4d.java.io.buffered.BufferedInputStream;
import org.ws4d.java.security.DPWSSecurityManager;
import org.ws4d.java.security.SecurityManager;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.Log;

public class TCPListener
implements Runnable {
    private static final int ACCEPT_RETRIES = 3;
    private static final int ACCEPT_RETRY_DELAY = 1000;
    private static final boolean BUFFERED_INPUT = true;
    private IPAddress ipAddress = null;
    private int port = -1;
    private Object lockObj = new Object();
    private volatile boolean running = false;
    private ServerSocket serverSocket = null;
    private TCPConnectionHandler handler = null;
    private List connections = new LinkedList();
    private boolean secure = false;

    TCPListener(IPAddress iPAddress, int n, TCPConnectionHandler tCPConnectionHandler) throws IOException {
        this(iPAddress, n, tCPConnectionHandler, false, null);
    }

    TCPListener(IPAddress iPAddress, int n, TCPConnectionHandler tCPConnectionHandler, boolean bl, String string) throws IOException {
        if (bl && !DPWSFramework.hasModule(64)) {
            throw new IOException("Cannot create SSL Socket. DPWS security module missing.");
        }
        if (tCPConnectionHandler == null) {
            throw new IOException("Cannot listen for incoming data. No handler set for connection handling.");
        }
        if (iPAddress == null) {
            throw new IOException("Cannot listen for incoming data. No IP address given.");
        }
        if (n < 0 || n > 65535) {
            throw new IOException("Cannot listen for incoming data. Port number invalid.");
        }
        this.handler = tCPConnectionHandler;
        this.ipAddress = iPAddress;
        SecurityManager securityManager = DPWSFramework.getSecurityManager();
        this.serverSocket = bl && securityManager != null && securityManager instanceof DPWSSecurityManager ? ((DPWSSecurityManager)securityManager).getSecureServerSocket(iPAddress, n, string) : SocketFactory.getInstance().createServerSocket(iPAddress, n);
        this.port = this.serverSocket.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Log.isDebug()) {
            Log.debug("TCP listener up for " + this.ipAddress + " and port " + this.port + ".", 1);
        }
        int n = 0;
        Object object = this.lockObj;
        synchronized (object) {
            this.running = true;
            this.lockObj.notifyAll();
        }
        while (this.isRunning()) {
            try {
                object = this.serverSocket.accept();
                if (!this.isRunning()) break;
                if (object == null) {
                    Log.warn("Incoming TCP connection has returned no socket. Re-listening for new connections.");
                    continue;
                }
                if (!IPProperties.getInstance().isAllowedByIPFilter(object.getRemoteAddress())) continue;
                InputStream inputStream = object.getInputStream();
                OutputStream outputStream = object.getOutputStream();
                if (inputStream == null) {
                    Log.warn("Incoming TCP connection has no input stream. Cannot handle connection. Re-listening for new connections.");
                    continue;
                }
                if (outputStream == null) {
                    Log.warn("Incoming TCP connection has no output stream. Cannot handle connection. Re-listening for new connections.");
                    continue;
                }
                DPWSProtocolData dPWSProtocolData = null;
                dPWSProtocolData = object.getRemoteAddress() == null ? new DPWSProtocolData(null, true, null, object.getRemotePort(), object.getLocalAddress().getAddressWithoutNicId(), object.getLocalPort(), true) : new DPWSProtocolData(null, true, object.getRemoteAddress().getAddressWithoutNicId(), object.getRemotePort(), object.getLocalAddress().getAddressWithoutNicId(), object.getLocalPort(), true);
                inputStream = new BufferedInputStream(inputStream);
                if (DPWSFramework.getMonitorStreamFactory() != null) {
                    inputStream = new MonitoredInputStream(inputStream, dPWSProtocolData);
                    outputStream = new MonitoredOutputStream(outputStream, dPWSProtocolData.createSwappedProtocolData());
                }
                TCPConnection tCPConnection = new TCPConnection(inputStream, outputStream, (Socket)object, dPWSProtocolData);
                this.connections.add(tCPConnection);
                if (Log.isDebug()) {
                    if (object.getRemoteAddress() != null) {
                        Log.debug("<I-TCP> From " + object.getRemoteAddress() + "@" + object.getRemotePort() + " to " + object.getLocalAddress() + "@" + object.getLocalPort() + ", " + tCPConnection, 1);
                    } else {
                        Log.debug("<I-TCP> From unkown host to " + this.ipAddress + " and port " + this.port + ", " + tCPConnection, 1);
                    }
                }
                DPWSFramework.getThreadPool().execute(new TCPConnectionThread(tCPConnection, this.handler));
            }
            catch (IOException iOException) {
                if (!this.isRunning()) break;
                if (n++ < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.warn("TCP listener interrupted. TCP listener shutdown for " + this.ipAddress + " and port " + this.port + ".");
                        break;
                    }
                    Log.warn("Cannot open port " + this.port + " for " + this.ipAddress + ". Try " + n + ".");
                    continue;
                }
                Log.error("Cannot open port " + this.port + " for " + this.ipAddress + ". TCP listener shutdown for " + this.ipAddress + " and port " + this.port + ".");
                break;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean start() {
        if (this.running) {
            return true;
        }
        Object object = this.lockObj;
        synchronized (object) {
            try {
                if (DPWSFramework.getThreadPool().executeOrAbort(this)) {
                    while (!this.running) {
                        this.lockObj.wait();
                    }
                    return true;
                }
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.serverSocket.close();
        if (Log.isDebug()) {
            Log.debug("TCP listener shutdown for " + this.ipAddress + " and port " + this.port + ".", 1);
        }
    }

    public synchronized void kill() throws IOException {
        block3: {
            this.stop();
            TCPConnection tCPConnection = null;
            try {
                Iterator iterator = this.connections.iterator();
                while (iterator.hasNext()) {
                    tCPConnection = (TCPConnection)iterator.next();
                    tCPConnection.close();
                    iterator.remove();
                }
            }
            catch (IOException iOException) {
                if (tCPConnection == null) break block3;
                Log.error("Cannot close TCP connection (" + tCPConnection.getIdentifier() + ").");
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        n = 31 * n + this.port;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TCPListener tCPListener = (TCPListener)object;
        if (this.ipAddress == null ? tCPListener.ipAddress != null : !this.ipAddress.equals(tCPListener.ipAddress)) {
            return false;
        }
        return this.port == tCPListener.port;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean isSecure() {
        return this.secure;
    }

    private class TCPConnectionThread
    implements Runnable {
        private TCPConnection connection = null;
        private TCPConnectionHandler handler = null;

        TCPConnectionThread(TCPConnection tCPConnection, TCPConnectionHandler tCPConnectionHandler) {
            this.connection = tCPConnection;
            this.handler = tCPConnectionHandler;
        }

        public void run() {
            block3: {
                try {
                    this.handler.handle(this.connection);
                    if (Log.isDebug()) {
                        Log.debug("<I> Incoming TCP connection (" + this.connection.getIdentifier() + ") handling done.", 1);
                    }
                    this.connection.close();
                }
                catch (IOException iOException) {
                    if (this.connection.isClosed()) break block3;
                    Log.warn("<I> Incoming TCP connection (" + this.connection.getIdentifier() + "). " + iOException.getMessage() + ".");
                }
            }
        }
    }
}

