/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.communication.connection.udp.Datagram;

public class DatagramInputStream
extends InputStream {
    private Datagram datagram;
    private InputStream in = null;
    private int r = 0;
    private int size = 0;

    public DatagramInputStream(Datagram datagram) {
        this.datagram = datagram;
        this.in = new ByteArrayInputStream(datagram.getData());
        this.size = datagram.getContentLength();
    }

    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.r > this.size) {
            if (this.in != null) {
                this.datagram.release();
                this.in = null;
            }
            return -1;
        }
        int n = this.in.read();
        ++this.r;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.r > this.size) {
            if (this.in != null) {
                this.datagram.release();
                this.in = null;
            }
            return -1;
        }
        int n = this.in.read(byArray);
        if (n < 0) {
            this.datagram.release();
            return -1;
        }
        this.r += n;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.r > this.size) {
            if (this.in != null) {
                this.datagram.release();
                this.in = null;
            }
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2);
        if (n3 < 0) {
            this.datagram.release();
            return -1;
        }
        this.r += n3;
        return n3;
    }

    public int available() throws IOException {
        return this.in != null ? this.in.available() : 0;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.datagram != null) {
            this.datagram.release();
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.in == null ? 0 : this.in.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DatagramInputStream datagramInputStream = (DatagramInputStream)object;
        return !(this.in == null ? datagramInputStream.in != null : !this.in.equals(datagramInputStream.in));
    }
}

