/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.udp.Datagram;
import org.ws4d.java.communication.connection.udp.DatagramSocket;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.ObjectPool;

public class SEDatagramSocket
implements DatagramSocket {
    private static final ObjectPool BUFFERS = new ObjectPool(new ObjectPool.InstanceCreator(){

        public Object createInstance() {
            return new byte[FrameworkProperties.getInstance().getMaxDatagramSize()];
        }
    }, 4);
    private MulticastSocket socket = null;
    private String ifaceName = "";
    private int conCount = 1;
    private IPAddress socketAddress = null;
    private int port = -1;
    private boolean isMulticast = false;

    public SEDatagramSocket(IPAddress iPAddress, int n, String string) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(iPAddress.getAddress());
        NetworkInterface networkInterface = NetworkInterface.getByName(string);
        MulticastSocket multicastSocket = null;
        if (inetAddress.isMulticastAddress()) {
            this.isMulticast = true;
            try {
                multicastSocket = new MulticastSocket(n);
                multicastSocket.setNetworkInterface(networkInterface);
                multicastSocket.joinGroup(inetAddress);
            }
            catch (IOException iOException) {
                Log.warn("Can not join multicast group (" + iPAddress + "@" + n + ") at interface " + string + ". No receiving of UDP packets on this interface.");
                throw iOException;
            }
        }
        try {
            multicastSocket = n >= 0 && n <= 65535 ? new MulticastSocket(n) : new MulticastSocket();
            multicastSocket.setNetworkInterface(networkInterface);
        }
        catch (IOException iOException) {
            Log.warn("Can not set NetworkInterface (" + iPAddress + "@" + n + ") at interface " + string);
            throw iOException;
        }
        this.socket = multicastSocket;
        this.socketAddress = iPAddress;
        this.port = multicastSocket.getLocalPort();
        this.ifaceName = string;
    }

    public void test(String string, int n) throws UnknownHostException {
        this.socket.connect(InetAddress.getByName(string), n);
    }

    public void incrementConCount() {
        ++this.conCount;
    }

    public void close() throws IOException {
        if (this.isMulticast) {
            this.socket.close();
            if (Log.isDebug()) {
                Log.debug("UDP multicast socket closed for interface: " + this.ifaceName + ".");
            }
        } else {
            this.socket.close();
            if (Log.isDebug()) {
                Log.debug("UDP socket closed for interface: " + this.ifaceName + " - " + this.socketAddress);
            }
        }
    }

    public Datagram receive() throws IOException {
        byte[] byArray = new byte[FrameworkProperties.getInstance().getMaxDatagramSize()];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.socket.receive(datagramPacket);
        Datagram datagram = new Datagram(this, byArray, datagramPacket.getLength());
        datagram.setSocketAddress(this.socketAddress);
        datagram.setSocketPort(this.port);
        InetAddress inetAddress = datagramPacket.getAddress();
        datagram.setAddress(new IPAddress(inetAddress.getHostAddress(), inetAddress.isLoopbackAddress(), inetAddress instanceof Inet6Address, inetAddress.isLinkLocalAddress()));
        datagram.setPort(datagramPacket.getPort());
        return datagram;
    }

    public void send(Datagram datagram) throws IOException {
        byte[] byArray = datagram.getData();
        InetAddress inetAddress = InetAddress.getByName(datagram.getIPAddress().getAddressWithoutNicId());
        DatagramPacket datagramPacket = new DatagramPacket(byArray, datagram.getContentLength(), inetAddress, datagram.getPort());
        this.socket.send(datagramPacket);
    }

    public void release(Datagram datagram) {
    }

    public String toString() {
        return "interface: " + this.ifaceName + ", port: " + this.port;
    }

    public IPAddress getSocketAddress() {
        return this.socketAddress;
    }

    public int getSocketPort() {
        return this.port;
    }
}

