/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.udp;

import java.io.IOException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.udp.Datagram;
import org.ws4d.java.communication.connection.udp.DatagramSocket;
import org.ws4d.java.communication.connection.udp.UDPDatagramHandler;
import org.ws4d.java.communication.connection.udp.UDPListener;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.util.Log;

public class UDPServer {
    private static final HashMap listeners = new HashMap();

    public static synchronized void open(IPAddress iPAddress, int n, String string, UDPDatagramHandler uDPDatagramHandler) throws IOException {
        UDPServer.open(iPAddress, n, string, uDPDatagramHandler, false);
    }

    public static synchronized void open(IPAddress iPAddress, int n, String string, UDPDatagramHandler uDPDatagramHandler, boolean bl) throws IOException {
        if (iPAddress == null) {
            throw new IOException("Cannot create UDP listener. No IP address given.");
        }
        if (n < 1 || n > 65535) {
            throw new IOException("Cannot create UDP listener Port number invalid.");
        }
        UDPListener uDPListener = null;
        String string2 = iPAddress.getAddress() + "@" + n + "%" + string;
        uDPListener = (UDPListener)listeners.get(string2);
        if (uDPListener != null) {
            throw new IOException("Cannot create UDP listener for " + iPAddress + " and port " + n + ". This address is already in use.");
        }
        uDPListener = new UDPListener(iPAddress, n, string, uDPDatagramHandler, bl);
        listeners.put(string2, uDPListener);
        uDPListener.start();
    }

    public static synchronized void close(IPAddress iPAddress, int n, String string) throws IOException {
        if (iPAddress == null) {
            return;
        }
        if (n < 1 || n > 65535) {
            return;
        }
        UDPListener uDPListener = null;
        uDPListener = (UDPListener)listeners.get(iPAddress.getAddress() + "@" + n + "%" + string);
        if (uDPListener == null) {
            return;
        }
        UDPServer.close(uDPListener);
    }

    private static void close(UDPListener uDPListener) throws IOException {
        Iterator iterator = listeners.values().iterator();
        while (iterator.hasNext()) {
            UDPListener uDPListener2 = (UDPListener)iterator.next();
            if (uDPListener2 != uDPListener) continue;
            iterator.remove();
        }
        uDPListener.stop();
    }

    public static synchronized void send(IPAddress iPAddress, int n, String string, IPAddress iPAddress2, int n2, byte[] byArray, int n3) throws IOException {
        if (iPAddress == null) {
            return;
        }
        if (n < 1 || n > 65535) {
            return;
        }
        UDPListener uDPListener = null;
        uDPListener = (UDPListener)listeners.get(iPAddress.getAddress() + "@" + n + "%" + string);
        if (uDPListener == null) {
            return;
        }
        UDPServer.send(uDPListener.getDatagramSocket(), iPAddress2, n2, byArray, n3);
    }

    public static synchronized void send(UDPDatagramHandler uDPDatagramHandler, IPAddress iPAddress, int n, byte[] byArray, int n2) throws IOException {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        Iterator iterator = listeners.values().iterator();
        while (iterator.hasNext()) {
            UDPListener uDPListener = (UDPListener)iterator.next();
            UDPDatagramHandler uDPDatagramHandler2 = uDPListener.getUDPDatagramHandler();
            if (uDPDatagramHandler2 != uDPDatagramHandler) continue;
            UDPServer.send(uDPListener.getDatagramSocket(), iPAddress, n, byArray, n2);
        }
    }

    static void send(DatagramSocket datagramSocket, IPAddress iPAddress, int n, byte[] byArray, int n2) throws IOException {
        Datagram datagram = new Datagram(datagramSocket, byArray, n2);
        datagram.setAddress(iPAddress);
        datagram.setPort(n);
        if (Log.isDebug()) {
            Log.debug("<O-UDP> To " + iPAddress + "@" + n + " from " + datagramSocket.getSocketAddress() + "@" + datagramSocket.getSocketPort() + ", " + datagram, 1);
        }
        datagramSocket.send(datagram);
    }
}

