/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.protocol.http.HTTPClient;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.URI;

public class HTTPClientDestination {
    private IPAddress host = null;
    private int port = 80;
    private boolean secure = false;
    private String alias = null;
    private static final HashMap maxCon = new HashMap();
    private int hashCode;

    public HTTPClientDestination(String string) {
        this(new URI(string), false, null);
    }

    public HTTPClientDestination(String string, boolean bl, String string2) {
        this(new URI(string), bl, string2);
    }

    public HTTPClientDestination(URI uRI) {
        this(uRI, false, null);
    }

    public HTTPClientDestination(URI uRI, boolean bl, String string) {
        this(new IPAddress(uRI.getHost()), uRI.getPort(), bl, string);
    }

    public HTTPClientDestination(IPAddress iPAddress, int n) {
        this(iPAddress, n, false, null);
    }

    public HTTPClientDestination(IPAddress iPAddress, int n, boolean bl, String string) {
        this.host = iPAddress;
        this.port = n;
        this.secure = bl;
        this.alias = string;
        this.hashCode = 1;
        this.hashCode = 31 * this.hashCode + (string == null ? 0 : string.hashCode());
        this.hashCode = 31 * this.hashCode + (iPAddress == null ? 0 : iPAddress.hashCode());
        this.hashCode = 31 * this.hashCode + n;
        this.hashCode = 31 * this.hashCode + (this.secure ? 1231 : 1237);
        this.setMaxConnections(HTTPClient.MAX_CLIENT_CONNECTIONS);
    }

    public void setMaxConnections(int n) {
        maxCon.put(this.host, new Integer(n));
    }

    public int getMaxConnections() {
        return (Integer)maxCon.get(this.host);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HTTPClientDestination hTTPClientDestination = (HTTPClientDestination)object;
        if (this.alias == null ? hTTPClientDestination.alias != null : !this.alias.equals(hTTPClientDestination.alias)) {
            return false;
        }
        if (this.host == null ? hTTPClientDestination.host != null : !this.host.equals(hTTPClientDestination.host)) {
            return false;
        }
        if (this.port != hTTPClientDestination.port) {
            return false;
        }
        return this.secure == hTTPClientDestination.secure;
    }

    public IPAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAlias() {
        return this.alias;
    }
}

