/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap.generator;

import org.ws4d.java.communication.protocol.soap.generator.DefaultMessage2SOAPGenerator;
import org.ws4d.java.communication.protocol.soap.generator.DefaultSOAP2MessageGenerator;
import org.ws4d.java.communication.protocol.soap.generator.Message2SOAPGenerator;
import org.ws4d.java.communication.protocol.soap.generator.SOAP2MessageGenerator;
import org.ws4d.java.configuration.DPWSProperties;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.util.Log;

public class SOAPMessageGeneratorFactory {
    private static final HashMap SOAP2MSG_GENERATOR_CACHE = new HashMap(FrameworkProperties.getInstance().getThreadPoolSize());
    private static final HashMap MSG2SOAP_GENERATOR_CACHE = new HashMap(FrameworkProperties.getInstance().getThreadPoolSize());
    private static final SOAPMessageGeneratorFactory INSTANCE;

    public static SOAPMessageGeneratorFactory getInstance() {
        return INSTANCE;
    }

    public static void clear() {
        SOAP2MSG_GENERATOR_CACHE.clear();
        MSG2SOAP_GENERATOR_CACHE.clear();
    }

    public synchronized SOAP2MessageGenerator getSOAP2MessageGeneratorForCurrentThread() {
        Thread thread = Thread.currentThread();
        SOAP2MessageGenerator sOAP2MessageGenerator = (SOAP2MessageGenerator)SOAP2MSG_GENERATOR_CACHE.get(thread);
        if (sOAP2MessageGenerator == null) {
            sOAP2MessageGenerator = this.newSOAP2MessageGenerator();
            SOAP2MSG_GENERATOR_CACHE.put(thread, sOAP2MessageGenerator);
        }
        return sOAP2MessageGenerator;
    }

    public synchronized Message2SOAPGenerator getMessage2SOAPGeneratorForCurrentThread() {
        Thread thread = Thread.currentThread();
        Message2SOAPGenerator message2SOAPGenerator = (Message2SOAPGenerator)MSG2SOAP_GENERATOR_CACHE.get(thread);
        if (message2SOAPGenerator == null) {
            message2SOAPGenerator = this.newMessage2SOAPGenerator();
            MSG2SOAP_GENERATOR_CACHE.put(thread, message2SOAPGenerator);
        }
        return message2SOAPGenerator;
    }

    protected Message2SOAPGenerator newMessage2SOAPGenerator() {
        return new DefaultMessage2SOAPGenerator();
    }

    protected SOAP2MessageGenerator newSOAP2MessageGenerator() {
        return new DefaultSOAP2MessageGenerator();
    }

    static {
        String string = DPWSProperties.getInstance().getSOAPMessageGeneratorFactoryClass();
        SOAPMessageGeneratorFactory sOAPMessageGeneratorFactory = null;
        if (string == null) {
            sOAPMessageGeneratorFactory = new SOAPMessageGeneratorFactory();
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                sOAPMessageGeneratorFactory = (SOAPMessageGeneratorFactory)clazz.newInstance();
                if (Log.isDebug()) {
                    Log.debug("Using SOAPMessageGeneratorFactory [" + string + "]", 4);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.error("SOAPMessageGeneratorFactory: Configured SOAPMessageGeneratorFactory class [" + string + "] not found, falling back to default implementation");
                sOAPMessageGeneratorFactory = new SOAPMessageGeneratorFactory();
            }
            catch (Exception exception) {
                Log.error("SOAPMessageGeneratorFactory: Unable to create instance of configured SOAPMessageGeneratorFactory class [" + string + "], falling back to default implementation");
                Log.printStackTrace(exception);
                sOAPMessageGeneratorFactory = new SOAPMessageGeneratorFactory();
            }
        }
        INSTANCE = sOAPMessageGeneratorFactory;
    }
}

