/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.attachment.AttachmentStore;
import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;

public class AttachmentProperties
implements PropertiesHandler {
    public static final String PROP_ATTACHMENT_STORE_POLICY = "AttachmentStorePolicy";
    public static final String PROP_MAX_ATTACHMENT_SIZE = "MaxAttachmentSize";
    public static final String PROP_MAX_MEM_BUFFER_SIZE = "MaxMemBufferSize";
    public static final String PROP_STORE_PATH = "StorePath";
    public static final String PROP_READ_BUFFER_SIZE = "ReadBufferSize";
    public static final String PROP_STREAM_BUFFER_SIZE = "StreamBufferSize";
    public static final String PROP_STREAMING_MEDIA_TYPES = "StreamingMediaTypes";
    private int attachmentStorePolicy = 2;
    private int maxAttachmentSize = 0x1000000;
    private int maxMemBufferSize = 65536;
    private String storePath = "attachment_store";
    private int readBufferSize = 8192;
    private int streamBufferSize = 128;
    private DataStructure streamingMediaTypes = new HashSet();

    AttachmentProperties() {
    }

    public static AttachmentProperties getInstance() {
        return (AttachmentProperties)Properties.forClassName("org.ws4d.java.configuration.AttachmentProperties");
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (Properties.HEADER_SUBSECTION_ATTACHMENT.equals(propertyHeader)) {
            if (PROP_ATTACHMENT_STORE_POLICY.equals(property.key)) {
                int n;
                if ("file".equals(property.value)) {
                    n = 2;
                } else if ("memory".equals(property.value)) {
                    n = 1;
                } else {
                    Log.warn("Unexpected attachment store policy: " + property.value + ", resetting to POLICY_MEM_BUFFER");
                    n = 1;
                }
                this.attachmentStorePolicy = n;
            } else if (PROP_MAX_ATTACHMENT_SIZE.equals(property.key)) {
                this.maxAttachmentSize = Integer.parseInt(property.value.trim());
            } else if (PROP_MAX_MEM_BUFFER_SIZE.equals(property.key)) {
                this.maxMemBufferSize = Integer.parseInt(property.value.trim());
            } else if (PROP_STORE_PATH.equals(property.key)) {
                this.storePath = property.value;
            } else if (PROP_READ_BUFFER_SIZE.equals(property.key)) {
                this.readBufferSize = Integer.parseInt(property.value.trim());
            } else if (PROP_STREAM_BUFFER_SIZE.equals(property.key)) {
                this.streamBufferSize = Integer.parseInt(property.value.trim());
            } else if (PROP_STREAMING_MEDIA_TYPES.equals(property.key)) {
                String[] stringArray = StringUtil.split(property.value, '|');
                for (int i = 0; i < stringArray.length; ++i) {
                    this.streamingMediaTypes.add(stringArray[i]);
                }
            }
        }
    }

    public void finishedSection(int n) {
        AttachmentStore.setStorePolicy(this.getAttachmentStorePolicy());
    }

    public int getAttachmentStorePolicy() {
        return this.attachmentStorePolicy;
    }

    public void setAttachmentStorePolicy(int n) {
        this.attachmentStorePolicy = n;
    }

    public int getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public void setMaxAttachmentSize(int n) {
        this.maxAttachmentSize = n;
    }

    public int getMaxMemBufferSize() {
        return this.maxMemBufferSize;
    }

    public void setMaxMemBufferSize(int n) {
        this.maxMemBufferSize = n;
    }

    public String getStorePath() {
        return this.storePath;
    }

    public void setStorePath(String string) {
        this.storePath = string;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int n) {
        this.readBufferSize = n;
    }

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public void setStremBufferSize(int n) {
        this.streamBufferSize = n;
    }

    public Iterator getStreamingMediaTypes() {
        return new ReadOnlyIterator(new HashSet(this.streamingMediaTypes));
    }

    public void setStreamingMediaTypes(DataStructure dataStructure) {
        this.streamingMediaTypes.clear();
        if (dataStructure != null) {
            this.streamingMediaTypes.addAll(dataStructure);
        }
    }
}

