/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.configuration.BindingProperties;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.ThisDeviceMData;
import org.ws4d.java.types.ThisModelMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.StringUtil;

public class DeviceProperties {
    public static final String PROP_CONFIGURATION_ID = "ConfigurationId";
    public static final String PROP_DEVICE_UUID = "DeviceUuid";
    public static final String PROP_METADATA_VERSION = "MetadataVersion";
    public static final String PROP_TYPES = "Types";
    public static final String PROP_SCOPES = "Scopes";
    public static final String PROP_BINDING = "Binding";
    public static final String PROP_SEC = "DeviceSecured";
    public static final String PROP_SEC_PRIVATEKEY_ALIAS = "PrivateKeyAlias";
    public static final String PROP_SEC_PRIVATEKEY_PASS = "PrivateKeyPassphrase";
    public static final String PROP_MANUFACTUERE_URL = "ManufacturerUrl";
    public static final String PROP_MANUFACTURER_NAME = "ManufacturerName";
    public static final String PROP_MODEL_NAME = "ModelName";
    public static final String PROP_MODEL_NUMBER = "ModelNumber";
    public static final String PROP_MODEL_URL = "ModelUrl";
    public static final String PROP_PRESENTATION_URL = "PresentationUrl";
    public static final String PROP_FRIENDLY_NAME = "FriendlyName";
    public static final String PROP_FIRMWARE_VERSION = "FirmwareVersion";
    public static final String PROP_SERIAL_NUMBER = "SerialNumber";
    public static final Integer DEFAULT_CONFIGURATION_ID = new Integer(-1);
    private Integer configurationId = DEFAULT_CONFIGURATION_ID;
    private DiscoveryData discoveryData = null;
    private List bindings = new ArrayList(2);
    private List discoveryBindings = new ArrayList(2);
    private ThisModelMData modelData = null;
    private ThisDeviceMData deviceData = null;
    private static final BindingProperties bindProps = BindingProperties.getInstance();
    private boolean deviceSecured = false;
    private String privateKeyAlias = "defaultPrivKey";
    private String privateKeyPass = "default";

    public DeviceProperties() {
    }

    public DeviceProperties(DeviceProperties deviceProperties) {
        this.discoveryData = new DiscoveryData(deviceProperties.discoveryData);
        this.deviceData = new ThisDeviceMData(deviceProperties.deviceData);
        this.modelData = new ThisModelMData(deviceProperties.modelData);
        this.configurationId = deviceProperties.configurationId;
        this.bindings = new ArrayList(deviceProperties.bindings);
        this.discoveryBindings = new ArrayList(deviceProperties.discoveryBindings);
    }

    public Integer getConfigurationId() {
        return this.configurationId;
    }

    public List getBindings() {
        return this.bindings;
    }

    public List getDiscoveryBindings() {
        return this.discoveryBindings;
    }

    public DiscoveryData getDiscoveryData() {
        return this.discoveryData;
    }

    public ThisModelMData getModelData() {
        return this.modelData;
    }

    public ThisDeviceMData getDeviceData() {
        return this.deviceData;
    }

    public boolean useSecurity() {
        return this.deviceSecured;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public String getPrivateKeyPass() {
        return this.privateKeyPass;
    }

    void addProperty(Property property) {
        if (this.discoveryData == null) {
            this.discoveryData = new DiscoveryData();
        }
        if (PROP_CONFIGURATION_ID.equals(property.key)) {
            this.configurationId = Integer.valueOf(property.value);
        } else if (PROP_DEVICE_UUID.equals(property.key)) {
            this.discoveryData.setEndpointReference(new EndpointReference(new URI(property.value)));
        } else if (PROP_METADATA_VERSION.equals(property.key)) {
            this.discoveryData.setMetadataVersion(Long.parseLong(property.value.trim()));
        } else if (PROP_TYPES.equals(property.key)) {
            this.discoveryData.setTypes(QNameSet.construct(property.value));
            QNameSet qNameSet = this.discoveryData.getTypes();
        } else if (PROP_SCOPES.equals(property.key)) {
            this.discoveryData.setScopes(ScopeSet.construct(property.value));
        } else if (PROP_BINDING.equals(property.key)) {
            CommunicationBinding communicationBinding;
            ArrayList arrayList = (ArrayList)bindProps.getCommunicationBinding(Integer.valueOf(property.value));
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.bindings.add(arrayList.get(i));
                }
            }
            if ((communicationBinding = bindProps.getDiscoveryBinding(Integer.valueOf(property.value))) != null) {
                this.discoveryBindings.add(communicationBinding);
            }
        } else if (PROP_MANUFACTUERE_URL.equals(property.key)) {
            if (this.modelData == null) {
                this.modelData = new ThisModelMData();
            }
            this.modelData.setManufacturerUrl(new URI(property.value));
        } else if (PROP_MANUFACTURER_NAME.equals(property.key)) {
            LocalizedString localizedString;
            String[] stringArray;
            if (this.modelData == null) {
                this.modelData = new ThisModelMData();
            }
            if ((stringArray = StringUtil.split(property.value, ';')).length == 1) {
                localizedString = new LocalizedString(stringArray[0], null);
            } else if (stringArray.length > 1) {
                localizedString = new LocalizedString(stringArray[1], stringArray[0]);
            } else {
                return;
            }
            this.modelData.addManufacturerName(localizedString);
        } else if (PROP_MODEL_NAME.equals(property.key)) {
            LocalizedString localizedString;
            String[] stringArray;
            if (this.modelData == null) {
                this.modelData = new ThisModelMData();
            }
            if ((stringArray = StringUtil.split(property.value, ';')).length == 1) {
                localizedString = new LocalizedString(stringArray[0], null);
            } else if (stringArray.length > 1) {
                localizedString = new LocalizedString(stringArray[1], stringArray[0]);
            } else {
                return;
            }
            this.modelData.addModelName(localizedString);
        } else if (PROP_MODEL_NUMBER.equals(property.key)) {
            if (this.modelData == null) {
                this.modelData = new ThisModelMData();
            }
            this.modelData.setModelNumber(property.value);
        } else if (PROP_MODEL_URL.equals(property.key)) {
            if (this.modelData == null) {
                this.modelData = new ThisModelMData();
            }
            this.modelData.setModelUrl(new URI(property.value));
        } else if (PROP_PRESENTATION_URL.equals(property.key)) {
            if (this.modelData == null) {
                this.modelData = new ThisModelMData();
            }
            this.modelData.setPresentationUrl(new URI(property.value));
        } else if (PROP_FRIENDLY_NAME.equals(property.key)) {
            LocalizedString localizedString;
            String[] stringArray;
            if (this.deviceData == null) {
                this.deviceData = new ThisDeviceMData();
            }
            if ((stringArray = StringUtil.split(property.value, ';')).length == 1) {
                localizedString = new LocalizedString(stringArray[0], null);
            } else if (stringArray.length > 1) {
                localizedString = new LocalizedString(stringArray[1], stringArray[0]);
            } else {
                return;
            }
            this.deviceData.addFriendlyName(localizedString);
        } else if (PROP_FIRMWARE_VERSION.equals(property.key)) {
            if (this.deviceData == null) {
                this.deviceData = new ThisDeviceMData();
            }
            this.deviceData.setFirmwareVersion(property.value);
        } else if (PROP_SERIAL_NUMBER.equals(property.key)) {
            if (this.deviceData == null) {
                this.deviceData = new ThisDeviceMData();
            }
            this.deviceData.setSerialNumber(property.value);
        } else if (PROP_SEC.equals(property.key)) {
            if ("true".equals(property.value)) {
                this.deviceSecured = true;
            } else if ("false".equals(property.value)) {
                this.deviceSecured = false;
            }
        } else if (PROP_SEC_PRIVATEKEY_ALIAS.equals(property.key)) {
            this.privateKeyAlias = property.value;
        } else if (PROP_SEC_PRIVATEKEY_PASS.equals(property.key)) {
            this.privateKeyPass = property.value;
        }
    }
}

