/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.util.Log;

public class HTTPProperties
implements PropertiesHandler {
    public static final String PROP_MAX_CONNECTIONS = "MaxConnections";
    public static final String PROP_ADDRESS = "Address";
    public static final String PROP_CHUNK_MODE = "ChunkMode";
    public static final String SUBSUBSECTION_CONNECTION_CONFIG = "ConnectionConfig";
    public static final PropertyHeader HEADER_SUBSUBSECTION_CONNECTION_CONFIG = new PropertyHeader("ConnectionConfig", Properties.HEADER_SECTION_HTTP);
    private static final int DEFAULT_CHUNK_MODE = 0;
    private HashMap ccMap = new HashMap();
    private ConnectionConfig currentConfig = null;
    private int maxCon = 5;

    HTTPProperties() {
    }

    public static synchronized HTTPProperties getInstance() {
        return (HTTPProperties)Properties.forClassName("org.ws4d.java.configuration.HTTPProperties");
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (HEADER_SUBSUBSECTION_CONNECTION_CONFIG.equals(propertyHeader)) {
            if (this.currentConfig == null) {
                this.currentConfig = new ConnectionConfig();
            }
            if (PROP_ADDRESS.equals(property.key)) {
                this.currentConfig.setAddress(property.value);
            } else if (PROP_CHUNK_MODE.equals(property.key)) {
                this.currentConfig.setChunkMode(Integer.parseInt(property.value.trim()));
            }
        }
    }

    public void finishedSection(int n) {
        if (n == 2 && this.currentConfig != null) {
            String string = this.currentConfig.getAddress();
            if (string != null) {
                this.ccMap.put(string, this.currentConfig);
                this.currentConfig = null;
            } else {
                Log.error("Cannot store HTTP connection configuration. No address given.");
            }
        }
    }

    public int getMaxConnections() {
        return this.maxCon;
    }

    public void setMaxConnections(int n) {
        this.maxCon = n;
    }

    public int getChunkMode(String string) {
        ConnectionConfig connectionConfig = (ConnectionConfig)this.ccMap.get(string);
        if (connectionConfig != null) {
            return connectionConfig.getChunkMode();
        }
        return -1;
    }

    public void setChunkMode(String string, int n) {
        ConnectionConfig connectionConfig = (ConnectionConfig)this.ccMap.get(string);
        if (connectionConfig != null) {
            connectionConfig.setChunkMode(n);
        }
    }

    public void addConnectionConfig(String string, int n) {
        ConnectionConfig connectionConfig = new ConnectionConfig();
        connectionConfig.setAddress(string);
        connectionConfig.setChunkMode(n);
        this.ccMap.put(string, connectionConfig);
    }

    private class ConnectionConfig {
        private String address = null;
        private int chunkMode = 0;

        ConnectionConfig() {
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String string) {
            this.address = string;
        }

        public int getChunkMode() {
            return this.chunkMode;
        }

        public void setChunkMode(int n) {
            this.chunkMode = n;
        }
    }
}

