/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Set;
import org.ws4d.java.util.Log;

public class IPProperties
implements PropertiesHandler {
    public static final int ALLOW_ALL = 0;
    public static final int DENY_ALL = 1;
    public static final String SUBSUBSECTION_ALLOW = "Allow";
    public static final String SUBSUBSECTION_DENY = "Deny";
    public static final String PROP_ADDRESS = "Address";
    public static final String PROP_FILTER_MODE = "FilterMode";
    public static final PropertyHeader HEADER_SUBSUBSECTION_ALLOW = new PropertyHeader("Allow", Properties.HEADER_SECTION_IP);
    public static final PropertyHeader HEADER_SUBSUBSECTION_DENY = new PropertyHeader("Deny", Properties.HEADER_SECTION_IP);
    private Set whiteList = new HashSet();
    private Set blackList = new HashSet();
    private Set notified = new HashSet();
    private int ipFilterMode = 0;

    IPProperties() {
    }

    public static synchronized IPProperties getInstance() {
        return (IPProperties)Properties.forClassName("org.ws4d.java.configuration.IPProperties");
    }

    public int getIPFilterMode() {
        return this.ipFilterMode;
    }

    public boolean isAllowedByIPFilter(IPAddress iPAddress) {
        boolean bl = true;
        if (this.ipFilterMode == 0) {
            bl = !this.blackList.contains(iPAddress);
        } else if (this.ipFilterMode == 1) {
            bl = this.whiteList.contains(iPAddress);
        }
        if (!bl && !this.notified.contains(iPAddress)) {
            Log.warn("Incoming communication from address " + iPAddress + " discarded by IP filter.");
            this.notified.add(iPAddress);
        }
        return bl;
    }

    public void allowAddress(IPAddress iPAddress) {
        this.whiteList.add(iPAddress);
    }

    public void denyAddress(IPAddress iPAddress) {
        this.blackList.add(iPAddress);
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (HEADER_SUBSUBSECTION_DENY.equals(propertyHeader)) {
            if (PROP_ADDRESS.equals(property.key)) {
                this.blackList.add(new IPAddress(property.value));
            }
        } else if (HEADER_SUBSUBSECTION_ALLOW.equals(propertyHeader)) {
            if (PROP_ADDRESS.equals(property.key)) {
                this.whiteList.add(new IPAddress(property.value));
            }
        } else if (PROP_FILTER_MODE.equals(property.key)) {
            this.ipFilterMode = Integer.parseInt(property.value.trim());
        }
    }

    public void finishedSection(int n) {
    }
}

