/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.configuration.SectionHeaderFoundException;
import org.ws4d.java.io.buffered.BufferedInputStream;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.util.Log;

public final class Properties {
    public static final String PROP_HANDLER = "PropertiesHandler";
    public static final String PROP_BINDING = "Binding";
    public static final String PROP_CONFIGURATION_ID = "ConfigurationId";
    public static final String[] SECTION_BINDINGS = new String[]{"Bindings"};
    public static final String[] SECTION_GLOBAL = new String[]{"Global"};
    public static final String[] SECTION_DEVICES = new String[]{"Devices"};
    public static final String[] SECTION_SERVICES = new String[]{"Services"};
    public static final String[] SECTION_EVENTING = new String[]{"Eventing"};
    public static final String[] SECTION_DPWS = new String[]{"DPWS"};
    public static final String[] SECTION_HTTP = new String[]{"HTTP"};
    public static final String[] SECTION_IP = new String[]{"IP"};
    public static final String[] SECTION_SECURITY = new String[]{"Security"};
    public static final PropertyHeader HEADER_SECTION_BINDINGS = new PropertyHeader(SECTION_BINDINGS);
    public static final PropertyHeader HEADER_SECTION_GLOBAL = new PropertyHeader(SECTION_GLOBAL);
    public static final PropertyHeader HEADER_SECTION_DEVICES = new PropertyHeader(SECTION_DEVICES);
    public static final PropertyHeader HEADER_SECTION_SERVICES = new PropertyHeader(SECTION_SERVICES);
    public static final PropertyHeader HEADER_SECTION_EVENTING = new PropertyHeader(SECTION_EVENTING);
    public static final PropertyHeader HEADER_SECTION_DPWS = new PropertyHeader(SECTION_DPWS);
    public static final PropertyHeader HEADER_SECTION_HTTP = new PropertyHeader(SECTION_HTTP);
    public static final PropertyHeader HEADER_SECTION_IP = new PropertyHeader(SECTION_IP);
    public static final PropertyHeader HEADER_SECTION_SECURITY = new PropertyHeader(SECTION_SECURITY);
    public static final PropertyHeader HEADER_SUBSECTION_DEVICE = new PropertyHeader("Device", SECTION_DEVICES);
    public static final PropertyHeader HEADER_SUBSECTION_SERVICE = new PropertyHeader("Service", SECTION_SERVICES);
    public static final PropertyHeader HEADER_SUBSECTION_EVENT_SINK = new PropertyHeader("EventSink", SECTION_EVENTING);
    public static final PropertyHeader HEADER_SUBSECTION_DISPATCHING = new PropertyHeader("Dispatching", SECTION_GLOBAL);
    public static final PropertyHeader HEADER_SUBSECTION_LOGGING = new PropertyHeader("Logging", SECTION_GLOBAL);
    public static final PropertyHeader HEADER_SUBSECTION_FRAMEWORK = new PropertyHeader("Framework", SECTION_GLOBAL);
    public static final PropertyHeader HEADER_SUBSECTION_ATTACHMENT = new PropertyHeader("Attachments", SECTION_GLOBAL);
    public static final int MAX_SECTION_DEPTH = 8;
    static final String DEVICES_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.DevicesPropertiesHandler";
    static final String SERVICES_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.ServicesPropertiesHandler";
    static final String BINDING_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.BindingProperties";
    static final String EVENTING_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.EventingProperties";
    static final String ATTACHMENT_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.AttachmentProperties";
    static final String GLOBAL_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.GlobalPropertiesHandler";
    static final String DISPATCHING_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.DispatchingProperties";
    static final String FRAMEWORK_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.FrameworkProperties";
    static final String SECURITY_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.SecurityProperties";
    public static final String DPWS_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.DPWSProperties";
    public static final String HTTP_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.HTTPProperties";
    public static final String IP_PROPERTIES_HANDLER_CLASS = "org.ws4d.java.configuration.IPProperties";
    static final HashMap ownHandlers = new HashMap();
    private static HashMap handlersPerClass = null;
    private HashMap loadedhandlerMap = new HashMap();
    private HashMap handlerMap = new HashMap();
    private static Properties properties = null;
    public BufferedInputStream stream = null;

    public static synchronized PropertiesHandler forClassName(String string) {
        PropertiesHandler propertiesHandler;
        if (handlersPerClass == null) {
            propertiesHandler = Properties.createHandlerInstance(string);
            handlersPerClass = new HashMap();
            handlersPerClass.put(string, propertiesHandler);
        } else {
            propertiesHandler = (PropertiesHandler)handlersPerClass.get(string);
            if (propertiesHandler == null) {
                propertiesHandler = Properties.createHandlerInstance(string);
                handlersPerClass.put(string, propertiesHandler);
            }
        }
        return propertiesHandler;
    }

    private static PropertiesHandler createHandlerInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (PropertiesHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unknown properties handler class: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unable to access properties handler class " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Unbale to instantiate properties handler class " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Not a properties handler class: " + string);
        }
    }

    private Properties() {
        ownHandlers.put(this.headerString(SECTION_BINDINGS), BINDING_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_GLOBAL), GLOBAL_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_DEVICES), DEVICES_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_SERVICES), SERVICES_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_EVENTING), EVENTING_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_DPWS), DPWS_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_HTTP), HTTP_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_IP), IP_PROPERTIES_HANDLER_CLASS);
        ownHandlers.put(this.headerString(SECTION_SECURITY), SECURITY_PROPERTIES_HANDLER_CLASS);
    }

    private String headerString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 16);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public static synchronized Properties getInstance() {
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    private void initHandlers() {
        this.register(HEADER_SECTION_GLOBAL, Properties.forClassName(GLOBAL_PROPERTIES_HANDLER_CLASS));
        this.register(HEADER_SUBSECTION_DISPATCHING, Properties.forClassName(DISPATCHING_PROPERTIES_HANDLER_CLASS));
        this.register(HEADER_SUBSECTION_FRAMEWORK, Properties.forClassName(FRAMEWORK_PROPERTIES_HANDLER_CLASS));
        this.register(HEADER_SECTION_BINDINGS, Properties.forClassName(BINDING_PROPERTIES_HANDLER_CLASS));
        if (DPWSFramework.hasModule(2)) {
            this.register(HEADER_SECTION_DEVICES, Properties.forClassName(DEVICES_PROPERTIES_HANDLER_CLASS));
            this.register(HEADER_SECTION_SERVICES, Properties.forClassName(SERVICES_PROPERTIES_HANDLER_CLASS));
        }
        if (DPWSFramework.hasModule(4)) {
            this.register(HEADER_SECTION_EVENTING, Properties.forClassName(EVENTING_PROPERTIES_HANDLER_CLASS));
        }
        if (DPWSFramework.hasModule(32)) {
            this.register(HEADER_SUBSECTION_ATTACHMENT, Properties.forClassName(ATTACHMENT_PROPERTIES_HANDLER_CLASS));
        }
    }

    private void finishHandlers() {
        HashSet hashSet = new HashSet(this.handlerMap.size());
        Iterator iterator = this.handlerMap.values().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            PropertiesHandler propertiesHandler = (PropertiesHandler)iterator.next();
            propertiesHandler.finishedSection(0);
        }
    }

    public void init() {
        this.init((InputStream)null);
    }

    public void init(String string) {
        try {
            if (DPWSFramework.hasModule(16)) {
                Log.info("Reading via getResourceAsStream() ...");
                this.init(this.getClass().getResourceAsStream(string));
            } else {
                this.init(DPWSFramework.getLocalFileSystem().readFile(string));
            }
        }
        catch (IOException iOException) {
            Log.warn("Cannot load framework properties from " + string + ". " + iOException.getMessage());
        }
    }

    public void init(InputStream inputStream) {
        PropertyHeader propertyHeader;
        this.initHandlers();
        if (inputStream == null) {
            if (this.stream == null) {
                this.finishHandlers();
                return;
            }
            inputStream = this.stream;
        }
        PropertiesHandler[] propertiesHandlerArray = new PropertiesHandler[8];
        PropertiesInputStream propertiesInputStream = new PropertiesInputStream(inputStream);
        PropertiesHandler propertiesHandler = null;
        Class<?> clazz = null;
        PropertyHeader propertyHeader2 = propertyHeader = Properties.readHeader(propertiesInputStream);
        while (propertyHeader != null) {
            block41: {
                if (propertyHeader.depth() > 8) {
                    Log.error("Properties.init: Section depth too big " + propertyHeader);
                    propertyHeader = Properties.readHeader(propertiesInputStream);
                    break;
                }
                propertyHeader.initSuperHeaders(propertyHeader2);
                if (propertiesHandler != null) {
                    int n = propertyHeader.depth() - 1;
                    for (int i = propertyHeader2.depth() - 1; i >= n; --i) {
                        if (propertiesHandlerArray[i] == null) continue;
                        propertiesHandlerArray[i].finishedSection(i + 1);
                        propertiesHandlerArray[i] = null;
                    }
                }
                propertyHeader2 = propertyHeader;
                try {
                    int n;
                    Property property = Properties.readNextProperty(propertiesInputStream);
                    String string = (String)ownHandlers.get(propertyHeader.toString());
                    if (property != null && PROP_HANDLER.equals(property.key)) {
                        if (property.value != null) {
                            clazz = Class.forName(property.value);
                            if (clazz == null) {
                                Log.error("Properties.init: unknown handler class " + clazz);
                                throw new ClassNotFoundException();
                            }
                            if (!this.loadedhandlerMap.containsKey(clazz.getName())) {
                                try {
                                    PropertiesHandler propertiesHandler2 = (PropertiesHandler)clazz.newInstance();
                                    this.loadedhandlerMap.put(clazz.getName(), propertiesHandler2);
                                    propertiesHandler = propertiesHandler2;
                                }
                                catch (Exception exception) {
                                    Log.printStackTrace(exception);
                                    Log.error("Properties.init: load handler exception " + clazz);
                                    throw new ClassNotFoundException();
                                }
                            } else {
                                propertiesHandler = (PropertiesHandler)this.loadedhandlerMap.get(clazz.getName());
                            }
                            propertiesHandlerArray[propertyHeader.depth() - 1] = propertiesHandler;
                        }
                        property = Properties.readNextProperty(propertiesInputStream);
                        while (property != null) {
                            propertiesHandler.setProperties(propertyHeader, property);
                            property = Properties.readNextProperty(propertiesInputStream);
                        }
                        break block41;
                    }
                    if (property != null && !PROP_HANDLER.equals(property.key) && string != null) {
                        clazz = Class.forName(string);
                        if (clazz == null) {
                            Log.error("Properties.init: unknown handler class " + clazz);
                            throw new ClassNotFoundException();
                        }
                        if (!this.loadedhandlerMap.containsKey(clazz.getName())) {
                            try {
                                PropertiesHandler propertiesHandler3 = (PropertiesHandler)clazz.newInstance();
                                this.loadedhandlerMap.put(clazz.getName(), propertiesHandler3);
                                propertiesHandler = propertiesHandler3;
                            }
                            catch (Exception exception) {
                                Log.printStackTrace(exception);
                                Log.error("Properties.init: load handler exception " + clazz);
                                throw new ClassNotFoundException();
                            }
                        } else {
                            propertiesHandler = (PropertiesHandler)this.loadedhandlerMap.get(clazz.getName());
                        }
                        property = Properties.readNextProperty(propertiesInputStream);
                        while (property != null) {
                            propertiesHandler.setProperties(propertyHeader, property);
                            property = Properties.readNextProperty(propertiesInputStream);
                        }
                        break block41;
                    }
                    if (Log.isDebug()) {
                        Log.debug("Properties.init: PropertiesHandler is not first in section " + propertyHeader + ", checking super handlers", 4);
                    }
                    PropertiesHandler propertiesHandler4 = null;
                    for (n = propertyHeader.depth() - 2; n >= 0; --n) {
                        propertiesHandler4 = propertiesHandlerArray[n];
                        if (propertiesHandler4 == null) continue;
                        for (int i = n + 1; i <= propertyHeader.depth() - 1; ++i) {
                            propertiesHandlerArray[i] = propertiesHandler4;
                        }
                        break;
                    }
                    n = propertiesHandler4 != null ? 1 : 0;
                    PropertiesHandler propertiesHandler5 = null;
                    if (n != 0 && (propertiesHandler5 = (PropertiesHandler)this.handlerMap.get(propertyHeader)) != null && propertiesHandler5 != propertiesHandler) {
                        n = 0;
                    }
                    if (n != 0) {
                        while (property != null) {
                            propertiesHandler.setProperties(propertyHeader, property);
                            property = Properties.readNextProperty(propertiesInputStream);
                        }
                    } else {
                        PropertiesHandler propertiesHandler6 = propertiesHandler = propertiesHandler5 == null ? (PropertiesHandler)this.handlerMap.get(propertyHeader) : propertiesHandler5;
                        if (propertiesHandler != null) {
                            propertiesHandlerArray[propertyHeader.depth() - 1] = propertiesHandler;
                            while (property != null) {
                                propertiesHandler.setProperties(propertyHeader, property);
                                property = Properties.readNextProperty(propertiesInputStream);
                            }
                        } else {
                            while (propertiesHandler == null && propertyHeader.depth() > 1) {
                                propertyHeader = propertyHeader.superHeader();
                                propertiesHandler = (PropertiesHandler)this.handlerMap.get(propertyHeader);
                            }
                            if (propertiesHandler != null) {
                                for (int i = propertyHeader.depth() - 1; i < propertyHeader2.depth(); ++i) {
                                    propertiesHandlerArray[i] = propertiesHandler;
                                }
                                propertyHeader = propertyHeader2;
                                while (property != null) {
                                    propertiesHandler.setProperties(propertyHeader, property);
                                    property = Properties.readNextProperty(propertiesInputStream);
                                }
                            } else if (Log.isDebug()) {
                                Log.debug("Properties.init: no super handler or registered handler for section " + propertyHeader, 4);
                            }
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Log.error("Properties.init: Can't load handler class " + classNotFoundException.getMessage());
                }
                catch (SectionHeaderFoundException sectionHeaderFoundException) {
                    // empty catch block
                }
            }
            propertyHeader = Properties.readHeader(propertiesInputStream);
        }
        for (int i = propertyHeader2.depth() - 1; i >= 0; --i) {
            if (propertiesHandlerArray[i] == null) continue;
            propertiesHandlerArray[i].finishedSection(i + 1);
            propertiesHandlerArray[i] = null;
        }
        this.finishHandlers();
    }

    public PropertiesHandler getLoadedHandler(String string) {
        return (PropertiesHandler)this.loadedhandlerMap.get(string);
    }

    public DataStructure getAllLoadedHandlers() {
        DataStructure dataStructure = this.loadedhandlerMap.values();
        return dataStructure;
    }

    void register(PropertyHeader propertyHeader, PropertiesHandler propertiesHandler) {
        this.handlerMap.put(propertyHeader, propertiesHandler);
        this.loadedhandlerMap.put(propertiesHandler.getClass().getName(), propertiesHandler);
    }

    public void register(PropertyHeader propertyHeader, String string) {
        this.register(propertyHeader, Properties.forClassName(string));
    }

    void unregister(PropertyHeader propertyHeader) {
        PropertiesHandler propertiesHandler = (PropertiesHandler)this.handlerMap.remove(propertyHeader);
        if (propertiesHandler != null) {
            this.loadedhandlerMap.remove(propertiesHandler.getClass().getName());
        }
    }

    private static Property readNextProperty(PropertiesInputStream propertiesInputStream) throws SectionHeaderFoundException {
        String string = null;
        int n = propertiesInputStream.read();
        while (n != 1) {
            if (n == 35) {
                while ((n = propertiesInputStream.read()) != 10 && n != -1) {
                }
                if (n == -1) {
                    return null;
                }
                n = propertiesInputStream.read();
                continue;
            }
            if (n == 32 || n == 10) {
                while (((n = propertiesInputStream.read()) == 32 || n == 10) && n != -1) {
                }
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(64);
            boolean bl = false;
            do {
                switch (n) {
                    case 61: {
                        if (string == null) {
                            string = stringBuffer.toString().trim();
                            stringBuffer = new StringBuffer(128);
                            break;
                        }
                        stringBuffer.append((char)n);
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case -1: {
                        if (string == null) {
                            return null;
                        }
                        String string2 = stringBuffer.toString().trim();
                        return new Property(string, string2);
                    }
                    case 10: {
                        if (string == null) {
                            bl = true;
                            break;
                        }
                        String string3 = stringBuffer.toString().trim();
                        return new Property(string, string3);
                    }
                    case 32: {
                        if (stringBuffer.length() < 1) break;
                        stringBuffer.append((char)n);
                        break;
                    }
                    case 91: {
                        if (stringBuffer.length() < 1 && string == null) {
                            propertiesInputStream.buffer = n;
                            throw new SectionHeaderFoundException(null);
                        }
                    }
                    default: {
                        stringBuffer.append((char)n);
                    }
                }
                n = propertiesInputStream.read();
            } while (!bl);
        }
        return null;
    }

    private static PropertyHeader readHeader(PropertiesInputStream propertiesInputStream) {
        int n = 0;
        PropertyHeader propertyHeader = null;
        StringBuffer stringBuffer = new StringBuffer(64);
        int n2 = propertiesInputStream.read();
        while (n2 != -1) {
            if (n2 == 35) {
                while ((n2 = propertiesInputStream.read()) != 10 && n2 != -1) {
                }
                if (n2 == -1) {
                    return null;
                }
            } else if (n2 == 32 || n2 == 10) {
                while (((n2 = propertiesInputStream.read()) == 32 || n2 == 10) && n2 != -1) {
                }
                if (n2 == -1) {
                    return null;
                }
            }
            if (n2 == 91) {
                do {
                    switch (n2) {
                        case 91: {
                            ++n;
                            break;
                        }
                        case 93: {
                            if (propertyHeader == null) {
                                propertyHeader = new PropertyHeader(stringBuffer.toString().trim(), n);
                            }
                            --n;
                            break;
                        }
                        case -1: {
                            return propertyHeader;
                        }
                        case 13: {
                            break;
                        }
                        case 10: {
                            if (propertyHeader != null) {
                                return propertyHeader;
                            }
                            stringBuffer = new StringBuffer(64);
                            break;
                        }
                        default: {
                            if (n <= 0) break;
                            stringBuffer.append((char)n2);
                        }
                    }
                    if (n2 == -1) continue;
                    n2 = propertiesInputStream.read();
                } while (n2 != -1);
            }
            n2 = propertiesInputStream.read();
        }
        return propertyHeader;
    }

    private class PropertiesInputStream {
        private InputStream in;
        private int buffer = -1;

        protected PropertiesInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        public int read() {
            if (this.buffer != -1) {
                int n = this.buffer;
                this.buffer = -1;
                return n;
            }
            try {
                int n = this.in.read();
                return n;
            }
            catch (IOException iOException) {
                return -1;
            }
        }
    }
}

