/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import java.io.IOException;
import org.ws4d.java.client.AppSequenceBuffer;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.DefaultIncomingMessageListener;
import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.communication.IncomingMessageListener;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.concurrency.DeadlockException;
import org.ws4d.java.configuration.DispatchingProperties;
import org.ws4d.java.dispatch.DefaultDeviceReference;
import org.ws4d.java.dispatch.DuplicateServiceReferenceException;
import org.ws4d.java.dispatch.HelloData;
import org.ws4d.java.dispatch.ServiceReferenceFactory;
import org.ws4d.java.dispatch.ServiceReferenceInternal;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.service.LocalDevice;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedSet;
import org.ws4d.java.structures.LockedList;
import org.ws4d.java.structures.LockedMap;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.EprInfoSet;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.ProbeScopeSet;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.Log;

public abstract class DeviceServiceRegistry {
    private static final int[] DEVICE_LIFECYCLE_MESSAGE_TYPES = new int[]{1, 2};
    private static final IncomingMessageListener DEVICE_LIFECYCLE_LISTENER = new IncomingHelloByeListener();
    private static final int MAX_CACHE_SIZE = DispatchingProperties.getInstance().getServiceReferenceCacheSize();
    static final LockedMap DEVICE_REFS = new LockedMap();
    static final LockedMap SERVICE_REFS = new LockedMap();
    private static final LockedList DEVICES = new LockedList();
    private static final LockedList SERVICES = new LockedList();
    private static AppSequenceBuffer appSequenceBuffer = null;
    private static int appSequenceBufferUser = 0;
    private static final LinkedSet SERVICE_REFS_GARBAGE_LIST = new LinkedSet(MAX_CACHE_SIZE, true);

    private DeviceServiceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tearDown() {
        int n;
        Object object;
        Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
        while (iterator.hasNext()) {
            object = (CommunicationManager)iterator.next();
            try {
                object.unregisterDeviceReference(DEVICE_LIFECYCLE_MESSAGE_TYPES, null, DEVICE_LIFECYCLE_LISTENER);
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
        DEVICES.exclusiveLock();
        try {
            n = DEVICES.size();
            while (n-- > 0) {
                object = (LocalDevice)DEVICES.get(0);
                try {
                    object.stop();
                }
                catch (IOException iOException) {
                    Log.printStackTrace(iOException);
                }
            }
        }
        finally {
            DEVICES.releaseExclusiveLock();
        }
        SERVICES.exclusiveLock();
        try {
            n = SERVICES.size();
            while (n-- > 0) {
                object = (LocalService)SERVICES.get(0);
                try {
                    object.stop();
                }
                catch (IOException iOException) {
                    Log.printStackTrace(iOException);
                }
            }
        }
        finally {
            SERVICES.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceReference getDeviceReference(HelloData helloData) {
        if (helloData == null || helloData.getDiscoveryData() == null) {
            return null;
        }
        DEVICE_REFS.sharedLock();
        boolean bl = true;
        try {
            DefaultDeviceReference defaultDeviceReference;
            Object object = DEVICE_REFS.get(helloData.getEndpointReference());
            if (object != null) {
                DefaultDeviceReference defaultDeviceReference2 = (DefaultDeviceReference)object;
                if (defaultDeviceReference2.getPreferredXAddressInfo() != null && defaultDeviceReference2.getPreferredXAddressInfo().getProtocolInfo() != null && helloData.getProtocolData() != null) {
                    defaultDeviceReference2.getPreferredXAddressInfo().getProtocolInfo().merge(helloData.getProtocolData().getProtocolInfo());
                }
                DefaultDeviceReference defaultDeviceReference3 = defaultDeviceReference2;
                return defaultDeviceReference3;
            }
            try {
                DEVICE_REFS.exclusiveLock();
            }
            catch (DeadlockException deadlockException) {
                DEVICE_REFS.releaseSharedLock();
                bl = false;
                DeviceReference deviceReference = DeviceServiceRegistry.getDeviceReference(helloData);
                if (bl) {
                    DEVICE_REFS.releaseSharedLock();
                }
                return deviceReference;
            }
            try {
                DefaultDeviceReference defaultDeviceReference4 = new DefaultDeviceReference(helloData.getAppSequence(), helloData.getDiscoveryData(), helloData.getProtocolData());
                DEVICE_REFS.put(helloData.getEndpointReference(), defaultDeviceReference4);
                defaultDeviceReference = defaultDeviceReference4;
                DEVICE_REFS.releaseExclusiveLock();
            }
            catch (Throwable throwable) {
                DEVICE_REFS.releaseExclusiveLock();
                throw throwable;
            }
            return defaultDeviceReference;
        }
        finally {
            if (bl) {
                DEVICE_REFS.releaseSharedLock();
            }
        }
    }

    public static DeviceReference getDeviceReference(EndpointReference endpointReference) {
        return DeviceServiceRegistry.getDeviceReference(endpointReference, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceReference getDeviceReference(EndpointReference endpointReference, boolean bl) {
        if (endpointReference == null) {
            return null;
        }
        DEVICE_REFS.sharedLock();
        boolean bl2 = true;
        try {
            DefaultDeviceReference defaultDeviceReference;
            Object object = DEVICE_REFS.get(endpointReference);
            if (object != null || !bl) {
                DefaultDeviceReference defaultDeviceReference2 = (DefaultDeviceReference)object;
                return defaultDeviceReference2;
            }
            try {
                DEVICE_REFS.exclusiveLock();
            }
            catch (DeadlockException deadlockException) {
                DEVICE_REFS.releaseSharedLock();
                bl2 = false;
                DeviceReference deviceReference = DeviceServiceRegistry.getDeviceReference(endpointReference, bl);
                if (bl2) {
                    DEVICE_REFS.releaseSharedLock();
                }
                return deviceReference;
            }
            try {
                DefaultDeviceReference defaultDeviceReference3 = new DefaultDeviceReference(endpointReference);
                DEVICE_REFS.put(endpointReference, defaultDeviceReference3);
                defaultDeviceReference = defaultDeviceReference3;
                DEVICE_REFS.releaseExclusiveLock();
            }
            catch (Throwable throwable) {
                DEVICE_REFS.releaseExclusiveLock();
                throw throwable;
            }
            return defaultDeviceReference;
        }
        finally {
            if (bl2) {
                DEVICE_REFS.releaseSharedLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceReference getDeviceReference(EndpointReference endpointReference, XAddressInfoSet xAddressInfoSet, boolean bl) {
        if (endpointReference == null) {
            return null;
        }
        DEVICE_REFS.sharedLock();
        boolean bl2 = true;
        try {
            DefaultDeviceReference defaultDeviceReference;
            Object object = DEVICE_REFS.get(endpointReference);
            if (object != null || !bl) {
                DefaultDeviceReference defaultDeviceReference2 = (DefaultDeviceReference)object;
                return defaultDeviceReference2;
            }
            try {
                DEVICE_REFS.exclusiveLock();
            }
            catch (DeadlockException deadlockException) {
                DEVICE_REFS.releaseSharedLock();
                bl2 = false;
                DeviceReference deviceReference = DeviceServiceRegistry.getDeviceReference(endpointReference, xAddressInfoSet, bl);
                if (bl2) {
                    DEVICE_REFS.releaseSharedLock();
                }
                return deviceReference;
            }
            try {
                DefaultDeviceReference defaultDeviceReference3 = new DefaultDeviceReference(endpointReference, xAddressInfoSet);
                DEVICE_REFS.put(endpointReference, defaultDeviceReference3);
                defaultDeviceReference = defaultDeviceReference3;
                DEVICE_REFS.releaseExclusiveLock();
            }
            catch (Throwable throwable) {
                DEVICE_REFS.releaseExclusiveLock();
                throw throwable;
            }
            return defaultDeviceReference;
        }
        finally {
            if (bl2) {
                DEVICE_REFS.releaseSharedLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultDeviceReference getDeviceReference(LocalDevice localDevice) {
        EndpointReference endpointReference = localDevice.getEndpointReference();
        if (endpointReference == null) {
            return null;
        }
        DEVICE_REFS.sharedLock();
        boolean bl = true;
        try {
            DefaultDeviceReference defaultDeviceReference;
            Object object = DEVICE_REFS.get(endpointReference);
            if (object != null) {
                DEVICE_REFS.releaseSharedLock();
                bl = false;
                DefaultDeviceReference defaultDeviceReference2 = (DefaultDeviceReference)object;
                defaultDeviceReference2.setLocalDevice(localDevice);
                DefaultDeviceReference defaultDeviceReference3 = defaultDeviceReference2;
                return defaultDeviceReference3;
            }
            try {
                DEVICE_REFS.exclusiveLock();
            }
            catch (DeadlockException deadlockException) {
                DEVICE_REFS.releaseSharedLock();
                bl = false;
                DefaultDeviceReference defaultDeviceReference4 = DeviceServiceRegistry.getDeviceReference(localDevice);
                if (bl) {
                    DEVICE_REFS.releaseSharedLock();
                }
                return defaultDeviceReference4;
            }
            try {
                DefaultDeviceReference defaultDeviceReference5 = new DefaultDeviceReference(localDevice);
                DEVICE_REFS.put(endpointReference, defaultDeviceReference5);
                defaultDeviceReference = defaultDeviceReference5;
                DEVICE_REFS.releaseExclusiveLock();
            }
            catch (Throwable throwable) {
                DEVICE_REFS.releaseExclusiveLock();
                throw throwable;
            }
            return defaultDeviceReference;
        }
        finally {
            if (bl) {
                DEVICE_REFS.releaseSharedLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference createServiceReference(EndpointReference endpointReference, QNameSet qNameSet, String string, ProtocolData protocolData) throws DuplicateServiceReferenceException {
        SERVICE_REFS.exclusiveLock();
        try {
            Object object = SERVICE_REFS.get(endpointReference);
            if (object != null) {
                throw new DuplicateServiceReferenceException("Existing service reference with equal endpoint reference found: " + object);
            }
            HostedMData hostedMData = new HostedMData();
            EprInfoSet eprInfoSet = new EprInfoSet();
            eprInfoSet.add(new EprInfo(endpointReference, string));
            hostedMData.setEprInfoSet(eprInfoSet);
            hostedMData.setTypes(qNameSet);
            ServiceReferenceInternal serviceReferenceInternal = ServiceReferenceFactory.getInstance().newServiceReference(hostedMData, string, protocolData);
            DeviceServiceRegistry.addServiceReferenceToGarbageList(serviceReferenceInternal);
            SERVICE_REFS.put(endpointReference, serviceReferenceInternal);
            ServiceReferenceInternal serviceReferenceInternal2 = serviceReferenceInternal;
            return serviceReferenceInternal2;
        }
        finally {
            SERVICE_REFS.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getUpdatedServiceReference(HostedMData hostedMData, DeviceReference deviceReference, String string, ProtocolData protocolData) {
        ServiceReferenceInternal serviceReferenceInternal = null;
        SERVICE_REFS.sharedLock();
        try {
            serviceReferenceInternal = DeviceServiceRegistry.getFirstMatchingServiceReferenceForReuse(hostedMData);
        }
        finally {
            SERVICE_REFS.releaseSharedLock();
        }
        if (serviceReferenceInternal != null) {
            serviceReferenceInternal.update(hostedMData, deviceReference, protocolData);
            return serviceReferenceInternal;
        }
        SERVICE_REFS.exclusiveLock();
        try {
            serviceReferenceInternal = DeviceServiceRegistry.getFirstMatchingServiceReferenceForReuse(hostedMData);
            if (serviceReferenceInternal != null) {
                serviceReferenceInternal.update(hostedMData, deviceReference, protocolData);
                ServiceReferenceInternal serviceReferenceInternal2 = serviceReferenceInternal;
                return serviceReferenceInternal2;
            }
            serviceReferenceInternal = ServiceReferenceFactory.getInstance().newServiceReference(hostedMData, string, protocolData);
            Object object = hostedMData.getEprInfoSet().iterator();
            while (object.hasNext()) {
                EprInfo eprInfo = (EprInfo)object.next();
                SERVICE_REFS.put(eprInfo.getEndpointReference(), serviceReferenceInternal);
            }
            if (deviceReference != null && serviceReferenceInternal.getParentDeviceRef() == null) {
                serviceReferenceInternal.setParentDeviceReference(deviceReference);
            }
            object = serviceReferenceInternal;
            return object;
        }
        finally {
            SERVICE_REFS.releaseExclusiveLock();
        }
    }

    private static ServiceReferenceInternal getFirstMatchingServiceReferenceForReuse(HostedMData hostedMData) {
        Iterator iterator = hostedMData.getEprInfoSet().iterator();
        while (iterator.hasNext()) {
            EprInfo eprInfo = (EprInfo)iterator.next();
            Object object = SERVICE_REFS.get(eprInfo.getEndpointReference());
            if (object == null) continue;
            ServiceReferenceInternal serviceReferenceInternal = (ServiceReferenceInternal)object;
            DeviceServiceRegistry.removeServiceReferenceFromGarbageList(serviceReferenceInternal);
            return serviceReferenceInternal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(EndpointReference endpointReference, String string, boolean bl) {
        if (endpointReference == null) {
            return null;
        }
        SERVICE_REFS.sharedLock();
        boolean bl2 = true;
        try {
            ServiceReferenceInternal serviceReferenceInternal;
            Object object = SERVICE_REFS.get(endpointReference);
            if (object != null || !bl) {
                ServiceReference serviceReference = (ServiceReference)SERVICE_REFS.get(endpointReference);
                return serviceReference;
            }
            try {
                SERVICE_REFS.exclusiveLock();
            }
            catch (DeadlockException deadlockException) {
                SERVICE_REFS.releaseSharedLock();
                bl2 = false;
                ServiceReference serviceReference = DeviceServiceRegistry.getServiceReference(endpointReference, string, bl);
                if (bl2) {
                    SERVICE_REFS.releaseSharedLock();
                }
                return serviceReference;
            }
            try {
                ServiceReferenceInternal serviceReferenceInternal2 = ServiceReferenceFactory.getInstance().newServiceReference(endpointReference, string);
                DeviceServiceRegistry.addServiceReferenceToGarbageList(serviceReferenceInternal2);
                SERVICE_REFS.put(endpointReference, serviceReferenceInternal2);
                serviceReferenceInternal = serviceReferenceInternal2;
                SERVICE_REFS.releaseExclusiveLock();
            }
            catch (Throwable throwable) {
                SERVICE_REFS.releaseExclusiveLock();
                throw throwable;
            }
            return serviceReferenceInternal;
        }
        finally {
            if (bl2) {
                SERVICE_REFS.releaseSharedLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceReferenceInternal updateServiceReferenceRegistration(HostedMData hostedMData, ServiceReferenceInternal serviceReferenceInternal) {
        EprInfoSet eprInfoSet = hostedMData.getEprInfoSet();
        SERVICE_REFS.exclusiveLock();
        try {
            EprInfo eprInfo;
            Iterator iterator = serviceReferenceInternal.getEprInfos();
            while (iterator.hasNext()) {
                eprInfo = (EprInfo)iterator.next();
                if (eprInfoSet.contains(eprInfo)) continue;
                SERVICE_REFS.remove(eprInfo.getEndpointReference());
            }
            iterator = eprInfoSet.iterator();
            while (iterator.hasNext()) {
                eprInfo = (EprInfo)iterator.next();
                SERVICE_REFS.put(eprInfo.getEndpointReference(), serviceReferenceInternal);
            }
        }
        finally {
            SERVICE_REFS.releaseExclusiveLock();
        }
        return serviceReferenceInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addServiceReferenceToGarbageList(ServiceReference serviceReference) {
        if (serviceReference == null) {
            return;
        }
        ServiceReference serviceReference2 = null;
        LinkedSet linkedSet = SERVICE_REFS_GARBAGE_LIST;
        synchronized (linkedSet) {
            if (SERVICE_REFS_GARBAGE_LIST.size() >= MAX_CACHE_SIZE) {
                serviceReference2 = (ServiceReference)SERVICE_REFS_GARBAGE_LIST.removeFirst();
            }
            SERVICE_REFS_GARBAGE_LIST.add(serviceReference);
        }
        if (serviceReference2 != null) {
            DeviceServiceRegistry.unregisterServiceReference(serviceReference2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateServiceReferenceInGarbageList(ServiceReference serviceReference) {
        LinkedSet linkedSet = SERVICE_REFS_GARBAGE_LIST;
        synchronized (linkedSet) {
            SERVICE_REFS_GARBAGE_LIST.touch(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServiceReferenceFromGarbageList(ServiceReference serviceReference) {
        LinkedSet linkedSet = SERVICE_REFS_GARBAGE_LIST;
        synchronized (linkedSet) {
            SERVICE_REFS_GARBAGE_LIST.remove(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataStructure getLocalDeviceReferences(QNameSet qNameSet, ProbeScopeSet probeScopeSet) {
        DEVICES.sharedLock();
        try {
            HashSet hashSet = new HashSet();
            Object object = DEVICES.iterator();
            while (object.hasNext()) {
                LocalDevice localDevice = (LocalDevice)object.next();
                if (!localDevice.deviceMatches(qNameSet, probeScopeSet)) continue;
                ((DataStructure)hashSet).add(localDevice.getDeviceReference());
            }
            object = hashSet;
            return object;
        }
        finally {
            DEVICES.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataStructure getLocalServiceReferences(QNameSet qNameSet, QNameSet qNameSet2, ProbeScopeSet probeScopeSet) {
        ArrayList arrayList = new ArrayList();
        if (qNameSet2 != null && qNameSet2.size() > 0 || probeScopeSet != null && probeScopeSet.size() > 0) {
            DEVICES.sharedLock();
            try {
                Iterator iterator = DEVICES.iterator();
                while (iterator.hasNext()) {
                    LocalDevice localDevice = (LocalDevice)iterator.next();
                    if (!localDevice.deviceMatches(qNameSet2, probeScopeSet)) continue;
                    localDevice.addServiceReferences(arrayList, qNameSet);
                }
            }
            finally {
                DEVICES.releaseSharedLock();
            }
        }
        SERVICES.sharedLock();
        try {
            Iterator iterator = SERVICES.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                ServiceReference serviceReference = service.getServiceReference();
                if (!qNameSet.isContainedBy(serviceReference.getPortTypes())) continue;
                ((DataStructure)arrayList).add(serviceReference);
            }
        }
        finally {
            SERVICES.releaseSharedLock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterDeviceReference(DefaultDeviceReference defaultDeviceReference) {
        if (defaultDeviceReference == null) {
            return;
        }
        EndpointReference endpointReference = defaultDeviceReference.getEndpointReference();
        DEVICE_REFS.exclusiveLock();
        try {
            if (DEVICE_REFS.remove(endpointReference) == null) {
                return;
            }
        }
        finally {
            DEVICE_REFS.releaseExclusiveLock();
        }
        defaultDeviceReference.disconnectAllServiceReferences(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterServiceReference(ServiceReference serviceReference) {
        Object object;
        Iterator iterator = serviceReference.getEprInfos();
        if (!iterator.hasNext()) {
            Log.error("ERROR: DeviceServiceRegistry.unregisterServiceReference0: no epr in service");
            return;
        }
        SERVICE_REFS.exclusiveLock();
        try {
            while (iterator.hasNext()) {
                object = (EprInfo)iterator.next();
                SERVICE_REFS.remove(((EprInfo)object).getEndpointReference());
            }
        }
        finally {
            SERVICE_REFS.releaseExclusiveLock();
        }
        object = (ServiceReferenceInternal)serviceReference;
        object.setService(null, null);
        DeviceServiceRegistry.removeServiceReferenceFromGarbageList((ServiceReference)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceReference getUpdatedDeviceReference(DiscoveryData discoveryData, Message message, ProtocolData protocolData) {
        EndpointReference endpointReference = discoveryData.getEndpointReference();
        DEVICE_REFS.sharedLock();
        boolean bl = true;
        try {
            DefaultDeviceReference defaultDeviceReference = (DefaultDeviceReference)DEVICE_REFS.get(endpointReference);
            if (defaultDeviceReference != null) {
                DEVICE_REFS.releaseSharedLock();
                bl = false;
                if (defaultDeviceReference.getLocation() == 2 || !defaultDeviceReference.checkAppSequence(message.getAppSequence())) {
                    DefaultDeviceReference defaultDeviceReference2 = defaultDeviceReference;
                    return defaultDeviceReference2;
                }
                defaultDeviceReference.updateDiscoveryData(discoveryData, protocolData);
            } else {
                try {
                    DEVICE_REFS.exclusiveLock();
                }
                catch (DeadlockException deadlockException) {
                    DEVICE_REFS.releaseSharedLock();
                    bl = false;
                    DeviceReference deviceReference = DeviceServiceRegistry.getUpdatedDeviceReference(discoveryData, message, protocolData);
                    if (bl) {
                        DEVICE_REFS.releaseSharedLock();
                    }
                    return deviceReference;
                }
                try {
                    defaultDeviceReference = new DefaultDeviceReference(message.getAppSequence(), discoveryData, protocolData);
                    if (defaultDeviceReference.getPreferredXAddressInfo().getProtocolInfo() != null) {
                        defaultDeviceReference.getPreferredXAddressInfo().getProtocolInfo().merge(message.getProtocolInfo());
                    } else {
                        defaultDeviceReference.getPreferredXAddressInfo().setProtocolInfo(message.getProtocolInfo());
                    }
                    DEVICE_REFS.put(endpointReference, defaultDeviceReference);
                }
                finally {
                    DEVICE_REFS.releaseExclusiveLock();
                }
            }
            defaultDeviceReference.setSecureDevice(message.isSecure());
            DefaultDeviceReference defaultDeviceReference3 = defaultDeviceReference;
            return defaultDeviceReference3;
        }
        finally {
            if (bl) {
                DEVICE_REFS.releaseSharedLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(LocalDevice localDevice) {
        DEVICES.exclusiveLock();
        try {
            if (DEVICES.contains(localDevice)) {
                return;
            }
            DEVICES.add(localDevice);
        }
        finally {
            DEVICES.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(LocalDevice localDevice) {
        DEVICES.exclusiveLock();
        try {
            DEVICES.remove(localDevice);
        }
        finally {
            DEVICES.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(LocalService localService) {
        SERVICES.exclusiveLock();
        try {
            if (SERVICES.contains(localService)) {
                return;
            }
            SERVICES.add(localService);
        }
        finally {
            SERVICES.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(LocalService localService) {
        SERVICES.exclusiveLock();
        try {
            SERVICES.remove(localService);
        }
        finally {
            SERVICES.releaseExclusiveLock();
        }
    }

    public static void register(DiscoveryBinding discoveryBinding) {
        Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
        while (iterator.hasNext()) {
            CommunicationManager communicationManager = (CommunicationManager)iterator.next();
            try {
                communicationManager.registerDeviceReference(DEVICE_LIFECYCLE_MESSAGE_TYPES, discoveryBinding, DEVICE_LIFECYCLE_LISTENER);
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
    }

    public static void unregister(DiscoveryBinding discoveryBinding) {
        Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
        while (iterator.hasNext()) {
            CommunicationManager communicationManager = (CommunicationManager)iterator.next();
            try {
                communicationManager.unregisterDeviceReference(DEVICE_LIFECYCLE_MESSAGE_TYPES, discoveryBinding, DEVICE_LIFECYCLE_LISTENER);
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
    }

    public static synchronized boolean checkAndUpdateAppSequence(EndpointReference endpointReference, AppSequence appSequence) {
        if (appSequenceBufferUser == 0) {
            return true;
        }
        return appSequenceBuffer.checkAndUpdate(endpointReference, appSequence);
    }

    public static synchronized void incAppSequenceUser() {
        if (appSequenceBufferUser++ == 0) {
            appSequenceBuffer = new AppSequenceBuffer();
        }
    }

    public static synchronized void decAppSequenceUser() {
        if (appSequenceBufferUser-- == 1) {
            appSequenceBuffer = null;
        } else if (appSequenceBufferUser == -1) {
            ++appSequenceBufferUser;
            throw new RuntimeException("Cannot decrease Application Sequence Buffer User.");
        }
    }

    private static class IncomingHelloByeListener
    extends DefaultIncomingMessageListener {
        private IncomingHelloByeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HelloMessage helloMessage, ProtocolData protocolData) {
            block17: {
                EndpointReference endpointReference;
                DiscoveryData discoveryData = helloMessage.getDiscoveryData();
                if (discoveryData == null || (endpointReference = discoveryData.getEndpointReference()) == null) {
                    return;
                }
                DEVICE_REFS.sharedLock();
                boolean bl = true;
                try {
                    DefaultDeviceReference defaultDeviceReference = (DefaultDeviceReference)DEVICE_REFS.get(endpointReference);
                    if (defaultDeviceReference != null) {
                        DEVICE_REFS.releaseSharedLock();
                        bl = false;
                        if (defaultDeviceReference.getLocation() == 2) {
                            return;
                        }
                        defaultDeviceReference.updateFromHello(helloMessage, protocolData);
                        break block17;
                    }
                    if (DispatchingProperties.getInstance().isDeviceReferenceAutoBuild()) {
                        try {
                            DEVICE_REFS.exclusiveLock();
                        }
                        catch (DeadlockException deadlockException) {
                            DEVICE_REFS.releaseSharedLock();
                            bl = false;
                            this.handle(helloMessage, protocolData);
                            if (bl) {
                                DEVICE_REFS.releaseSharedLock();
                            }
                            return;
                        }
                        try {
                            defaultDeviceReference = new DefaultDeviceReference(helloMessage.getAppSequence(), discoveryData, protocolData);
                            DEVICE_REFS.put(endpointReference, defaultDeviceReference);
                        }
                        finally {
                            DEVICE_REFS.releaseExclusiveLock();
                        }
                        if (Log.isInfo()) {
                            Log.info("Set DPWS Version for " + defaultDeviceReference.getEndpointReference().toString() + " to : " + defaultDeviceReference.getPreferredXAddressInfo().getProtocolInfo());
                        }
                        defaultDeviceReference.setSecureDevice(helloMessage.getHeader().getSignature() != null);
                        break block17;
                    }
                    return;
                }
                finally {
                    if (bl) {
                        DEVICE_REFS.releaseSharedLock();
                    }
                }
            }
        }

        public void handle(ByeMessage byeMessage, ProtocolData protocolData) {
            EndpointReference endpointReference;
            if (byeMessage == null || (endpointReference = byeMessage.getEndpointReference()) == null) {
                return;
            }
            Object object = DEVICE_REFS.get(endpointReference);
            if (object != null) {
                DefaultDeviceReference defaultDeviceReference = (DefaultDeviceReference)object;
                if (defaultDeviceReference.getLocation() == 2) {
                    return;
                }
                defaultDeviceReference.updateFromBye(byeMessage, protocolData);
            }
        }
    }
}

