/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.Discovery;
import org.ws4d.java.communication.ProtocolDomain;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;

public class OutDispatcher {
    private static final OutDispatcher INSTANCE = new OutDispatcher();

    public static OutDispatcher getInstance() {
        return INSTANCE;
    }

    private OutDispatcher() {
    }

    public void send(HelloMessage helloMessage, XAddressInfo xAddressInfo, DataStructure dataStructure) {
        this.sendMulticast(helloMessage, xAddressInfo, dataStructure, null);
    }

    public void send(ByeMessage byeMessage, XAddressInfo xAddressInfo, DataStructure dataStructure) {
        this.sendMulticast(byeMessage, xAddressInfo, dataStructure, null);
    }

    public void send(ProbeMessage probeMessage, XAddressInfo xAddressInfo, DataStructure dataStructure, ResponseCallback responseCallback) {
        this.sendMulticast(probeMessage, xAddressInfo, dataStructure, responseCallback);
    }

    public void send(ResolveMessage resolveMessage, XAddressInfo xAddressInfo, DataStructure dataStructure, ResponseCallback responseCallback) {
        this.sendMulticast(resolveMessage, xAddressInfo, dataStructure, responseCallback);
    }

    public void send(ProbeMessage probeMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(probeMessage, xAddressInfo, responseCallback);
    }

    public void send(GetMessage getMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(getMessage, xAddressInfo, responseCallback);
    }

    public void send(GetMetadataMessage getMetadataMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(getMetadataMessage, xAddressInfo, responseCallback);
    }

    public void send(SubscribeMessage subscribeMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(subscribeMessage, xAddressInfo, responseCallback);
    }

    public void send(GetStatusMessage getStatusMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(getStatusMessage, xAddressInfo, responseCallback);
    }

    public void send(RenewMessage renewMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(renewMessage, xAddressInfo, responseCallback);
    }

    public void send(UnsubscribeMessage unsubscribeMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(unsubscribeMessage, xAddressInfo, responseCallback);
    }

    public void send(SubscriptionEndMessage subscriptionEndMessage, XAddressInfo xAddressInfo) {
        this.sendUnicast(subscriptionEndMessage, xAddressInfo, null);
    }

    public void send(InvokeMessage invokeMessage, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        this.sendUnicast(invokeMessage, xAddressInfo, responseCallback);
    }

    private void sendMulticast(Message message, XAddressInfo xAddressInfo, DataStructure dataStructure, ResponseCallback responseCallback) {
        if (message == null) {
            return;
        }
        if (message.getRoutingScheme() == 0) {
            message.setRoutingScheme(2);
        }
        if (dataStructure == null) {
            dataStructure = Discovery.getDefaultOutputDomains();
        }
        if (dataStructure.isEmpty()) {
            dataStructure = Discovery.getAllAvailableDomains();
        }
        this.preSend(message);
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            ProtocolDomain protocolDomain = (ProtocolDomain)iterator.next();
            CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(protocolDomain.getCommunicationManagerId());
            communicationManager.send(message, xAddressInfo, protocolDomain, responseCallback);
        }
    }

    private void sendUnicast(Message message, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        String string;
        if (message == null) {
            return;
        }
        if (message.getRoutingScheme() == 0) {
            message.setRoutingScheme(1);
        }
        if ((string = xAddressInfo.getComManId()) == null) {
            string = CommunicationManagerRegistry.getDefault();
        }
        this.preSend(message);
        CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(string);
        communicationManager.send(message, xAddressInfo, null, responseCallback);
    }

    private void preSend(Message message) {
        message.setInbound(false);
        if (Log.isDebug()) {
            Log.debug("<O> " + message, 1);
        }
    }

    public void sendGenericMessage(Message message, XAddressInfo xAddressInfo, ResponseCallback responseCallback) {
        if (message != null && message.getRoutingScheme() == 1) {
            this.sendUnicast(message, xAddressInfo, responseCallback);
            return;
        }
        CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(xAddressInfo.getComManId());
        if (communicationManager != null) {
            communicationManager.send(message, xAddressInfo, null, responseCallback);
        }
    }

    public void sendGenericMessageToProtocolDomain(Message message, XAddressInfo xAddressInfo, DataStructure dataStructure, ResponseCallback responseCallback) {
        if (message != null && message.getRoutingScheme() == 2) {
            this.sendMulticast(message, xAddressInfo, dataStructure, responseCallback);
        } else if (Log.isInfo()) {
            Log.info("Could not send message as multicast. " + message);
        }
    }
}

