/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.structures.LockedMap;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public class RequestResponseCoordinator {
    protected final LockedMap map_msgId_2_entry = new LockedMap();
    protected static RequestResponseCoordinator rrc = new RequestResponseCoordinator();

    private RequestResponseCoordinator() {
    }

    public static RequestResponseCoordinator getInstance() {
        return rrc;
    }

    public void registerResponseCallback(Message message, ResponseCallback responseCallback, long l) {
        TimedResponseCallback timedResponseCallback = new TimedResponseCallback(message, responseCallback);
        WatchDog.getInstance().register(timedResponseCallback, l);
        this.map_msgId_2_entry.put(message.getMessageId(), timedResponseCallback);
    }

    public void handleResponse(Message message, ProtocolData protocolData) {
        AttributedURI attributedURI = message.getRelatesTo();
        switch (message.getType()) {
            case 4: {
                ProbeMatchesMessage probeMatchesMessage = (ProbeMatchesMessage)message;
                TimedResponseCallback timedResponseCallback = this.getCallback(attributedURI);
                if (timedResponseCallback == null) break;
                timedResponseCallback.callback.handle(timedResponseCallback.request, probeMatchesMessage, protocolData);
                break;
            }
            case 6: {
                ResolveMatchesMessage resolveMatchesMessage = (ResolveMatchesMessage)message;
                TimedResponseCallback timedResponseCallback = this.getCallback(attributedURI);
                if (timedResponseCallback == null) break;
                timedResponseCallback.callback.handle(timedResponseCallback.request, resolveMatchesMessage, protocolData);
                break;
            }
            default: {
                Log.error("Cannot determine response message type. Message = " + message);
            }
        }
    }

    public boolean containsMsgId(URI uRI) {
        return this.map_msgId_2_entry.containsKey(uRI);
    }

    private TimedResponseCallback getCallback(URI uRI) {
        return (TimedResponseCallback)this.map_msgId_2_entry.get(uRI);
    }

    private class TimedResponseCallback
    extends TimedEntry {
        Message request;
        ResponseCallback callback;

        TimedResponseCallback(Message message, ResponseCallback responseCallback) {
            this.request = message;
            this.callback = responseCallback;
        }

        public void timedOut() {
            RequestResponseCoordinator.this.map_msgId_2_entry.remove(this.request.getMessageId());
            this.callback.handleTimeout(this.request);
        }
    }
}

