/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.dispatch.DefaultServiceReference;
import org.ws4d.java.dispatch.DefaultServiceReferenceCallback;
import org.ws4d.java.dispatch.ServiceReferenceInternal;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;

public class ServiceReferenceFactory {
    private static final ServiceReferenceFactory INSTANCE;

    public static ServiceReferenceFactory getInstance() {
        return INSTANCE;
    }

    public ServiceReferenceInternal newServiceReference(HostedMData hostedMData, String string, ProtocolData protocolData) {
        return new DefaultServiceReference(hostedMData, string, protocolData);
    }

    public ServiceReferenceInternal newServiceReference(EndpointReference endpointReference, String string) {
        return new DefaultServiceReference(endpointReference, string);
    }

    public ResponseCallback newResponseCallbackForServiceReference(ServiceReference serviceReference, XAddressInfo xAddressInfo) {
        return new DefaultServiceReferenceCallback((DefaultServiceReference)serviceReference, xAddressInfo);
    }

    static {
        String string = FrameworkProperties.getInstance().getServiceReferenceFactoryClass();
        ServiceReferenceFactory serviceReferenceFactory = null;
        if (string == null) {
            serviceReferenceFactory = new ServiceReferenceFactory();
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                serviceReferenceFactory = (ServiceReferenceFactory)clazz.newInstance();
                Log.info("Using " + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.error("ServiceReferenceFactory: Configured ServiceReferenceFactory class [" + string + "] not found, falling back to default implementation");
                serviceReferenceFactory = new ServiceReferenceFactory();
            }
            catch (Exception exception) {
                Log.error("ServiceReferenceFactory: Unable to create instance of configured ServiceReferenceFactory class [" + string + "], falling back to default implementation");
                Log.printStackTrace(exception);
                serviceReferenceFactory = new ServiceReferenceFactory();
            }
        }
        INSTANCE = serviceReferenceFactory;
    }
}

