/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.eventing;

import java.io.IOException;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.DefaultIncomingMessageListener;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.communication.protocol.soap.generator.handlers.ClientSubscriptionElementHandler;
import org.ws4d.java.configuration.EventingProperties;
import org.ws4d.java.constants.SOAPConstants;
import org.ws4d.java.constants.WSAConstants;
import org.ws4d.java.constants.WSEConstants;
import org.ws4d.java.eventing.ClientSubscription;
import org.ws4d.java.eventing.EventListener;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventSource;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.io.xml.ElementHandlerRegistry;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.schema.PredefinedSchemaTypes;
import org.ws4d.java.service.DefaultClientSubscription;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.parameter.QNameValue;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LockedMap;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.util.WS4DIllegalStateException;

public class DefaultEventSink
implements EventSink {
    private static final int[] EVENT_SINK_MESSAGE_TYPES = new int[]{400, 309};
    private final EventSinkMessageListener incomingListener = new EventSinkMessageListener();
    private final DataStructure bindings = new ArrayList();
    private final EventListener eventListener;
    private boolean registered = false;
    private HashMap map_CSubId_2_CSub = new LockedMap(new HashMap(5));

    private DefaultEventSink(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public DefaultEventSink(EventListener eventListener, DataStructure dataStructure) {
        this(eventListener);
        if (dataStructure != null) {
            this.bindings.addAll(dataStructure);
        }
    }

    public DefaultEventSink(EventListener eventListener, int n) {
        this(eventListener);
        this.bindings.addAll(EventingProperties.getInstance().getBindings(new Integer(n)));
    }

    public boolean hasBindings() {
        return this.bindings.size() > 0;
    }

    public Iterator getBindings() {
        return new ReadOnlyIterator(this.bindings);
    }

    public boolean supportsBindingChanges() {
        return !this.registered;
    }

    public void addBinding(CommunicationBinding communicationBinding) throws WS4DIllegalStateException {
        if (this.registered) {
            throw new WS4DIllegalStateException("Event Sink is already running, unable to add binding");
        }
        this.bindings.add(communicationBinding);
    }

    public boolean removeBinding(CommunicationBinding communicationBinding) throws WS4DIllegalStateException {
        if (this.registered) {
            throw new WS4DIllegalStateException("Event Sink is already running, unable to remove binding");
        }
        return this.bindings.remove(communicationBinding);
    }

    public void clearBindings() throws WS4DIllegalStateException {
        if (this.registered) {
            throw new WS4DIllegalStateException("Event Sink is already running, unable to clear bindings");
        }
        this.bindings.clear();
    }

    public void open() throws EventingException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.registered) {
            if (Log.isDebug()) {
                Log.debug("EventSink already opened", 4);
            }
            return;
        }
        if (!this.hasBindings()) {
            object4 = StringUtil.simpleClassName(this.getClass());
            if (Log.isDebug()) {
                Log.debug("No bindings found, autobinding event sink " + (String)object4, 4);
            }
            object3 = new HashSet();
            object2 = CommunicationManagerRegistry.getLoadedManagers();
            while (object2.hasNext()) {
                object = (CommunicationManager)object2.next();
                try {
                    object.getAutobindings((String)object4, (DataStructure)object3);
                }
                catch (IOException iOException) {
                    Log.error("Unable to obtain autobindings from communication manager " + object.getCommunicationManagerId());
                    Log.printStackTrace(iOException);
                }
            }
            object2 = ((DataStructure)object3).iterator();
            while (object2.hasNext()) {
                object = (CommunicationBinding)object2.next();
                this.addBinding((CommunicationBinding)object);
            }
        }
        object4 = this.bindings.iterator();
        while (object4.hasNext()) {
            object3 = (CommunicationBinding)object4.next();
            try {
                object2 = CommunicationManagerRegistry.getManager(object3.getCommunicationManagerId());
                object2.registerService(EVENT_SINK_MESSAGE_TYPES, (CommunicationBinding)object3, this.incomingListener, null);
            }
            catch (IOException iOException) {
                object = new EventingException("Unable to bind Event Sink to " + object3.getTransportAddress() + ": " + iOException);
                Log.printStackTrace((Throwable)object);
                throw object;
            }
        }
        this.registered = true;
    }

    public void close() {
        Iterator iterator = this.bindings.iterator();
        while (iterator.hasNext()) {
            CommunicationBinding communicationBinding = (CommunicationBinding)iterator.next();
            try {
                CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(communicationBinding.getCommunicationManagerId());
                communicationManager.unregisterService(EVENT_SINK_MESSAGE_TYPES, communicationBinding, this.incomingListener);
            }
            catch (IOException iOException) {
                Log.error("unable to unbind from " + communicationBinding.getTransportAddress());
                iOException.printStackTrace();
            }
        }
        this.map_CSubId_2_CSub.clear();
        this.registered = false;
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public boolean isOpen() {
        return this.registered;
    }

    public ClientSubscription getSubscription(String string) {
        return (ClientSubscription)this.map_CSubId_2_CSub.get(string);
    }

    public ClientSubscription removeSubscription(String string) {
        return (ClientSubscription)this.map_CSubId_2_CSub.remove(string);
    }

    public void addSubscription(String string, ClientSubscription clientSubscription) {
        this.map_CSubId_2_CSub.put(string, clientSubscription);
    }

    public ParameterValue receiveLocalEvent(String string, URI uRI, ParameterValue parameterValue) {
        ClientSubscription clientSubscription = (ClientSubscription)this.map_CSubId_2_CSub.get(string);
        return this.eventListener.eventReceived(clientSubscription, uRI, parameterValue);
    }

    static {
        ElementHandlerRegistry.getRegistry().registerElementHandler(WSEConstants.WSE_QN_IDENTIFIER, new ClientSubscriptionElementHandler());
    }

    private final class EventSinkMessageListener
    extends DefaultIncomingMessageListener {
        private EventSinkMessageListener() {
        }

        public InvokeMessage handle(InvokeMessage invokeMessage, ProtocolData protocolData) throws SOAPException {
            if (!DefaultEventSink.this.isOpen()) {
                throw new SOAPException(FaultMessage.createEndpointUnavailableFault(invokeMessage));
            }
            String string = null;
            if (invokeMessage.getHeader().getWseIdentifier() == null) {
                Log.error("A header representing the eventListener supbscription ID (as part of the [reference parameters]) is missing.");
            } else {
                string = invokeMessage.getHeader().getWseIdentifier();
            }
            if (string == null) {
                FaultMessage faultMessage = new FaultMessage("http://www.w3.org/2005/08/addressing/fault", protocolData.getCommunicationManagerId());
                faultMessage.setResponseTo(invokeMessage);
                faultMessage.setCode(SOAPConstants.SOAP_FAULT_SENDER);
                faultMessage.setSubcode(WSAConstants.WSA_FAULT_INVALID_ADDRESSING_HEADER);
                LocalizedString localizedString = new LocalizedString("A header representing the eventListener supbscription ID (as part of the [reference parameters]) is missing", null);
                faultMessage.addReason(localizedString);
                ParameterValue parameterValue = ParameterValue.createElementValue(PredefinedSchemaTypes.WSA_PROBLEM_HEADER_QNAME);
                if (parameterValue.getValueType() == 3) {
                    QNameValue qNameValue = (QNameValue)parameterValue;
                    qNameValue.set(new QName("Identifier", "http://schemas.xmlsoap.org/ws/2004/08/eventing"));
                }
                faultMessage.setDetail(parameterValue);
                throw new SOAPException(faultMessage);
            }
            ClientSubscription clientSubscription = (ClientSubscription)DefaultEventSink.this.map_CSubId_2_CSub.get(string);
            if (clientSubscription == null) {
                FaultMessage faultMessage = new FaultMessage("http://www.w3.org/2005/08/addressing/fault", protocolData.getCommunicationManagerId());
                faultMessage.setResponseTo(invokeMessage);
                faultMessage.setCode(SOAPConstants.SOAP_FAULT_SENDER);
                faultMessage.setSubcode(WSAConstants.WSA_FAULT_INVALID_ADDRESSING_HEADER);
                LocalizedString localizedString = new LocalizedString("Unknown eventListener supbscription ID found: " + string, null);
                faultMessage.addReason(localizedString);
                ParameterValue parameterValue = ParameterValue.createElementValue(PredefinedSchemaTypes.WSA_PROBLEM_HEADER_QNAME);
                if (parameterValue.getValueType() == 3) {
                    QNameValue qNameValue = (QNameValue)parameterValue;
                    qNameValue.set(new QName("Identifier", "http://schemas.xmlsoap.org/ws/2004/08/eventing"));
                }
                faultMessage.setDetail(parameterValue);
                throw new SOAPException(faultMessage);
            }
            ParameterValue parameterValue = DefaultEventSink.this.eventListener.eventReceived(clientSubscription, invokeMessage.getAction(), invokeMessage.getContent());
            if (parameterValue != null) {
                String string2 = invokeMessage.getAction().toString();
                try {
                    Service service = clientSubscription.getServiceReference().getService();
                    EventSource eventSource = service.getEventSource(string2);
                    String string3 = eventSource.getInputAction();
                    InvokeMessage invokeMessage2 = new InvokeMessage(string3, false, protocolData.getCommunicationManagerId());
                    invokeMessage2.setResponseTo(invokeMessage);
                    invokeMessage2.setProtocolInfo(invokeMessage.getProtocolInfo());
                    invokeMessage2.setContent(parameterValue);
                    return invokeMessage2;
                }
                catch (TimeoutException timeoutException) {
                    Log.error("EventSink.handleMessage(Invoke): can't get service (timeout).");
                    timeoutException.printStackTrace();
                    throw new SOAPException(FaultMessage.createEndpointUnavailableFault(invokeMessage));
                }
            }
            return null;
        }

        public void handle(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
            if (!DefaultEventSink.this.isOpen()) {
                return;
            }
            String string = subscriptionEndMessage.getSubscriptionManager().getReferenceParameters().getWseIdentifier();
            if (string == null) {
                Log.error("DefaultEventSink.handleMessage(SubscriptionEnd): received subscription end message without service subscription id");
                return;
            }
            DefaultClientSubscription defaultClientSubscription = null;
            DataStructure dataStructure = DefaultEventSink.this.map_CSubId_2_CSub.values();
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                String string2;
                defaultClientSubscription = (DefaultClientSubscription)iterator.next();
                if (defaultClientSubscription == null || !string.equals(string2 = defaultClientSubscription.getServiceSubscriptionId())) continue;
                URI uRI = subscriptionEndMessage.getStatus();
                DefaultEventSink.this.eventListener.subscriptionEndReceived(defaultClientSubscription, uRI);
            }
        }

        public OperationDescription getOperation(String string) {
            EventSource eventSource = null;
            DefaultClientSubscription defaultClientSubscription = null;
            DataStructure dataStructure = DefaultEventSink.this.map_CSubId_2_CSub.values();
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                defaultClientSubscription = (DefaultClientSubscription)iterator.next();
                if (defaultClientSubscription == null) continue;
                ServiceReference serviceReference = defaultClientSubscription.getServiceReference();
                try {
                    Service service = serviceReference.getService();
                    eventSource = service.getEventSource(string);
                    if (eventSource == null) continue;
                    break;
                }
                catch (TimeoutException timeoutException) {
                    timeoutException.printStackTrace();
                }
            }
            return eventSource;
        }
    }
}

