/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.io.buffered;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.io.buffered.MarkReachedException;

public class BufferedInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final boolean MARK_SUPPORT = true;
    private static final boolean SENDZEROBYTE = false;
    private InputStream in = null;
    private int mark = -1;
    private int marked = -1;
    private int read = -1;
    private int last = -1;
    private byte[] buffer;
    private boolean markwatch = false;
    private boolean timeout = false;
    private boolean reducedtimeout = false;
    private int reducedtries = 2;
    private int sleep = 10;
    private int tries = 500;
    private boolean closed = false;
    private int maxsize = -1;
    private int rawread = 0;

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, 8192, -1);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        this(inputStream, 8192, n);
    }

    public BufferedInputStream(InputStream inputStream, int n, int n2) {
        if (inputStream instanceof BufferedInputStream) {
            throw new RuntimeException("Cannot buffer a BufferedInputStream");
        }
        if (inputStream == null) {
            throw new RuntimeException("Cannot buffer nonexistent stream.");
        }
        this.in = inputStream;
        this.buffer = new byte[n];
        this.maxsize = n2;
    }

    private void initLegal() {
        this.read = -1;
        this.last = -1;
    }

    private int getLastLegal() {
        return this.last;
    }

    private int getReadLegal() {
        return this.read;
    }

    private int getMarkLegal() {
        return this.mark;
    }

    private int getReadPosition() {
        return this.getReadLegal() % this.buffer.length;
    }

    private int getLastPosition() {
        return this.getLastLegal() % this.buffer.length;
    }

    private int getMarkPosition() {
        return this.getMarkLegal() % this.buffer.length;
    }

    private int getUpperFreespace() {
        return this.buffer.length - (this.getLastPosition() + 1);
    }

    private int getLowerFreespace() {
        return this.getMarkPosition();
    }

    private void incReadLegal(int n) {
        this.read += n;
        if (this.marked == -1) {
            this.mark = this.read;
        }
    }

    private int getDistance() {
        if (this.getReadLegal() == -1 && this.getLastLegal() >= 0) {
            return this.getLastLegal();
        }
        if (this.getReadLegal() >= 0 && this.getLastLegal() >= 0) {
            return this.getLastLegal() - this.getReadLegal();
        }
        return -1;
    }

    private boolean isClosed() {
        return this.closed;
    }

    public synchronized int read() throws IOException {
        int n;
        if (this.isClosed()) {
            return -1;
        }
        if (this.isMarked() && this.read >= this.mark + this.marked) {
            this.cleanMark();
        }
        if (this.getDistance() < 0 && (n = this.fill()) < 1) {
            return -1;
        }
        n = this.buffer[this.getReadPosition()];
        this.incReadLegal(1);
        int n2 = n & 0xFF;
        return n2;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.isClosed()) {
            return -1;
        }
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = -1;
        int n5 = this.getDistance() + 1;
        if (n5 >= n2) {
            System.arraycopy(this.buffer, this.getReadPosition(), byArray, n, n2);
            this.incReadLegal(n2);
            return n2;
        }
        if (n5 > 0) {
            System.arraycopy(this.buffer, this.getReadPosition(), byArray, n, n5);
            this.incReadLegal(n5);
        }
        n4 = n5;
        for (int i = n2 - n5; i > 0; i -= n3) {
            int n6 = this.fill();
            if (n6 < 1) {
                if (n4 == 0) {
                    return -1;
                }
                return n4;
            }
            n3 = Math.min(i, this.getDistance() + 1);
            System.arraycopy(this.buffer, this.getReadPosition(), byArray, n + n4, n3);
            this.incReadLegal(n3);
            n4 += n3;
        }
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized void reset() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.isMarked()) {
            this.read = this.mark;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int available() throws IOException {
        if (this.isClosed()) {
            return 0;
        }
        int n = this.mark == -1 ? this.read : this.mark;
        int n2 = this.last == -1 ? 0 : this.last - n;
        int n3 = this.in.available();
        if (this.maxsize > -1 && (n3 > this.maxsize || n2 > this.maxsize)) {
            if (n < 0) {
                return this.maxsize;
            }
            return this.maxsize - n;
        }
        return n2 < n3 ? n3 : n2;
    }

    public synchronized void mark(int n) {
        if (this.isClosed()) {
            return;
        }
        if (n > this.buffer.length) {
            throw new IndexOutOfBoundsException("Cannot mark beyond the buffer size of " + this.buffer.length);
        }
        this.mark = this.read;
        this.marked = n;
    }

    public void close() throws IOException {
        if (this.in == null) {
            throw new IOException("No stream found");
        }
        this.cleanMark();
        this.in.close();
        this.closed = true;
        this.buffer = null;
    }

    public boolean isMarked() {
        return this.marked > -1 && this.mark > -1;
    }

    public synchronized void setMarkWatchMode(boolean bl) {
        this.markwatch = bl;
    }

    public synchronized boolean isMarkWatched() {
        return this.markwatch;
    }

    public boolean isTimeoutMode() {
        return this.timeout;
    }

    public void setTimeoutMode(boolean bl) {
        this.timeout = bl;
    }

    protected InputStream getInputStream() {
        return this.in;
    }

    private void cleanMark() throws MarkReachedException {
        if (this.markwatch && this.isMarked()) {
            throw new MarkReachedException("mark=" + this.mark + "/" + this.marked + ", read=" + this.read);
        }
        this.mark = -1;
        this.marked = -1;
    }

    private int fill() throws IOException {
        int n = 0;
        if (this.getDistance() < 0 && !this.isMarked()) {
            this.buffer = new byte[this.buffer.length];
            this.initLegal();
            n = this.readInternal(this.buffer, 0, this.buffer.length);
            if (n >= 1) {
                this.last = n - 1;
                this.read = 0;
            }
        } else if (this.getDistance() < 0 && this.isMarked()) {
            int n2 = this.getLowerFreespace();
            int n3 = this.getUpperFreespace();
            if (n2 > 0) {
                n += this.readInternal(this.buffer, 0, n2);
            }
            if (n3 > 0) {
                n += this.readInternal(this.buffer, this.getLastPosition() + 1, n3);
            }
            if (n2 == 0 && n3 == 0) {
                n += this.readInternal(this.buffer, 0, this.buffer.length);
            }
            this.last += n;
        }
        return n;
    }

    private int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isClosed()) {
            return -1;
        }
        if (this.maxsize != -1 && this.rawread + n2 > this.maxsize) {
            n2 = this.maxsize - this.rawread;
        }
        if ((n3 = this.in.available()) > 0) {
            this.reducedtimeout = true;
        }
        int n4 = 0;
        int n5 = this.tries;
        if (this.isTimeoutMode()) {
            if (this.reducedtimeout) {
                n5 = this.tries;
                this.tries = this.reducedtries;
            }
            while (n3 == 0 && n4 < this.tries) {
                try {
                    Thread.sleep(this.sleep);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Stream read interrupted");
                }
                n3 = this.in.available();
                ++n4;
            }
            if (n3 > 0) {
                this.reducedtimeout = true;
                this.reducedtries = n4 > 0 ? n4 : 1;
                int n6 = this.reducedtries = this.reducedtries < 50 ? 50 : this.reducedtries;
            }
            if (this.reducedtimeout) {
                this.tries = n5;
            }
            if (n4 >= this.tries) {
                return -1;
            }
        }
        if (n3 == 0) {
            int n7 = this.in.read();
            if (n7 == -1) {
                return -1;
            }
            ++this.rawread;
            byArray[n] = (byte)(n7 & 0xFF);
            return 1;
        }
        int n8 = n3 < byArray.length - n ? n3 : byArray.length - n;
        int n9 = n8 = n8 > n2 ? n2 : n8;
        if (n8 == 0) {
            return 0;
        }
        int n10 = this.in.read(byArray, n, n8);
        this.rawread += n10;
        return n10;
    }

    public synchronized String toString() {
        return this.printBuffer(this.buffer);
    }

    private String printBuffer(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.read + "/" + this.last);
        stringBuffer.append('\r');
        stringBuffer.append('\n');
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.in == null ? 0 : this.in.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BufferedInputStream bufferedInputStream = (BufferedInputStream)object;
        return !(this.in == null ? bufferedInputStream.in != null : !this.in.equals(bufferedInputStream.in));
    }
}

