/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.io.xml;

import org.ws4d.java.io.xml.ElementHandler;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.QName;

public final class ElementHandlerRegistry {
    private static final ElementHandlerRegistry INSTANCE = new ElementHandlerRegistry();
    private final HashMap elementHandlers = new HashMap();

    public static ElementHandlerRegistry getRegistry() {
        return INSTANCE;
    }

    public synchronized void registerElementHandler(QName qName, ElementHandler elementHandler) {
        if (qName == null || elementHandler == null) {
            return;
        }
        if (this.elementHandlers.containsKey(qName)) {
            throw new IllegalArgumentException("a handler is already registered for this element name: " + qName);
        }
        this.elementHandlers.put(qName, elementHandler);
    }

    public synchronized ElementHandler getElementHandler(QName qName) {
        return (ElementHandler)this.elementHandlers.get(qName);
    }

    private ElementHandlerRegistry() {
    }

    public synchronized HashMap getAllElementHandler() {
        return this.elementHandlers;
    }
}

