/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.message;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.ReferenceParametersMData;
import org.ws4d.java.types.UnknownDataContainer;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.StringUtil;

public class SOAPHeader
extends UnknownDataContainer {
    private ProtocolInfo protocolInfo = null;
    private AttributedURI action;
    private AttributedURI messageId;
    private AttributedURI relatesTo;
    private EndpointReference replyTo;
    private AttributedURI to;
    private AppSequence appSequence;
    private ReferenceParametersMData referenceParameters;
    private byte[] sigVal;
    private boolean signatureValidated = true;
    private String comManID = CommunicationManager.ID_NULL;

    public static SOAPHeader createHeader(String string, String string2) {
        SOAPHeader sOAPHeader = new SOAPHeader(string2);
        sOAPHeader.setAction(new AttributedURI(string));
        return sOAPHeader;
    }

    public static SOAPHeader createRequestHeader(String string, String string2) {
        SOAPHeader sOAPHeader = SOAPHeader.createHeader(string, string2);
        sOAPHeader.setMessageId(new AttributedURI(IDGenerator.getUUIDasURI()));
        return sOAPHeader;
    }

    public SOAPHeader(String string) {
        this.comManID = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        stringBuffer.append(" [ action=").append(this.action);
        stringBuffer.append(", messageId=").append(this.messageId);
        stringBuffer.append(", relatesTo=").append(this.relatesTo);
        stringBuffer.append(", replyTo=").append(this.replyTo);
        stringBuffer.append(", to=").append(this.to);
        stringBuffer.append(", appSequence=").append(this.appSequence);
        stringBuffer.append(", referenceParameters=").append(this.referenceParameters);
        if (this.sigVal != null && DPWSFramework.hasModule(64)) {
            stringBuffer.append(", Sig=").append(DPWSFramework.getSecurityManager().encode(this.sigVal));
            stringBuffer.append(", Signature Valid=").append(this.signatureValidated);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void setResponseTo(SOAPHeader sOAPHeader) {
        this.relatesTo = sOAPHeader.messageId;
        EndpointReference endpointReference = sOAPHeader.replyTo;
        if (endpointReference != null) {
            this.setEndpointReference(endpointReference);
        }
    }

    public void setSignature(byte[] byArray) {
        this.sigVal = byArray;
    }

    public byte[] getSignature() {
        return this.sigVal;
    }

    public void setValidated(boolean bl) {
        this.signatureValidated = bl;
    }

    public boolean isValidated() {
        return this.signatureValidated;
    }

    public AttributedURI getAction() {
        return this.action;
    }

    public AppSequence getAppSequence() {
        return this.appSequence;
    }

    public AttributedURI getMessageId() {
        return this.messageId;
    }

    public ProtocolInfo getProtocolInfo() {
        return this.protocolInfo;
    }

    public AttributedURI getRelatesTo() {
        return this.relatesTo;
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public AttributedURI getTo() {
        return this.to;
    }

    public String getWseIdentifier() {
        return this.referenceParameters == null ? null : this.referenceParameters.getWseIdentifier();
    }

    public int getDPWSMessageType() {
        if (this.action == null) {
            return -1;
        }
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(this.getCommunicationManagerID());
        CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
        ConstantsHelper constantsHelper = communicationUtil.getHelper(this.protocolInfo.getVersion());
        String string = this.action.toString();
        if (constantsHelper.getWSDActionHello().equals(string)) {
            return 1;
        }
        if (constantsHelper.getWSDActionBye().equals(string)) {
            return 2;
        }
        if (constantsHelper.getWSDActionProbe().equals(string)) {
            return 3;
        }
        if (constantsHelper.getWSDActionProbeMatches().equals(string)) {
            return 4;
        }
        if (constantsHelper.getWSDActionResolve().equals(string)) {
            return 5;
        }
        if (constantsHelper.getWSDActionResolveMatches().equals(string)) {
            return 6;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus".equals(string)) {
            return 307;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse".equals(string)) {
            return 308;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew".equals(string)) {
            return 303;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse".equals(string)) {
            return 304;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe".equals(string)) {
            return 301;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse".equals(string)) {
            return 302;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd".equals(string)) {
            return 309;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe".equals(string)) {
            return 305;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse".equals(string)) {
            return 306;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get".equals(string)) {
            return 101;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse".equals(string)) {
            return 102;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request".equals(string)) {
            return 201;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Response".equals(string)) {
            return 202;
        }
        if ("http://www.w3.org/2005/08/addressing/fault".equals(string) || constantsHelper.getDPWSActionFault().equals(string) || "http://www.w3.org/2005/08/addressing/soap/fault".equals(string) || "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/fault".equals(string)) {
            return 500;
        }
        return 400;
    }

    public ReferenceParametersMData getReferenceParameters() {
        return this.referenceParameters;
    }

    public void setEndpointReference(EndpointReference endpointReference) {
        this.to = endpointReference.getAddress();
        this.referenceParameters = endpointReference.getReferenceParameters();
    }

    public void setAction(AttributedURI attributedURI) {
        this.action = attributedURI;
    }

    public void setMessageId(AttributedURI attributedURI) {
        this.messageId = attributedURI;
    }

    public void setRelatesTo(AttributedURI attributedURI) {
        this.relatesTo = attributedURI;
    }

    public void setReplyTo(EndpointReference endpointReference) {
        this.replyTo = endpointReference;
    }

    public void setTo(AttributedURI attributedURI) {
        this.to = attributedURI;
        if (!FrameworkProperties.REFERENCE_PARAM_MODE && attributedURI.getFragment() != null) {
            this.setWseIdentifier(attributedURI.getFragment());
        }
    }

    public void setAppSequence(AppSequence appSequence) {
        this.appSequence = appSequence;
    }

    public void setWseIdentifier(String string) {
        if (this.referenceParameters == null) {
            this.referenceParameters = new ReferenceParametersMData();
        }
        this.referenceParameters.setWseIdentifier(string);
    }

    public void setProtocolInfo(ProtocolInfo protocolInfo) {
        this.protocolInfo = protocolInfo;
    }

    public void setReferenceParameters(ReferenceParametersMData referenceParametersMData) {
        this.referenceParameters = referenceParametersMData;
    }

    public String getCommunicationManagerID() {
        return this.comManID;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.messageId == null ? 0 : this.messageId.hashCode());
        n = 31 * n + (this.protocolInfo == null ? 0 : this.protocolInfo.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SOAPHeader sOAPHeader = (SOAPHeader)object;
        if (this.messageId == null ? sOAPHeader.messageId != null : !this.messageId.equals(sOAPHeader.messageId)) {
            return false;
        }
        return !(this.protocolInfo == null ? sOAPHeader.protocolInfo != null : !this.protocolInfo.equals(sOAPHeader.protocolInfo));
    }
}

