/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.AnyAttribute;
import org.ws4d.java.schema.Attribute;
import org.ws4d.java.schema.Reference;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedMap;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class AttributeGroup
extends Reference {
    static final String TAG_ATTRIBUTEGROUP = "attributeGroup";
    protected static int count = 0;
    protected HashMap attributes = EmptyStructures.EMPTY_MAP;
    protected HashMap attributeGroups = EmptyStructures.EMPTY_MAP;
    protected AnyAttribute anyAttribute = null;

    public static int getTotalAttributeGroupCount() {
        return count;
    }

    static final AttributeGroup createAttributeGroup(ElementParser elementParser, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        String string2;
        String string3;
        String string4 = elementParser.getAttributeValue(null, "name");
        String string5 = elementParser.getAttributeValue(null, "ref");
        AttributeGroup attributeGroup = null;
        attributeGroup = string4 != null ? new AttributeGroup(new QName(string4, string)) : new AttributeGroup();
        if (string5 != null) {
            String string6 = SchemaUtil.getPrefix(string5);
            string3 = SchemaUtil.getName(string5);
            string2 = elementParser.getNamespace(string6);
            attributeGroup.setReferenceLink(new QName(string3, string2));
            schema.addAttributeGroupForResolve(attributeGroup);
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            Reference reference;
            string3 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3)) continue;
            if (StringUtil.equalsIgnoreCase("attribute", string2)) {
                reference = Attribute.createAttribute(elementParser, string, schema);
                attributeGroup.addAttribute((Attribute)reference);
                continue;
            }
            if (StringUtil.equalsIgnoreCase(TAG_ATTRIBUTEGROUP, string2)) {
                reference = AttributeGroup.createAttributeGroup(elementParser, string, schema);
                attributeGroup.addAttributeGroup((AttributeGroup)reference);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("anyAttribute", string2)) {
                reference = AnyAttribute.createAnyAttribute(elementParser);
                attributeGroup.setAnyAttribute((AnyAttribute)reference);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("annotation", string2)) continue;
            Annotation.handleAnnotation(elementParser, attributeGroup);
        }
        return attributeGroup;
    }

    AttributeGroup() {
        this(null);
    }

    AttributeGroup(QName qName) {
        this.name = qName;
        if (qName != null && !"http://www.w3.org/2001/XMLSchema".equals(qName.getNamespace()) || qName == null) {
            ++count;
        }
    }

    public int getSchemaIdentifier() {
        return 6;
    }

    public boolean hasAnyAttribute() {
        return this.reference == null ? this.anyAttribute != null : ((AttributeGroup)this.reference).hasAnyAttribute();
    }

    public void allowAnyAttribute() {
        if (this.anyAttribute == null) {
            this.anyAttribute = new AnyAttribute();
        }
    }

    public void denyAnyAttribute() {
        this.anyAttribute = null;
    }

    public void addAttribute(Attribute attribute) {
        QName qName = attribute.getName();
        if (qName == null) {
            qName = attribute.getReferenceLink();
        }
        if (this.attributes == EmptyStructures.EMPTY_MAP) {
            this.attributes = new LinkedMap();
        }
        this.attributes.put(qName, attribute);
    }

    public Attribute getAttribute(QName qName) {
        return (Attribute)this.attributes.get(qName);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public Iterator attributes() {
        return this.attributes.values().iterator();
    }

    public void addAttributeGroup(AttributeGroup attributeGroup) {
        QName qName = attributeGroup.getName();
        if (qName == null) {
            qName = attributeGroup.getReferenceLink();
        }
        if (this.attributeGroups == EmptyStructures.EMPTY_MAP) {
            this.attributeGroups = new LinkedMap();
        }
        this.attributeGroups.put(qName, attributeGroup);
    }

    public AttributeGroup getAttributeGroup(QName qName) {
        return (AttributeGroup)this.attributeGroups.get(qName);
    }

    public int getAttributeGroupCount() {
        return this.attributeGroups.size();
    }

    public Iterator attributeGroups() {
        return this.attributeGroups.values().iterator();
    }

    public Iterator allAttributes() {
        ArrayList arrayList;
        block8: {
            block7: {
                arrayList = null;
                if (this.reference != null) break block7;
                if (this.attributes != null && this.attributes.size() > 0) {
                    arrayList = new ArrayList();
                    arrayList.addAll(this.attributes.values());
                }
                if (this.attributeGroups == null || this.attributeGroups.size() <= 0) break block8;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                Iterator iterator = this.attributeGroups.values().iterator();
                while (iterator.hasNext()) {
                    AttributeGroup attributeGroup = (AttributeGroup)iterator.next();
                    Iterator iterator2 = attributeGroup.allAttributes();
                    while (iterator2.hasNext()) {
                        ((List)arrayList).add(iterator2.next());
                    }
                }
                break block8;
            }
            arrayList = new ArrayList();
            AttributeGroup attributeGroup = (AttributeGroup)this.reference;
            arrayList.addAll(attributeGroup.attributes.values());
            if (attributeGroup.attributeGroups != null && attributeGroup.attributeGroups.size() > 0) {
                Iterator iterator = attributeGroup.attributeGroups.values().iterator();
                while (iterator.hasNext()) {
                    AttributeGroup attributeGroup2 = (AttributeGroup)iterator.next();
                    Iterator iterator3 = attributeGroup2.allAttributes();
                    while (iterator3.hasNext()) {
                        ((List)arrayList).add(iterator3.next());
                    }
                }
            }
        }
        return arrayList == null ? EmptyStructures.EMPTY_ITERATOR : arrayList.iterator();
    }

    void setAnyAttribute(AnyAttribute anyAttribute) {
        this.anyAttribute = anyAttribute;
    }

    void serialize(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_ATTRIBUTEGROUP);
        if (this.reference != null) {
            QName qName = this.reference.getName();
            String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
            if (string != null && !"".equals(string)) {
                qName.setPrefix(string);
                xmlSerializer.attribute(null, "ref", qName.getLocalPartPrefixed());
            } else {
                xmlSerializer.attribute(null, "ref", qName.getLocalPart());
            }
        } else {
            Reference reference;
            Iterator iterator;
            if (this.name != null) {
                xmlSerializer.attribute(null, "name", this.name.getLocalPart());
            }
            if (this.attributes.size() > 0) {
                iterator = this.attributes();
                while (iterator.hasNext()) {
                    reference = (Attribute)iterator.next();
                    ((Attribute)reference).serialize(xmlSerializer, schema);
                }
            }
            if (this.attributeGroups.size() > 0) {
                iterator = this.attributeGroups();
                while (iterator.hasNext()) {
                    reference = (AttributeGroup)iterator.next();
                    xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_ATTRIBUTEGROUP);
                    QName qName = reference.getName();
                    String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
                    if (string != null && !"".equals(string)) {
                        qName.setPrefix(string);
                        xmlSerializer.attribute(null, "ref", qName.getLocalPartPrefixed());
                    } else {
                        xmlSerializer.attribute(null, "ref", qName.getLocalPart());
                    }
                    xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_ATTRIBUTEGROUP);
                }
            }
            if (this.anyAttribute != null) {
                this.anyAttribute.serialize(xmlSerializer, schema);
            }
        }
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_ATTRIBUTEGROUP);
    }
}

