/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.AllContainer;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.ChoiceContainer;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.ElementContainer;
import org.ws4d.java.schema.Reference;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.SequenceContainer;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class Group
extends Reference {
    static final String TAG_GROUP = "group";
    protected static int count = 0;
    protected ElementContainer container = null;

    public static int getGroupCount() {
        return count;
    }

    static final Group createGroup(ElementParser elementParser, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        String string2;
        String string3;
        String string4 = elementParser.getAttributeValue(null, "name");
        String string5 = elementParser.getAttributeValue(null, "ref");
        if (string4 == null && string5 == null) {
            throw new SchemaException("Wrong group definiton. No name or reference set.");
        }
        Group group = null;
        group = string4 != null ? new Group(new QName(string4, string)) : new Group();
        if (string5 != null) {
            String string6 = SchemaUtil.getPrefix(string5);
            string3 = SchemaUtil.getName(string5);
            string2 = elementParser.getNamespace(string6);
            group.setReferenceLink(new QName(string3, string2));
            schema.addGroupForResolve(group);
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            ElementContainer elementContainer;
            string3 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3)) continue;
            if (StringUtil.equalsIgnoreCase("all", string2)) {
                elementContainer = new AllContainer();
                ElementContainer.handleContainerElements(elementParser, elementContainer, string, schema);
                group.container = elementContainer;
                continue;
            }
            if (StringUtil.equalsIgnoreCase("sequence", string2)) {
                elementContainer = new SequenceContainer();
                ElementContainer.handleContainerElements(elementParser, elementContainer, string, schema);
                group.container = elementContainer;
                continue;
            }
            if (StringUtil.equalsIgnoreCase("choice", string2)) {
                elementContainer = new ChoiceContainer();
                ElementContainer.handleContainerElements(elementParser, elementContainer, string, schema);
                group.container = elementContainer;
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("annotation", string2)) continue;
            Annotation.handleAnnotation(elementParser, group);
        }
        return group;
    }

    Group() {
        this(null);
    }

    Group(QName qName) {
        this.name = qName;
        if (qName != null && !"http://www.w3.org/2001/XMLSchema".equals(qName.getNamespace()) || qName == null) {
            ++count;
        }
    }

    public int getSchemaIdentifier() {
        return 2;
    }

    public Element getElementByName(QName qName) {
        return this.reference != null ? ((Group)this.reference).getElementByName(qName) : (this.container == null ? null : this.container.getElementByName(qName));
    }

    public Element getElementByName(String string) {
        return this.reference != null ? ((Group)this.reference).getElementByName(string) : (this.container == null ? null : this.container.getElementByName(string));
    }

    public int getElementCount() {
        return this.reference != null ? ((Group)this.reference).getElementCount() : (this.container == null ? 0 : this.container.getElementCount());
    }

    public boolean hasElements() {
        return this.reference != null ? ((Group)this.reference).hasElements() : (this.container == null ? false : this.container.hasElements());
    }

    public Iterator elements() {
        return this.reference != null ? ((Group)this.reference).elements() : (this.container == null ? EmptyStructures.EMPTY_ITERATOR : this.container.allElements());
    }

    public int getContainerType() {
        return this.reference != null ? ((Group)this.reference).getContainerType() : (this.container != null ? this.container.getContainerType() : 0);
    }

    public int getContainerMinOccurs() {
        return this.reference != null ? ((Group)this.reference).getContainerMinOccurs() : (this.container != null ? this.container.getMinOccurs() : 0);
    }

    public int getContainerMaxOccurs() {
        return this.reference != null ? ((Group)this.reference).getContainerMaxOccurs() : (this.container != null ? this.container.getMaxOccurs() : 0);
    }

    public ElementContainer getContainer() {
        return this.reference != null ? ((Group)this.reference).getContainer() : (this.container != null ? this.container : null);
    }

    public Iterator listAll() {
        if (this.reference != null) {
            return ((Group)this.reference).listAll();
        }
        if (this.container == null) {
            return EmptyStructures.EMPTY_ITERATOR;
        }
        return this.container.listAll();
    }

    void serialize(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_GROUP);
        if (this.name != null) {
            xmlSerializer.attribute(null, "name", this.name.getLocalPart());
        }
        if (this.reference != null) {
            QName qName = this.reference.getName();
            String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
            if (string != null && !"".equals(string)) {
                xmlSerializer.attribute(null, "ref", string + ":" + qName.getLocalPart());
            } else {
                xmlSerializer.attribute(null, "ref", qName.getLocalPart());
            }
        }
        if (this.container != null) {
            this.container.serialize(xmlSerializer, schema);
        }
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_GROUP);
    }
}

