/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.eventing.ClientSubscriptionInternal;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public final class DefaultClientSubscription
extends TimedEntry
implements ClientSubscriptionInternal {
    final EventSink sink;
    final String clientSubscriptionId;
    private long timeoutTime;
    final EprInfo subscriptionManagerAddressInfo;
    private ServiceReference servRef;
    private String comManId;

    public DefaultClientSubscription(EventSink eventSink, String string, EndpointReference endpointReference, String string2, long l, ServiceReference serviceReference) {
        this.sink = eventSink;
        this.clientSubscriptionId = string;
        this.subscriptionManagerAddressInfo = new EprInfo(endpointReference, string2);
        this.comManId = string2;
        if (l != 0L) {
            this.timeoutTime = System.currentTimeMillis() + l;
            WatchDog.getInstance().register(this, l);
        } else {
            this.timeoutTime = 0L;
        }
        this.servRef = serviceReference;
        DPWSFramework.addClientSubscrption(this);
    }

    public synchronized long getTimeoutTime() {
        return this.timeoutTime;
    }

    public EprInfo getSubscriptionManagerAddressInfo() {
        return this.subscriptionManagerAddressInfo;
    }

    public String getServiceSubscriptionId() {
        return this.subscriptionManagerAddressInfo.getEndpointReference().getReferenceParameters().getWseIdentifier();
    }

    public String getCommunicationManagerId() {
        return this.comManId;
    }

    public EventSink getEventSink() {
        return this.sink;
    }

    public ServiceReference getServiceReference() {
        return this.servRef;
    }

    public long renew(long l) throws EventingException, TimeoutException {
        return this.servRef.getService().renew(this, l);
    }

    public void unsubscribe() throws EventingException, TimeoutException {
        this.servRef.getService().unsubscribe(this);
    }

    public long getStatus() throws EventingException, TimeoutException {
        long l = this.servRef.getService().getStatus(this);
        this.updateTimeoutTime(l);
        return l;
    }

    public void renewInternal(long l) {
        if (l != 0L) {
            WatchDog.getInstance().update(this, l);
        } else {
            WatchDog.getInstance().unregister(this);
        }
        this.updateTimeoutTime(l);
    }

    public void dispose() {
        WatchDog.getInstance().unregister(this);
        DPWSFramework.removeClientSubscrption(this);
    }

    protected void timedOut() {
        DPWSFramework.removeClientSubscrption(this);
        this.sink.getEventListener().subscriptionTimeoutReceived(this);
    }

    private synchronized void updateTimeoutTime(long l) {
        this.timeoutTime = l == 0L ? 0L : System.currentTimeMillis() + l;
    }
}

