/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.DefaultResponseCallback;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.eventing.ClientSubscription;
import org.ws4d.java.eventing.EventListener;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventSource;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.service.OperationCommons;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.ServiceSubscription;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LockedMap;
import org.ws4d.java.structures.LockedSet;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.WSDLOperation;

public class DefaultEventSource
extends OperationCommons
implements EventSource {
    private LockedSet subscriptions = new LockedSet(new HashSet(5));
    private HashMap map_MsgId_2_Context = new LockedMap(new HashMap(5));

    public DefaultEventSource(String string, QName qName) {
        super(string, qName);
    }

    public DefaultEventSource(WSDLOperation wSDLOperation) {
        super(wSDLOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(final ParameterValue parameterValue, final int n) {
        ArrayList arrayList = new ArrayList();
        this.subscriptions.sharedLock();
        try {
            long l = System.currentTimeMillis();
            Iterator iterator = this.subscriptions.iterator();
            while (iterator.hasNext()) {
                final ServiceSubscription serviceSubscription = (ServiceSubscription)iterator.next();
                if (serviceSubscription.expirationTime < l) {
                    arrayList.add(serviceSubscription);
                    continue;
                }
                final DefaultEventSource defaultEventSource = this;
                if (serviceSubscription.sink != null) {
                    DPWSFramework.getThreadPool().execute(new Runnable(){

                        public void run() {
                            if (DefaultEventSource.this.getType() == 3) {
                                ParameterValue parameterValue2 = serviceSubscription.sink.receiveLocalEvent(serviceSubscription.clientSubscriptionId, new URI(DefaultEventSource.this.getOutputAction()), parameterValue);
                                if (parameterValue2 != null) {
                                    DefaultEventSource.this.solicitResponseReceived(parameterValue2, n, serviceSubscription);
                                } else {
                                    Log.error("Local call of solicit response doesn't return response");
                                }
                            } else {
                                serviceSubscription.sink.receiveLocalEvent(serviceSubscription.clientSubscriptionId, new URI(DefaultEventSource.this.getOutputAction()), parameterValue);
                            }
                        }
                    });
                    continue;
                }
                DPWSFramework.getThreadPool().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        InvokeMessage invokeMessage = new InvokeMessage(DefaultEventSource.this.getOutputAction(), serviceSubscription.getCommunicationManagerID());
                        invokeMessage.setContent(parameterValue);
                        SOAPHeader sOAPHeader = invokeMessage.getHeader();
                        invokeMessage.setProtocolInfo(serviceSubscription.getProtocolInfo());
                        sOAPHeader.setEndpointReference(serviceSubscription.notifyTo.getEndpointReference());
                        invokeMessage.setTargetXAddressInfo(serviceSubscription.notifyTo);
                        if (DefaultEventSource.this.getType() == 3) {
                            AttributedURI attributedURI = invokeMessage.getMessageId();
                            SolicitResponseContext solicitResponseContext = new SolicitResponseContext(attributedURI);
                            DefaultEventSource.this.map_MsgId_2_Context.put(attributedURI, solicitResponseContext);
                            OutDispatcher.getInstance().send(invokeMessage, (XAddressInfo)serviceSubscription.notifyTo, (ResponseCallback)new DefaultEventSourceCallback(serviceSubscription.notifyTo, serviceSubscription, defaultEventSource));
                            AttributedURI attributedURI2 = attributedURI;
                            synchronized (attributedURI2) {
                                while (solicitResponseContext.waitingForNotfication) {
                                    try {
                                        attributedURI.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                }
                            }
                            if (solicitResponseContext.rspParamValue != null) {
                                DefaultEventSource.this.solicitResponseReceived(solicitResponseContext.rspParamValue, n, serviceSubscription);
                            } else if (!solicitResponseContext.responseReceived) {
                                Log.error("Event.fire(): No response received!");
                                DefaultEventSource.this.subscriptions.remove(serviceSubscription);
                            }
                        } else {
                            OutDispatcher.getInstance().send(invokeMessage, (XAddressInfo)serviceSubscription.notifyTo, (ResponseCallback)new DefaultEventSourceCallback(serviceSubscription.notifyTo, serviceSubscription, defaultEventSource));
                        }
                    }
                });
            }
        }
        finally {
            this.subscriptions.releaseSharedLock();
        }
        if (arrayList.size() > 0) {
            this.subscriptions.exclusiveLock();
            try {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.subscriptions.remove(iterator.next());
                }
            }
            finally {
                this.subscriptions.releaseExclusiveLock();
            }
        }
    }

    public final int getType() {
        if (this.type == -1) {
            this.type = this.getInput() == null && this.getFaultCount() == 0 ? 4 : 3;
        }
        return this.type;
    }

    public final boolean isNotification() {
        return this.getType() == 4;
    }

    public final boolean isSolicitResponse() {
        return this.getType() == 3;
    }

    public ClientSubscription subscribe(EventListener eventListener, long l) throws EventingException, TimeoutException {
        return this.subscribe(eventListener, l, null);
    }

    public ClientSubscription subscribe(EventListener eventListener, long l, DataStructure dataStructure) throws EventingException, TimeoutException {
        Service service = this.getService();
        EventSink eventSink = eventListener.getEventSink(dataStructure);
        if (service.isRemote()) {
            eventSink.open();
        }
        String string = "urn:uuid:" + IDGenerator.getUUID();
        return service.subscribe(eventSink, string, new URISet(new URI(this.getOutputAction())), l);
    }

    public void solicitResponseReceived(ParameterValue parameterValue, int n, ServiceSubscription serviceSubscription) {
        Log.info("DefaultEventSource.receivedSolicitResponse: Overwrite this method to receive solicit responses.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSubscription(ServiceSubscription serviceSubscription) {
        this.subscriptions.exclusiveLock();
        try {
            this.subscriptions.add(serviceSubscription);
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(ServiceSubscription serviceSubscription) {
        this.subscriptions.exclusiveLock();
        try {
            this.subscriptions.remove(serviceSubscription);
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSubscriptionCount() {
        this.subscriptions.sharedLock();
        try {
            int n = this.subscriptions.size();
            return n;
        }
        finally {
            this.subscriptions.releaseSharedLock();
        }
    }

    private class DefaultEventSourceCallback
    extends DefaultResponseCallback {
        private final ServiceSubscription subscription;
        private final OperationDescription op;

        public DefaultEventSourceCallback(XAddressInfo xAddressInfo, ServiceSubscription serviceSubscription, OperationDescription operationDescription) {
            super(xAddressInfo);
            this.subscription = serviceSubscription;
            this.op = operationDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Message message, InvokeMessage invokeMessage, ProtocolData protocolData) {
            AttributedURI attributedURI = invokeMessage.getRelatesTo();
            SolicitResponseContext solicitResponseContext = (SolicitResponseContext)DefaultEventSource.this.map_MsgId_2_Context.remove(attributedURI);
            if (solicitResponseContext != null) {
                URI uRI = solicitResponseContext.messageId;
                synchronized (uRI) {
                    solicitResponseContext.responseReceived = true;
                    solicitResponseContext.rspParamValue = invokeMessage.getContent();
                    solicitResponseContext.waitingForNotfication = false;
                    solicitResponseContext.messageId.notify();
                }
            }
        }

        public void handle(Message message, FaultMessage faultMessage, ProtocolData protocolData) {
            this.handleTimeout(message);
        }

        public void handleMalformedResponseException(Message message, Exception exception, ProtocolData protocolData) {
            this.handleTimeout(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTransmissionException(Message message, Exception exception, ProtocolData protocolData) {
            DefaultEventSource.this.subscriptions.exclusiveLock();
            try {
                DefaultEventSource.this.subscriptions.remove(this.subscription);
                Log.error("DefaultEventSource.fire(): Can't send notification!");
                Log.printStackTrace(exception);
            }
            finally {
                DefaultEventSource.this.subscriptions.releaseExclusiveLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTimeout(Message message) {
            AttributedURI attributedURI = message.getMessageId();
            SolicitResponseContext solicitResponseContext = (SolicitResponseContext)DefaultEventSource.this.map_MsgId_2_Context.remove(attributedURI);
            if (solicitResponseContext != null) {
                URI uRI = solicitResponseContext.messageId;
                synchronized (uRI) {
                    solicitResponseContext.responseReceived = false;
                    solicitResponseContext.waitingForNotfication = false;
                    solicitResponseContext.messageId.notify();
                }
            }
        }

        public OperationDescription getOperation() {
            return this.op;
        }
    }

    private class SolicitResponseContext {
        final URI messageId;
        ParameterValue rspParamValue = null;
        boolean responseReceived;
        volatile boolean waitingForNotfication = true;

        SolicitResponseContext(URI uRI) {
            this.messageId = uRI;
        }
    }
}

