/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.DefaultIncomingMessageListener;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.Resource;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.communication.protocol.http.HTTPGroup;
import org.ws4d.java.communication.protocol.http.HTTPUser;
import org.ws4d.java.configuration.ServiceProperties;
import org.ws4d.java.configuration.ServicesPropertiesHandler;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.ServiceReferenceInternal;
import org.ws4d.java.eventing.ClientSubscription;
import org.ws4d.java.eventing.ClientSubscriptionInternal;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventSource;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.eventing.EventingFactory;
import org.ws4d.java.eventing.SubscriptionManager;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.schema.Reference;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.service.Fault;
import org.ws4d.java.service.InvocationException;
import org.ws4d.java.service.LocalDevice;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.service.Operation;
import org.ws4d.java.service.OperationCommons;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.OperationStub;
import org.ws4d.java.service.ServiceCommons;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.AttributableSupport;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.EprInfoSet;
import org.ws4d.java.types.HostMData;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.RelationshipMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.util.WS4DIllegalStateException;
import org.ws4d.java.wsdl.IOType;
import org.ws4d.java.wsdl.UnsupportedBindingException;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLBinding;
import org.ws4d.java.wsdl.WSDLMessage;
import org.ws4d.java.wsdl.WSDLMessagePart;
import org.ws4d.java.wsdl.WSDLOperation;
import org.ws4d.java.wsdl.WSDLPortType;
import org.ws4d.java.wsdl.WSDLRepository;
import org.ws4d.java.wsdl.WSDLService;
import org.ws4d.java.wsdl.soap12.SOAP12DocumentLiteralHTTPBinding;
import org.ws4d.java.wsdl.soap12.SOAP12DocumentLiteralHTTPPort;

public class DefaultService
extends ServiceCommons
implements LocalService {
    protected static final int[] SERVICE_MESSAGE_TYPES = new int[]{201, 400};
    protected static final int[] EVENTED_SERVICE_MESSAGE_TYPES = new int[]{201, 301, 307, 303, 305, 400};
    protected static final byte SERVICE_STATE_UNREGISTERED = 1;
    protected static final byte SERVICE_STATE_REGISTERED = 2;
    protected static final byte SERVICE_STATE_RUNNING = 3;
    protected static final String IN_MSG_POSTFIX = "Message";
    protected static final String OUT_MSG_POSTFIX = "Message";
    protected static final String FAULT_MSG_POSTFIX = "Message";
    protected static final String BINDING_POSTFIX = "Binding";
    protected int configurationId;
    protected ServiceMessageListener incomingListener = new ServiceMessageListener();
    protected final HostedMData hosted = new HostedMData();
    protected ServiceReference serviceReference = null;
    protected LocalDevice parentDevice = null;
    protected final ServiceProperties serviceProp;
    protected final HashMap wsdlURIs = new HashMap();
    protected final HashMap resourceURIs = new HashMap();
    protected byte state = 1;
    protected SubscriptionManager subscriptionManager = null;
    protected final DataStructure bindings;
    protected String sid = null;
    private HTTPGroup userGroup = null;

    private static ResourcePath createResourcePath(String string, String string2) {
        URI uRI = new URI(string);
        String string3 = uRI.getHost();
        String string4 = uRI.getPath();
        if (uRI.isURN()) {
            string4 = string4.replace(':', '_');
        }
        String string5 = (string3 == null ? "" : string3) + string4 + (string4.charAt(string4.length() - 1) == '/' ? "" : "/") + string2;
        int n = 0;
        int n2 = string5.indexOf(47);
        while (n2 != -1) {
            if (n2 != 0) {
                ++n;
            }
            n2 = string5.indexOf(47, n2 + 1);
        }
        return new ResourcePath(string5, n);
    }

    public DefaultService() {
        this(-1);
    }

    public DefaultService(int n) {
        this.hosted.setTypes(QNameSet.newInstanceReadOnly(this.portTypes.keySet()));
        this.configurationId = n;
        if (this.configurationId != -1) {
            Integer n2 = new Integer(n);
            this.serviceProp = ServicesPropertiesHandler.getInstance().getServiceProperties(n2);
            if (this.serviceProp == null) {
                Log.error("DefaultService(configurationId): No service properties for configuration id " + n);
                this.bindings = new ArrayList(2);
            } else {
                URI uRI = this.serviceProp.getServiceId();
                if (uRI != null) {
                    this.setServiceId(uRI);
                }
                this.bindings = this.serviceProp.getBindings();
            }
        } else {
            this.serviceProp = null;
            this.bindings = new ArrayList(2);
        }
        if (this.serviceProp != null && this.serviceProp.isServiceSecured() && DPWSFramework.hasModule(64)) {
            try {
                this.setSecureService();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.sid = StringUtil.simpleClassName(this.getClass());
    }

    public synchronized void start() throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (!DPWSFramework.isRunning()) {
            throw new RuntimeException("DPWSFramework not running, please start it in advance!");
        }
        if (Log.isDebug()) {
            Log.info("### Start Service: " + this.sid);
        }
        if (this.isRunning()) {
            Log.warn("Service already running, nothing to start");
            return;
        }
        if (this.state == 1) {
            Object object4;
            Object object5;
            if (this.hosted.getServiceId() == null) {
                this.hosted.setServiceId(new URI(this.sid));
            }
            object3 = SERVICE_MESSAGE_TYPES;
            object2 = this.portTypes.values().iterator();
            while (object2.hasNext()) {
                object = (ServiceCommons.PortType)object2.next();
                ((ServiceCommons.PortType)object).plomb();
                if (!((ServiceCommons.PortType)object).hasEventSources()) continue;
                object3 = EVENTED_SERVICE_MESSAGE_TYPES;
            }
            if (!this.hasBindings()) {
                object2 = StringUtil.simpleClassName(this.getClass());
                if (Log.isDebug()) {
                    Log.info("No bindings found for Service. Autobinding service " + (String)object2);
                }
                object = new HashSet();
                object5 = CommunicationManagerRegistry.getLoadedManagers();
                while (object5.hasNext()) {
                    object4 = (CommunicationManager)object5.next();
                    object4.getAutobindings((String)object2, (DataStructure)object);
                }
                object5 = ((DataStructure)object).iterator();
                while (object5.hasNext()) {
                    object4 = (CommunicationBinding)object5.next();
                    this.addBinding((CommunicationBinding)object4);
                }
            }
            object2 = this.getBindings();
            while (object2.hasNext()) {
                object = (CommunicationBinding)object2.next();
                object5 = CommunicationManagerRegistry.getManager(object.getCommunicationManagerId());
                object5.registerService((int[])object3, (CommunicationBinding)object, this.incomingListener, this.userGroup);
                object4 = new EndpointReference(object.getTransportAddress());
                this.hosted.addEprInfo(new EprInfo((EndpointReference)object4, object.getCommunicationManagerId()));
            }
            if (this.secure) {
                object2 = ((EndpointReference)this.getEprInfos().next()).getAddress();
                object = ((URI)object2).getHost() + ":" + ((URI)object2).getPort() + ((URI)object2).getPath();
                this.certificate = DPWSFramework.getSecurityManager().getCertificate((String)object);
                if (this.certificate == null) {
                    throw new IOException("Security credentials not found");
                }
                this.privateKey = DPWSFramework.getSecurityManager().getPrivateKey((String)object, null);
                this.secure = true;
            }
            DeviceServiceRegistry.register(this);
            this.deployMetadataResources();
            this.state = (byte)2;
        }
        if (Log.isInfo()) {
            object3 = this.hosted.getEprInfoSet().iterator();
            object2 = new StringBuffer();
            while (object3.hasNext()) {
                object = (EprInfo)object3.next();
                ((StringBuffer)object2).append(((EprInfo)object).getEndpointReference().getAddress());
                if (!object3.hasNext()) continue;
                ((StringBuffer)object2).append(", ");
            }
            Log.info("Service [ " + object2 + " ] online.");
        }
        this.state = (byte)3;
    }

    public synchronized void stop() throws IOException {
        Object object;
        if (this.state == 1) {
            return;
        }
        if (this.subscriptionManager != null) {
            this.subscriptionManager.sendSubscriptionEnd();
        }
        this.undeployMetadataResources();
        int[] nArray = SERVICE_MESSAGE_TYPES;
        Iterator iterator = this.portTypes.values().iterator();
        while (iterator.hasNext()) {
            object = (ServiceCommons.PortType)iterator.next();
            if (!((ServiceCommons.PortType)object).hasEventSources()) continue;
            nArray = EVENTED_SERVICE_MESSAGE_TYPES;
            break;
        }
        DeviceServiceRegistry.unregister(this);
        iterator = this.bindings.iterator();
        while (iterator.hasNext()) {
            object = (CommunicationBinding)iterator.next();
            EndpointReference endpointReference = new EndpointReference(object.getTransportAddress());
            this.hosted.getEprInfoSet().remove(new EprInfo(endpointReference, null, object.getCommunicationManagerId()));
            CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(object.getCommunicationManagerId());
            communicationManager.unregisterService(nArray, (CommunicationBinding)object, this.incomingListener);
        }
        this.state = 1;
    }

    public synchronized void pause() {
        this.state = (byte)2;
    }

    public synchronized boolean isRunning() {
        return this.state == 3;
    }

    public ServiceReference getServiceReference() {
        if (this.serviceReference == null) {
            this.serviceReference = DeviceServiceRegistry.getUpdatedServiceReference(this.hosted, this.getParentDeviceReference(), CommunicationManagerRegistry.getDefault(), null);
            ((ServiceReferenceInternal)this.serviceReference).setService(this, this.hosted);
        }
        return this.serviceReference;
    }

    public boolean hasBindings() {
        return this.bindings.size() > 0;
    }

    public Iterator getBindings() {
        return new ReadOnlyIterator(this.bindings);
    }

    public synchronized boolean supportsBindingChanges() {
        return this.state == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinding(CommunicationBinding communicationBinding) throws WS4DIllegalStateException {
        this.exclusiveLock();
        try {
            this.bindings.add(communicationBinding);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBinding(CommunicationBinding communicationBinding) throws WS4DIllegalStateException {
        this.exclusiveLock();
        try {
            boolean bl = this.bindings.remove(communicationBinding);
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBindings() throws WS4DIllegalStateException {
        this.exclusiveLock();
        try {
            this.bindings.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected void sharedLock() {
        if (this.parentDevice == null) {
            return;
        }
        this.parentDevice.sharedLock();
    }

    protected void exclusiveLock() {
        if (this.state != 1) {
            throw new RuntimeException("Service must not be changed while running!");
        }
        if (this.parentDevice == null) {
            return;
        }
        this.parentDevice.exclusiveLock();
    }

    protected void releaseSharedLock() {
        if (this.parentDevice == null) {
            return;
        }
        this.parentDevice.releaseSharedLock();
    }

    protected void releaseExclusiveLock() {
        if (this.state != 1) {
            throw new RuntimeException("Service must not be changed while running!");
        }
        if (this.parentDevice == null) {
            return;
        }
        this.parentDevice.releaseExclusiveLock();
    }

    public boolean isRemote() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getServiceId() {
        this.sharedLock();
        try {
            URI uRI = this.hosted.getServiceId();
            if (uRI == null) {
                uRI = new URI(this.sid);
                this.exclusiveLock();
                try {
                    this.hosted.setServiceId(uRI);
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            URI uRI2 = uRI;
            return uRI2;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getOperations() {
        this.sharedLock();
        try {
            Iterator iterator = super.getOperations();
            return iterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getOperations(QName qName) {
        this.sharedLock();
        try {
            Iterator iterator = super.getOperations(qName);
            return iterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation getOperation(QName qName, String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        this.sharedLock();
        try {
            Operation operation = super.getOperation(qName, string, string2, string3);
            return operation;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation getOperation(String string) {
        if (string == null) {
            return null;
        }
        this.sharedLock();
        try {
            Operation operation = super.getOperation(string);
            return operation;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation getAnyOperation(QName qName, String string) {
        if (string == null) {
            return null;
        }
        this.sharedLock();
        try {
            Operation operation = super.getAnyOperation(qName, string);
            return operation;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getEventSources() {
        this.sharedLock();
        try {
            Iterator iterator = super.getEventSources();
            return iterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getEventSources(QName qName) {
        this.sharedLock();
        try {
            Iterator iterator = super.getEventSources(qName);
            return iterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSource getEventSource(QName qName, String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        this.sharedLock();
        try {
            EventSource eventSource = super.getEventSource(qName, string, string2, string3);
            return eventSource;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSource getEventSource(String string) {
        if (string == null) {
            return null;
        }
        this.sharedLock();
        try {
            EventSource eventSource = super.getEventSource(string);
            return eventSource;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSource getAnyEventSource(QName qName, String string) {
        if (string == null) {
            return null;
        }
        this.sharedLock();
        try {
            EventSource eventSource = super.getAnyEventSource(qName, string);
            return eventSource;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceId(URI uRI) {
        this.exclusiveLock();
        try {
            this.hosted.setServiceId(uRI);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public Iterator getPortTypes() {
        QNameSet qNameSet = this.hosted.getTypes();
        return qNameSet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(qNameSet.iterator());
    }

    public void addPortType(QName qName) {
        if (this.portTypes.containsKey(qName)) {
            return;
        }
        this.portTypes.put(qName, new ServiceCommons.PortType());
    }

    public Iterator getEprInfos() {
        EprInfoSet eprInfoSet = this.hosted.getEprInfoSet();
        return eprInfoSet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(eprInfoSet.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is null");
        }
        this.exclusiveLock();
        try {
            String string;
            QName qName = operation.getPortType();
            ServiceCommons.OperationSignature operationSignature = new ServiceCommons.OperationSignature(operation);
            ServiceCommons.PortType portType = (ServiceCommons.PortType)this.portTypes.get(qName);
            if (portType == null) {
                portType = new ServiceCommons.PortType();
                this.portTypes.put(qName, portType);
            } else {
                if (portType.isPlombed()) {
                    throw new WS4DIllegalStateException("Operations can not be added to an existing port type after a service has been started once");
                }
                string = operation.getInputName();
                String string2 = operation.getOutputName();
                int n = 1;
                int n2 = 1;
                while (portType.contains(operationSignature)) {
                    if (operation.isInputNameSet()) {
                        if (operation.isOneWay() || operation.isOutputNameSet()) {
                            throw new IllegalArgumentException("duplicate operation or event: " + operation);
                        }
                        operation.setOutputNameInternal(string2 + n2++);
                    } else {
                        operation.setInputNameInternal(string + n++);
                    }
                    operationSignature = new ServiceCommons.OperationSignature(operation);
                }
            }
            string = operation.getInputAction();
            if (this.operations.containsKey(string)) {
                if (operation.isInputActionSet() || operation.isOneWay()) {
                    throw new IllegalArgumentException("duplicate input action: " + string);
                }
                string = operation.setExtendedDefaultInputAction();
                if (this.operations.containsKey(string)) {
                    throw new IllegalArgumentException("duplicate input action: " + string);
                }
            }
            portType.addOperation(operationSignature, operation);
            this.operations.put(operation.getInputAction(), operation);
            operation.setService(this);
            if (Log.isDebug()) {
                Log.debug("[NEW OPERATION]: " + operation.toString(), 2);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventSource(EventSource eventSource) {
        if (eventSource == null) {
            throw new RuntimeException("Cannot add event to service. No event given.");
        }
        if (!(eventSource instanceof OperationCommons)) {
            throw new RuntimeException("Cannot add event to service. Given event MUST extend the operation class.");
        }
        EventingFactory eventingFactory = null;
        try {
            eventingFactory = DPWSFramework.getEventingFactory();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        this.exclusiveLock();
        try {
            String string;
            QName qName = eventSource.getPortType();
            ServiceCommons.OperationSignature operationSignature = new ServiceCommons.OperationSignature(eventSource);
            ServiceCommons.PortType portType = (ServiceCommons.PortType)this.portTypes.get(qName);
            if (portType == null) {
                portType = new ServiceCommons.PortType();
                this.portTypes.put(qName, portType);
            } else {
                if (portType.isPlombed()) {
                    throw new WS4DIllegalStateException("Events can not be added to an existing port type after a service has been started once");
                }
                string = eventSource.getOutputName();
                String string2 = eventSource.getInputName();
                int n = 1;
                int n2 = 1;
                while (portType.contains(operationSignature)) {
                    if (((OperationCommons)((Object)eventSource)).isOutputNameSet()) {
                        if (eventSource.isNotification() || ((OperationCommons)((Object)eventSource)).isInputNameSet()) {
                            throw new IllegalArgumentException("duplicate operation or event: " + eventSource);
                        }
                        ((OperationCommons)((Object)eventSource)).setInputNameInternal(string2 + n2++);
                    } else {
                        ((OperationCommons)((Object)eventSource)).setOutputNameInternal(string + n++);
                    }
                    operationSignature = new ServiceCommons.OperationSignature(eventSource);
                }
            }
            string = eventSource.getOutputAction();
            if (this.events.containsKey(string)) {
                if (((OperationCommons)((Object)eventSource)).isOutputActionSet() || eventSource.isNotification()) {
                    throw new IllegalArgumentException("duplicate output action: " + string);
                }
                string = ((OperationCommons)((Object)eventSource)).setExtendedDefaultOutputAction();
                if (this.events.containsKey(string)) {
                    throw new IllegalArgumentException("duplicate output action: " + string);
                }
            }
            portType.addEventSource(operationSignature, eventSource);
            this.events.put(eventSource.getOutputAction(), eventSource);
            if (this.subscriptionManager == null) {
                this.subscriptionManager = eventingFactory.getSubscriptionManager(this);
            }
            ((OperationCommons)((Object)eventSource)).setService(this);
            if (Log.isDebug()) {
                Log.debug("[NEW EVENT SOURCE]: " + eventSource.toString(), 2);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public int getConfigurationID() {
        return this.configurationId;
    }

    public void setParentDevice(LocalDevice localDevice) {
        this.parentDevice = localDevice;
    }

    public DeviceReference getParentDeviceReference() {
        if (this.parentDevice == null) {
            return null;
        }
        return this.parentDevice.getDeviceReference();
    }

    protected void deployMetadataResources() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            String string = "ws4d/resources/";
            HashSet hashSet = new HashSet(this.portTypes.size() * 2);
            HashMap hashMap = new HashMap();
            Iterator iterator = this.portTypes.keySet().iterator();
            while (iterator.hasNext()) {
                object10 = (QName)iterator.next();
                object9 = ((QName)object10).getNamespace();
                if (((String)object9).equals("")) {
                    object8 = new QName(((QName)object10).getLocalPart(), this.parentDevice.getDefaultNamespace(), ((QName)object10).getPrefix(), ((QName)object10).getPriority());
                    object7 = (ServiceCommons.PortType)this.portTypes.get(object10);
                    hashMap.put(object8, object7);
                    object6 = ((ServiceCommons.PortType)object7).getOperations();
                    while (object6.hasNext()) {
                        object5 = (Operation)object6.next();
                        object4 = ((OperationCommons)object5).getInput();
                        if (object4 != null && ((Reference)object4).getName() != null && ((QName)(object3 = ((Reference)object4).getName())).getNamespace().equals("")) {
                            object2 = new QName(((QName)object3).getLocalPart(), this.parentDevice.getDefaultNamespace(), ((QName)object3).getPrefix(), ((QName)object3).getPriority());
                            ((OperationCommons)object5).getInput().setName((QName)object2);
                        }
                        if ((object3 = ((OperationCommons)object5).getOutput()) == null || ((Reference)object3).getName() == null || !((QName)(object2 = ((Reference)object3).getName())).getNamespace().equals("")) continue;
                        object = new QName(((QName)object2).getLocalPart(), this.parentDevice.getDefaultNamespace(), ((QName)object2).getPrefix(), ((QName)object2).getPriority());
                        ((Reference)object3).setName((QName)object);
                    }
                } else {
                    object8 = (ServiceCommons.PortType)this.portTypes.get(object10);
                    hashMap.put(object10, object8);
                }
                ((DataStructure)hashSet).add(object9);
            }
            this.portTypes.clear();
            this.portTypes.putAll(hashMap);
            iterator = ((DataStructure)hashSet).iterator();
            while (iterator.hasNext()) {
                object10 = (String)iterator.next();
                if (((String)object10).equals("")) {
                    object10 = this.parentDevice.getDefaultNamespace();
                }
                object9 = this.getDescription((String)object10);
                if (!this.wsdls.containsKey(object10)) continue;
                object8 = DefaultService.createResourcePath((String)object10, "description.wsdl");
                object7 = this.bindings.iterator();
                while (object7.hasNext()) {
                    object6 = (CommunicationBinding)object7.next();
                    object5 = CommunicationManagerRegistry.getManager(object6.getCommunicationManagerId());
                    object4 = object5.registerResource((Resource)object9, (CommunicationBinding)object6, string + ((ResourcePath)object8).path, null);
                    object3 = (Set)this.wsdlURIs.get(object6);
                    if (object3 == null) {
                        object3 = new HashSet();
                        this.wsdlURIs.put(object6, object3);
                    }
                    ((DataStructure)object3).add(object4);
                    object3 = (Set)this.resourceURIs.get(object6);
                    if (object3 == null) {
                        object3 = new HashSet();
                        this.resourceURIs.put(object6, object3);
                    }
                    ((DataStructure)object3).add(object4);
                    if (Log.isDebug()) {
                        Log.debug("Service [ WSDL = " + object4 + " ]", 2);
                    }
                    this.recurseLinkedWsdls((WSDL)object9, (CommunicationBinding)object6, string, ((ResourcePath)object8).depth);
                    object2 = ((WSDL)object9).getTypes();
                    while (object2.hasNext()) {
                        object = (Schema)object2.next();
                        this.recurseLinkedSchemas((Schema)object, (CommunicationBinding)object6, string, ((ResourcePath)object8).depth);
                    }
                }
            }
        }
        catch (IOException iOException) {
            Log.warn("No HTTP Server found. Cannot register WSDL for download.");
        }
    }

    private void recurseLinkedWsdls(WSDL wSDL, CommunicationBinding communicationBinding, String string, int n) throws IOException {
        Iterator iterator = wSDL.getLinkedWsdls();
        while (iterator.hasNext()) {
            WSDL wSDL2 = (WSDL)iterator.next();
            String string2 = wSDL2.getTargetNamespace();
            ResourcePath resourcePath = DefaultService.createResourcePath(string2, "description.wsdl");
            String string3 = resourcePath.path;
            for (int i = 0; i < n; ++i) {
                string3 = "../" + string3;
            }
            wSDL.addImport(string2, string3);
            CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(communicationBinding.getCommunicationManagerId());
            URI uRI = communicationManager.registerResource(wSDL2, communicationBinding, string + resourcePath.path, null);
            Set set = (Set)this.resourceURIs.get(communicationBinding);
            if (set == null) {
                set = new HashSet();
                this.resourceURIs.put(communicationBinding, set);
            }
            set.add(uRI);
            if (Log.isDebug()) {
                Log.debug("Service [ WSDL = " + uRI + " ]", 2);
            }
            this.recurseLinkedWsdls(wSDL2, communicationBinding, string, resourcePath.depth);
        }
    }

    protected void recurseLinkedSchemas(Schema schema, CommunicationBinding communicationBinding, String string, int n) throws IOException {
        HashSet hashSet = new HashSet();
        this.recurseLinkedSchemas(schema, communicationBinding, string, n, hashSet);
    }

    protected void recurseLinkedSchemas(Schema schema, CommunicationBinding communicationBinding, String string, int n, DataStructure dataStructure) throws IOException {
        Iterator iterator = schema.getLinkedSchemas();
        while (iterator.hasNext()) {
            Schema schema2 = (Schema)iterator.next();
            String string2 = schema2.getTargetNamespace();
            ResourcePath resourcePath = DefaultService.createResourcePath(string2, "schema.xsd");
            String string3 = resourcePath.path;
            for (int i = 0; i < n; ++i) {
                string3 = "../" + string3;
            }
            schema.addImport(string2, string3);
            if (dataStructure.contains(string2)) continue;
            CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(communicationBinding.getCommunicationManagerId());
            URI uRI = communicationManager.registerResource(schema2, communicationBinding, string + resourcePath.path, null);
            dataStructure.add(string2);
            Set set = (Set)this.resourceURIs.get(communicationBinding);
            if (set == null) {
                set = new HashSet();
                this.resourceURIs.put(communicationBinding, set);
            }
            set.add(uRI);
            if (Log.isDebug()) {
                Log.debug("Service [ Schema = " + uRI + " ]", 2);
            }
            this.recurseLinkedSchemas(schema2, communicationBinding, string, resourcePath.depth, dataStructure);
        }
    }

    protected void undeployMetadataResources() {
        Iterator iterator = this.bindings.iterator();
        while (iterator.hasNext()) {
            CommunicationBinding communicationBinding = (CommunicationBinding)iterator.next();
            this.wsdlURIs.remove(communicationBinding);
            HashSet hashSet = (HashSet)this.resourceURIs.remove(communicationBinding);
            if (hashSet == null) continue;
            Iterator iterator2 = ((DataStructure)hashSet).iterator();
            while (iterator2.hasNext()) {
                URI uRI = (URI)iterator2.next();
                try {
                    CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(communicationBinding.getCommunicationManagerId());
                    communicationManager.unregisterResource(uRI, communicationBinding);
                }
                catch (IOException iOException) {
                    Log.printStackTrace(iOException);
                }
            }
        }
    }

    public Iterator getTargetNamespaces() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.portTypes.keySet().iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            ((DataStructure)hashSet).add(qName.getNamespace());
        }
        return new ReadOnlyIterator(hashSet);
    }

    public Iterator getDescriptionsForPortTypes() {
        Iterator iterator = this.getTargetNamespaces();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ((DataStructure)hashSet).add(this.getDescription(string));
        }
        return new ReadOnlyIterator(hashSet);
    }

    public WSDL getDescription(String string) {
        Object object;
        WSDL wSDL = this.getExistingDescription(string);
        if (wSDL != null) {
            this.addServiceAndPortsIfMissing(wSDL);
            return wSDL;
        }
        wSDL = new WSDL(string);
        HashMap hashMap = SchemaUtil.createSchema(this, string);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (HashMap.Entry)iterator.next();
            wSDL.addTypes((Schema)((HashMap.Entry)object).getValue());
        }
        object = this.portTypes.entrySet();
        Iterator iterator2 = ((DataStructure)object).iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            Object object14;
            Object object15;
            Object object16;
            Object object17;
            Object object18;
            HashMap.Entry entry = (HashMap.Entry)iterator2.next();
            QName qName = (QName)entry.getKey();
            String string2 = qName.getNamespace();
            if (!string.equals(string2)) continue;
            ServiceCommons.PortType portType = (ServiceCommons.PortType)entry.getValue();
            WSDLPortType wSDLPortType = new WSDLPortType(qName);
            if (portType.hasAttributes()) {
                wSDLPortType.setAttributes(portType.getAttributes());
            }
            Iterator iterator3 = portType.getOperations();
            while (iterator3.hasNext()) {
                object18 = (Operation)iterator3.next();
                object17 = ((OperationCommons)object18).getName();
                object16 = new WSDLOperation((String)object17);
                if (((AttributableSupport)object18).hasAttributes()) {
                    ((WSDLOperation)object16).setAttributes(((AttributableSupport)object18).getAttributes());
                }
                object15 = ((OperationCommons)object18).getInputName();
                object14 = new QName((String)object15 + "Message", string2);
                object13 = new IOType((QName)object14);
                if (((OperationCommons)object18).hasInputAttributes()) {
                    ((IOType)object13).setAttributes(((OperationCommons)object18).getInputAttributes());
                }
                if (((OperationCommons)object18).isInputNameSet()) {
                    ((IOType)object13).setName((String)object15);
                }
                if (((OperationCommons)object18).isInputActionSet() || ((OperationCommons)object18).isInputActionExtended()) {
                    ((IOType)object13).setAction(((OperationCommons)object18).getInputAction());
                }
                object12 = new WSDLMessage((QName)object14);
                object11 = ((OperationCommons)object18).getInput();
                if (object11 != null) {
                    object10 = new WSDLMessagePart();
                    ((WSDLMessagePart)object10).setElementName(((Reference)object11).getName());
                    ((WSDLMessage)object12).addPart((WSDLMessagePart)object10);
                }
                wSDL.addMessage((WSDLMessage)object12);
                ((WSDLOperation)object16).setInput((IOType)object13);
                if (((Operation)object18).isRequestResponse()) {
                    object10 = ((OperationCommons)object18).getOutputName();
                    object9 = new QName((String)object10 + "Message", string2);
                    object8 = new IOType((QName)object9);
                    if (((OperationCommons)object18).hasOutputAttributes()) {
                        ((IOType)object8).setAttributes(((OperationCommons)object18).getOutputAttributes());
                    }
                    if (((OperationCommons)object18).isOutputNameSet()) {
                        ((IOType)object8).setName((String)object10);
                    }
                    if (((OperationCommons)object18).isOutputActionSet()) {
                        ((IOType)object8).setAction(((OperationCommons)object18).getOutputAction());
                    }
                    object7 = new WSDLMessage((QName)object9);
                    object6 = ((OperationCommons)object18).getOutput();
                    if (object6 != null) {
                        object5 = new WSDLMessagePart();
                        ((WSDLMessagePart)object5).setElementName(((Reference)object6).getName());
                        ((WSDLMessage)object7).addPart((WSDLMessagePart)object5);
                    }
                    wSDL.addMessage((WSDLMessage)object7);
                    ((WSDLOperation)object16).setOutput((IOType)object8);
                }
                object10 = ((OperationCommons)object18).getFaults();
                while (object10.hasNext()) {
                    object9 = (Fault)object10.next();
                    object8 = ((Fault)object9).getName();
                    object7 = new QName((String)object17 + (String)object8 + "Message", string2);
                    object6 = new IOType((QName)object7);
                    if (((AttributableSupport)object9).hasAttributes()) {
                        ((IOType)object6).setAttributes(((AttributableSupport)object9).getAttributes());
                    }
                    ((IOType)object6).setName((String)object8);
                    object5 = ((Fault)object9).getAction();
                    if (object5 != null) {
                        ((IOType)object6).setAction((String)object5);
                    }
                    object4 = new WSDLMessage((QName)object7);
                    object3 = ((Fault)object9).getElement();
                    if (object3 != null) {
                        object2 = new WSDLMessagePart();
                        ((WSDLMessagePart)object2).setElementName(((Reference)object3).getName());
                        ((WSDLMessage)object4).addPart((WSDLMessagePart)object2);
                    }
                    wSDL.addMessage((WSDLMessage)object4);
                    ((WSDLOperation)object16).addFault((IOType)object6);
                }
                wSDLPortType.addOperation((WSDLOperation)object16);
            }
            object18 = portType.getEventSources();
            while (object18.hasNext()) {
                object17 = (OperationCommons)object18.next();
                object16 = ((OperationCommons)object17).getName();
                wSDLPortType.setEventSource(true);
                object15 = new WSDLOperation((String)object16);
                if (((AttributableSupport)object17).hasAttributes()) {
                    ((WSDLOperation)object15).setAttributes(((AttributableSupport)object17).getAttributes());
                }
                object14 = ((OperationCommons)object17).getOutputName();
                object13 = new QName((String)object14 + "Message", string2);
                object12 = new IOType((QName)object13);
                if (((OperationCommons)object17).hasOutputAttributes()) {
                    ((IOType)object12).setAttributes(((OperationCommons)object17).getOutputAttributes());
                }
                if (((OperationCommons)object17).isOutputNameSet()) {
                    ((IOType)object12).setName((String)object14);
                }
                if (((OperationCommons)object17).isOutputActionSet() || ((OperationCommons)object17).isOutputActionExtended()) {
                    ((IOType)object12).setAction(((OperationCommons)object17).getOutputAction());
                }
                object11 = new WSDLMessage((QName)object13);
                object10 = ((OperationCommons)object17).getOutput();
                if (object10 != null) {
                    object9 = new WSDLMessagePart();
                    ((WSDLMessagePart)object9).setElementName(((Reference)object10).getName());
                    ((WSDLMessage)object11).addPart((WSDLMessagePart)object9);
                }
                wSDL.addMessage((WSDLMessage)object11);
                ((WSDLOperation)object15).setOutput((IOType)object12);
                if (((EventSource)object17).isSolicitResponse()) {
                    object9 = ((OperationCommons)object17).getInputName();
                    object8 = new QName((String)object9 + "Message", string2);
                    object7 = new IOType((QName)object8);
                    if (((OperationCommons)object17).hasInputAttributes()) {
                        ((IOType)object7).setAttributes(((OperationCommons)object17).getInputAttributes());
                    }
                    if (((OperationCommons)object17).isInputNameSet()) {
                        ((IOType)object7).setName((String)object9);
                    }
                    if (((OperationCommons)object17).isInputActionSet()) {
                        ((IOType)object7).setAction(((OperationCommons)object17).getInputAction());
                    }
                    object6 = new WSDLMessage((QName)object8);
                    object5 = ((OperationCommons)object17).getInput();
                    if (object5 != null) {
                        object4 = new WSDLMessagePart();
                        ((WSDLMessagePart)object4).setElementName(((Reference)object5).getName());
                        ((WSDLMessage)object6).addPart((WSDLMessagePart)object4);
                    }
                    wSDL.addMessage((WSDLMessage)object6);
                    ((WSDLOperation)object15).setInput((IOType)object7);
                }
                object9 = ((OperationCommons)object17).getFaults();
                while (object9.hasNext()) {
                    object8 = (Fault)object9.next();
                    object7 = ((Fault)object8).getName();
                    object6 = new QName((String)object16 + (String)object7 + "Message", string2);
                    object5 = new IOType((QName)object6);
                    if (((AttributableSupport)object8).hasAttributes()) {
                        ((IOType)object5).setAttributes(((AttributableSupport)object8).getAttributes());
                    }
                    ((IOType)object5).setName(((Fault)object8).getName());
                    object4 = ((Fault)object8).getAction();
                    if (object4 != null) {
                        ((IOType)object5).setAction((String)object4);
                    }
                    object3 = new WSDLMessage((QName)object6);
                    object2 = ((Fault)object8).getElement();
                    if (object2 != null) {
                        WSDLMessagePart wSDLMessagePart = new WSDLMessagePart();
                        wSDLMessagePart.setElementName(((Reference)object2).getName());
                        ((WSDLMessage)object3).addPart(wSDLMessagePart);
                    }
                    wSDL.addMessage((WSDLMessage)object3);
                    ((WSDLOperation)object15).addFault((IOType)object5);
                }
                wSDLPortType.addOperation((WSDLOperation)object15);
            }
            wSDL.addPortType(wSDLPortType);
            wSDL.addBinding(new SOAP12DocumentLiteralHTTPBinding(new QName(qName.getLocalPart() + BINDING_POSTFIX, string2), qName));
        }
        this.wsdls.put(string, wSDL);
        this.addServiceAndPortsIfMissing(wSDL);
        return wSDL;
    }

    private void addServiceAndPortsIfMissing(WSDL wSDL) {
        if (wSDL == null) {
            return;
        }
        WSDLService wSDLService = wSDL.getService(this.sid);
        if (wSDLService == null) {
            wSDLService = new WSDLService(new QName(this.sid, wSDL.getTargetNamespace()));
            try {
                wSDL.addService(wSDLService);
            }
            catch (UnsupportedBindingException unsupportedBindingException) {
                // empty catch block
            }
        }
        Iterator iterator = wSDL.getBindings();
        while (iterator.hasNext()) {
            WSDLBinding wSDLBinding = (WSDLBinding)iterator.next();
            WSDLPortType wSDLPortType = wSDLBinding.getPortType();
            if (wSDLService.containsPortsForBinding(wSDLBinding.getName())) continue;
            int n = 0;
            String string = wSDLPortType.getLocalName() + "Port";
            Iterator iterator2 = this.getEprInfos();
            while (iterator2.hasNext()) {
                EprInfo eprInfo = (EprInfo)iterator2.next();
                SOAP12DocumentLiteralHTTPPort sOAP12DocumentLiteralHTTPPort = new SOAP12DocumentLiteralHTTPPort(string + n++, wSDLBinding.getName());
                sOAP12DocumentLiteralHTTPPort.setLocation(eprInfo.getXAddress());
                wSDLService.addPort(sOAP12DocumentLiteralHTTPPort);
            }
        }
    }

    public void define(URI uRI) throws IOException {
        WSDL wSDL = WSDLRepository.loadWsdl(uRI);
        this.define(wSDL);
    }

    public void define(WSDL wSDL) throws IOException {
        Iterator iterator = wSDL.getSupportedPortTypes().iterator();
        if (!iterator.hasNext()) {
            Log.warn("WSDL doesn't contain any supported port types.");
        } else {
            Object object;
            while (iterator.hasNext()) {
                object = (WSDLPortType)iterator.next();
                this.processWSDLPortType((WSDLPortType)object);
            }
            object = null;
            try {
                object = DPWSFramework.getEventingFactory();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            if (!this.events.isEmpty() && this.subscriptionManager == null) {
                this.subscriptionManager = object.getSubscriptionManager(this);
            }
        }
        this.wsdls.put(wSDL.getTargetNamespace(), wSDL);
    }

    protected Operation createOperation(WSDLOperation wSDLOperation) {
        return new OperationStub(wSDLOperation);
    }

    public ClientSubscription subscribe(EventSink eventSink, String string, URISet uRISet, long l) throws EventingException, TimeoutException {
        ClientSubscription clientSubscription = null;
        if (this.subscriptionManager != null) {
            clientSubscription = this.subscriptionManager.subscribe(eventSink, string, uRISet, l);
            eventSink.addSubscription(string, clientSubscription);
        }
        return clientSubscription;
    }

    public void unsubscribe(ClientSubscription clientSubscription) throws EventingException, TimeoutException {
        ((ClientSubscriptionInternal)clientSubscription).dispose();
        if (this.subscriptionManager != null) {
            this.subscriptionManager.unsubscribe(clientSubscription);
        }
    }

    public long renew(ClientSubscription clientSubscription, long l) throws EventingException, TimeoutException {
        if (this.subscriptionManager != null) {
            long l2 = this.subscriptionManager.renew(clientSubscription, l);
            ((ClientSubscriptionInternal)clientSubscription).renewInternal(l2);
        }
        return 0L;
    }

    public long getStatus(ClientSubscription clientSubscription) throws EventingException, TimeoutException {
        if (this.subscriptionManager != null) {
            return this.subscriptionManager.getStatus(clientSubscription);
        }
        return 0L;
    }

    public void addUser(HTTPUser hTTPUser) {
        if (this.userGroup == null) {
            this.userGroup = new HTTPGroup();
        }
        this.userGroup.addUser(hTTPUser);
    }

    public void addGroup(HTTPGroup hTTPGroup) {
        if (this.userGroup == null) {
            this.userGroup = hTTPGroup;
        }
    }

    private static class ResourcePath {
        final String path;
        final int depth;

        ResourcePath(String string, int n) {
            this.path = string;
            this.depth = n;
        }
    }

    protected class ServiceMessageListener
    extends DefaultIncomingMessageListener {
        protected ServiceMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetMetadataResponseMessage handle(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) throws SOAPException {
            if (!DefaultService.this.isRunning()) {
                throw new SOAPException(FaultMessage.createEndpointUnavailableFault(getMetadataMessage));
            }
            GetMetadataResponseMessage getMetadataResponseMessage = new GetMetadataResponseMessage(protocolData.getCommunicationManagerId());
            getMetadataResponseMessage.setResponseTo(getMetadataMessage);
            getMetadataResponseMessage.setProtocolInfo(getMetadataMessage.getProtocolInfo());
            DefaultService.this.sharedLock();
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                if (DefaultService.this.parentDevice != null) {
                    Object object5;
                    Object object6;
                    Object object7;
                    object4 = new RelationshipMData();
                    object3 = new HostMData();
                    ((HostMData)object3).setEndpointReference(DefaultService.this.parentDevice.getEndpointReference());
                    object2 = new QNameSet();
                    object = DefaultService.this.parentDevice.getPortTypes();
                    while (object.hasNext()) {
                        object7 = (QName)object.next();
                        ((QNameSet)object2).add((QName)object7);
                    }
                    ((HostMData)object3).setTypes((QNameSet)object2);
                    ((RelationshipMData)object4).setHost((HostMData)object3);
                    object = DefaultService.this.getEprInfos();
                    object7 = new EprInfoSet();
                    while (object.hasNext()) {
                        object6 = (EprInfo)object.next();
                        if (((XAddressInfo)object6).getXAddress() == null) continue;
                        ((EprInfoSet)object7).add((EprInfo)object6);
                    }
                    DefaultService.this.hosted.setEprInfoSet((EprInfoSet)object7);
                    object6 = DefaultService.this.getPortTypes();
                    QNameSet qNameSet = new QNameSet();
                    while (object6.hasNext()) {
                        object5 = (QName)object6.next();
                        qNameSet.add((QName)object5);
                    }
                    DefaultService.this.hosted.setTypes(qNameSet);
                    if (DefaultService.this.hosted.getServiceId() == null) {
                        DefaultService.this.hosted.setServiceId(new URI(DefaultService.this.sid));
                    }
                    ((RelationshipMData)object4).addHosted(DefaultService.this.hosted);
                    object5 = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
                    CommunicationUtil communicationUtil = object5.getCommunicationUtil();
                    ConstantsHelper constantsHelper = communicationUtil.getHelper(protocolData.getProtocolInfo().getVersion());
                    getMetadataResponseMessage.addRelationship((RelationshipMData)object4, constantsHelper);
                }
                object4 = DefaultService.this.wsdlURIs.values().iterator();
                while (object4.hasNext()) {
                    object3 = (Set)object4.next();
                    if (object3 == null) continue;
                    object2 = ((DataStructure)object3).iterator();
                    while (object2.hasNext()) {
                        object = (URI)object2.next();
                        if (!protocolData.destinationMatches((URI)object)) continue;
                        getMetadataResponseMessage.addMetadataLocation((URI)object);
                    }
                }
            }
            finally {
                DefaultService.this.releaseSharedLock();
            }
            return getMetadataResponseMessage;
        }

        public SubscribeResponseMessage handle(SubscribeMessage subscribeMessage, ProtocolData protocolData) throws SOAPException {
            if (!DefaultService.this.isRunning()) {
                throw new SOAPException(FaultMessage.createEndpointUnavailableFault(subscribeMessage));
            }
            if (DefaultService.this.subscriptionManager == null) {
                throw new SOAPException(FaultMessage.createActionNotSupportedFault(subscribeMessage));
            }
            DefaultService.this.sharedLock();
            try {
                SubscribeResponseMessage subscribeResponseMessage = DefaultService.this.subscriptionManager.subscribe(subscribeMessage, protocolData);
                return subscribeResponseMessage;
            }
            catch (SOAPException sOAPException) {
                Log.printStackTrace(sOAPException);
                throw sOAPException;
            }
            finally {
                DefaultService.this.releaseSharedLock();
            }
        }

        public GetStatusResponseMessage handle(GetStatusMessage getStatusMessage, ProtocolData protocolData) throws SOAPException {
            if (!DefaultService.this.isRunning()) {
                throw new SOAPException(FaultMessage.createEndpointUnavailableFault(getStatusMessage));
            }
            if (DefaultService.this.subscriptionManager == null) {
                throw new SOAPException(FaultMessage.createActionNotSupportedFault(getStatusMessage));
            }
            DefaultService.this.sharedLock();
            try {
                GetStatusResponseMessage getStatusResponseMessage = DefaultService.this.subscriptionManager.getStatus(getStatusMessage, protocolData);
                return getStatusResponseMessage;
            }
            catch (SOAPException sOAPException) {
                Log.printStackTrace(sOAPException);
                throw sOAPException;
            }
            finally {
                DefaultService.this.releaseSharedLock();
            }
        }

        public RenewResponseMessage handle(RenewMessage renewMessage, ProtocolData protocolData) throws SOAPException {
            if (!DefaultService.this.isRunning()) {
                throw new SOAPException(FaultMessage.createEndpointUnavailableFault(renewMessage));
            }
            if (DefaultService.this.subscriptionManager == null) {
                throw new SOAPException(FaultMessage.createActionNotSupportedFault(renewMessage));
            }
            DefaultService.this.sharedLock();
            try {
                RenewResponseMessage renewResponseMessage = DefaultService.this.subscriptionManager.renew(renewMessage, protocolData);
                return renewResponseMessage;
            }
            catch (SOAPException sOAPException) {
                Log.printStackTrace(sOAPException);
                throw sOAPException;
            }
            finally {
                DefaultService.this.releaseSharedLock();
            }
        }

        public UnsubscribeResponseMessage handle(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) throws SOAPException {
            if (!DefaultService.this.isRunning()) {
                throw new SOAPException(FaultMessage.createEndpointUnavailableFault(unsubscribeMessage));
            }
            if (DefaultService.this.subscriptionManager == null) {
                throw new SOAPException(FaultMessage.createActionNotSupportedFault(unsubscribeMessage));
            }
            DefaultService.this.sharedLock();
            try {
                UnsubscribeResponseMessage unsubscribeResponseMessage = DefaultService.this.subscriptionManager.unsubscribe(unsubscribeMessage, protocolData);
                return unsubscribeResponseMessage;
            }
            catch (SOAPException sOAPException) {
                Log.printStackTrace(sOAPException);
                throw sOAPException;
            }
            finally {
                DefaultService.this.releaseSharedLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InvokeMessage handle(InvokeMessage invokeMessage, ProtocolData protocolData) throws SOAPException {
            Object object;
            if (!DefaultService.this.isRunning()) {
                throw new SOAPException(FaultMessage.createEndpointUnavailableFault(invokeMessage));
            }
            Operation operation = null;
            DefaultService.this.sharedLock();
            try {
                object = invokeMessage.getAction().toString();
                if (Log.isDebug()) {
                    Log.debug("<I> Receiving invocation input for " + (String)object, 2);
                }
                if ((operation = (Operation)DefaultService.this.operations.get(object)) == null) {
                    throw new SOAPException(FaultMessage.createActionNotSupportedFault(invokeMessage));
                }
            }
            finally {
                DefaultService.this.releaseSharedLock();
            }
            try {
                Object object2;
                Object object3;
                object = invokeMessage.getContent();
                if (object != null) {
                    object3 = DefaultService.this.wsdls.values();
                    object2 = ((DataStructure)object3).iterator();
                    while (object2.hasNext()) {
                        WSDL wSDL = (WSDL)object2.next();
                        Iterator iterator = wSDL.getTypes();
                        while (iterator.hasNext()) {
                            Schema schema = (Schema)iterator.next();
                            ((ParameterValue)object).resolveTypes(schema);
                        }
                    }
                }
                object3 = operation.invoke((ParameterValue)object);
                if (operation.isRequestResponse()) {
                    object2 = new InvokeMessage(operation.getOutputAction(), false, protocolData.getCommunicationManagerId());
                    ((Message)object2).setResponseTo(invokeMessage);
                    ((Message)object2).setProtocolInfo(invokeMessage.getProtocolInfo());
                    ((InvokeMessage)object2).setContent((ParameterValue)object3);
                    return object2;
                }
                return null;
            }
            catch (InvocationException invocationException) {
                Log.warn("Exception during invocation: " + invocationException.getMessage());
                FaultMessage faultMessage = new FaultMessage(invocationException.getAction(), protocolData.getCommunicationManagerId());
                faultMessage.setResponseTo(invokeMessage);
                faultMessage.setCode(invocationException.getCode());
                faultMessage.setSubcode(invocationException.getSubcode());
                faultMessage.setReason(invocationException.getReason());
                faultMessage.setDetail(invocationException.getDetail());
                throw new SOAPException(faultMessage);
            }
            catch (TimeoutException timeoutException) {
                Log.printStackTrace(timeoutException);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OperationDescription getOperation(String string) {
            Operation operation = null;
            DefaultService.this.sharedLock();
            try {
                operation = (Operation)DefaultService.this.operations.get(string);
            }
            finally {
                DefaultService.this.releaseSharedLock();
            }
            return operation;
        }
    }
}

