/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.dispatch.DefaultDeviceReference;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.ServiceReferenceInternal;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.Device;
import org.ws4d.java.service.DeviceCommons;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;

public class ProxyDevice
extends DeviceCommons {
    private DeviceReference deviceReference = null;
    private Set serviceReferences = null;
    private boolean valid = true;

    public ProxyDevice(GetResponseMessage getResponseMessage, DefaultDeviceReference defaultDeviceReference, Device device, ProtocolData protocolData) {
        super(getResponseMessage.getThisModel(), getResponseMessage.getThisDevice());
        Iterator iterator;
        Object object;
        Object object2;
        this.deviceReference = defaultDeviceReference;
        this.setSecure(defaultDeviceReference.isSecureDevice());
        DataStructure dataStructure = getResponseMessage.getHosted();
        if (dataStructure == null) {
            return;
        }
        this.serviceReferences = new HashSet(dataStructure.size());
        HashMap hashMap = null;
        if (device != null) {
            if (device instanceof ProxyDevice) {
                object2 = (ProxyDevice)device;
                object = ((ProxyDevice)object2).serviceReferences;
                hashMap = new HashMap(((DataStructure)object).size());
                iterator = ((DataStructure)object).iterator();
            } else {
                iterator = device.getServiceReferences();
                hashMap = new HashMap();
            }
            while (iterator.hasNext()) {
                object2 = (ServiceReference)iterator.next();
                hashMap.put(object2.getServiceId(), object2);
            }
        }
        iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            Object object3;
            object2 = (HostedMData)iterator.next();
            object = ((HostedMData)object2).getEprInfoSet().iterator();
            while (object.hasNext()) {
                object3 = (EprInfo)object.next();
                if (((XAddressInfo)object3).getProtocolInfo() != null && !((XAddressInfo)object3).isProtocolInfoNotDependable()) continue;
                ((XAddressInfo)object3).mergeProtocolInfo(protocolData.getProtocolInfo());
                ((XAddressInfo)object3).setProtocolInfoNotDependable(true);
            }
            if (hashMap != null) {
                object3 = ((HostedMData)object2).getServiceId();
                object = (ServiceReferenceInternal)hashMap.remove(object3);
                if (object == null) {
                    object = (ServiceReferenceInternal)DeviceServiceRegistry.getUpdatedServiceReference((HostedMData)object2, defaultDeviceReference, protocolData.getCommunicationManagerId(), protocolData);
                } else {
                    object.update((HostedMData)object2, defaultDeviceReference, protocolData);
                }
            } else {
                object = (ServiceReferenceInternal)DeviceServiceRegistry.getUpdatedServiceReference((HostedMData)object2, defaultDeviceReference, protocolData.getCommunicationManagerId(), protocolData);
            }
            this.serviceReferences.add(object);
        }
        if (hashMap != null) {
            iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                object2 = (ServiceReferenceInternal)iterator.next();
                object2.disconnectFromDevice();
            }
        }
    }

    public boolean isRemote() {
        return true;
    }

    public EndpointReference getEndpointReference() {
        return this.deviceReference.getEndpointReference();
    }

    public Iterator getPortTypes() {
        try {
            return this.deviceReference.getDevicePortTypes(false);
        }
        catch (TimeoutException timeoutException) {
            Log.printStackTrace(timeoutException);
            return EmptyStructures.EMPTY_ITERATOR;
        }
    }

    public long getMetadataVersion() {
        try {
            return this.deviceReference.getMetadataVersion(false);
        }
        catch (TimeoutException timeoutException) {
            Log.printStackTrace(timeoutException);
            return -1L;
        }
    }

    public DeviceReference getDeviceReference() {
        return this.deviceReference;
    }

    public Iterator getXAddressInfos() {
        try {
            return this.deviceReference.getXAddressInfos(false);
        }
        catch (TimeoutException timeoutException) {
            Log.printStackTrace(timeoutException);
            return EmptyStructures.EMPTY_ITERATOR;
        }
    }

    public Iterator getScopes() {
        try {
            return this.deviceReference.getScopes(false);
        }
        catch (TimeoutException timeoutException) {
            Log.printStackTrace(timeoutException);
            return EmptyStructures.EMPTY_ITERATOR;
        }
    }

    public Iterator getServiceReferences() {
        return this.serviceReferences == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.serviceReferences);
    }

    public Iterator getServiceReferences(QNameSet qNameSet) {
        if (this.serviceReferences == null || this.serviceReferences.size() == 0) {
            return EmptyStructures.EMPTY_ITERATOR;
        }
        HashSet hashSet = new HashSet(this.serviceReferences.size());
        this.addServiceReferences(hashSet, qNameSet);
        return new ReadOnlyIterator(hashSet);
    }

    public void addServiceReferences(DataStructure dataStructure, QNameSet qNameSet) {
        if (this.serviceReferences == null || this.serviceReferences.size() == 0) {
            return;
        }
        Iterator iterator = this.serviceReferences.iterator();
        while (iterator.hasNext()) {
            ServiceReference serviceReference = (ServiceReference)iterator.next();
            if (!qNameSet.isContainedBy(serviceReference.getPortTypes())) continue;
            dataStructure.add(serviceReference);
        }
    }

    public ServiceReference getServiceReference(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string = uRI.toString();
        Iterator iterator = this.serviceReferences.iterator();
        while (iterator.hasNext()) {
            ServiceReference serviceReference = (ServiceReference)iterator.next();
            if (!string.equals(serviceReference.getServiceId().toString())) continue;
            return serviceReference;
        }
        return null;
    }

    public ServiceReference getServiceReference(EndpointReference endpointReference) {
        if (endpointReference == null) {
            return null;
        }
        Iterator iterator = this.serviceReferences.iterator();
        while (iterator.hasNext()) {
            ServiceReference serviceReference = (ServiceReference)iterator.next();
            Iterator iterator2 = serviceReference.getEprInfos();
            while (iterator2.hasNext()) {
                EprInfo eprInfo = (EprInfo)iterator2.next();
                if (!endpointReference.equals(eprInfo.getEndpointReference())) continue;
                return serviceReference;
            }
        }
        return null;
    }

    public String getDefaultNamespace() {
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public String readCustomizeMData() {
        return this.deviceReference.getCustomMData();
    }

    public boolean hasCustomizeMData() {
        return this.readCustomizeMData() != null;
    }
}

