/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.constants.WSEConstants;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.service.DefaultSubscriptionManager;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.URISet;

public class ServiceSubscription {
    private static final long MAX_EXPIRATION_DURATION = 31536000000L;
    private static final String FAULT_REASON_INVALID_EXIRATION_TIME = "The expiration time requested is invalid.";
    private static final String FAULT_REASON_UNSUPPORTED_EXIRATION_TYPE = "Only expiration durations are supported.";
    long expirationTime;
    EprInfo notifyTo;
    EprInfo endTo;
    String communicationManagerId;
    URISet filterActions;
    EventSink sink = null;
    String clientSubscriptionId = null;
    EndpointReference subscriptionManager;
    final ProtocolInfo pInfo;

    public ServiceSubscription(ProtocolInfo protocolInfo) {
        this.pInfo = protocolInfo;
    }

    void setExpiration(String string, Message message) throws SOAPException {
        long l;
        if (string == null || (string = string.trim()).length() == 0) {
            this.expirationTime = System.currentTimeMillis() + 31536000000L;
            return;
        }
        if (string.charAt(0) == 'P') {
            l = SchemaUtil.parseDuration(string);
            if (l <= 0L) {
                throw DefaultSubscriptionManager.createFault(message, WSEConstants.WSE_FAULT_INVALID_EXPIRATION_TIME, new LocalizedString(FAULT_REASON_INVALID_EXIRATION_TIME, "en-US"));
            }
        } else {
            throw DefaultSubscriptionManager.createFault(message, WSEConstants.WSE_FAULT_UNSUPPORTED_EXPIRATION_TYPE, new LocalizedString(FAULT_REASON_UNSUPPORTED_EXIRATION_TYPE, "en-US"));
        }
        this.expirationTime = System.currentTimeMillis() + l;
    }

    void setExpiration(long l) throws EventingException {
        if (l == 0L) {
            this.expirationTime = System.currentTimeMillis() + 31536000000L;
            return;
        }
        if (l <= 0L) {
            throw new EventingException(WSEConstants.WSE_FAULT_INVALID_EXPIRATION_TIME, FAULT_REASON_INVALID_EXIRATION_TIME);
        }
        this.expirationTime = System.currentTimeMillis() + l;
    }

    void setSubscriptionManager(EndpointReference endpointReference) {
        this.subscriptionManager = endpointReference;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public EprInfo getNotifyTo() {
        return this.notifyTo;
    }

    public EprInfo getEndTo() {
        return this.endTo;
    }

    public String getCommunicationManagerID() {
        return this.communicationManagerId;
    }

    public Iterator getFilterActions() {
        return this.filterActions == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.filterActions.iterator());
    }

    public EndpointReference getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public ProtocolInfo getProtocolInfo() {
        return this.pInfo;
    }
}

