/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.UnsupportedOperationException;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.XAddressInfo;

public class XAddressInfoSet {
    private HashSet infosets = null;
    private boolean readOnly = false;

    public XAddressInfoSet() {
        this.infosets = new HashSet();
    }

    public XAddressInfoSet(int n) {
        this.infosets = new HashSet(n);
    }

    public XAddressInfoSet(XAddressInfo xAddressInfo) {
        this.infosets = new HashSet(1);
        this.add(xAddressInfo);
    }

    public XAddressInfoSet(XAddressInfoSet xAddressInfoSet) {
        this(xAddressInfoSet == null ? 1 : xAddressInfoSet.size());
        this.addAll(xAddressInfoSet);
    }

    public Iterator iterator() {
        if (this.readOnly) {
            return new ReadOnlyIterator(this.infosets);
        }
        return this.infosets.iterator();
    }

    public XAddressInfo[] toArray() {
        XAddressInfo[] xAddressInfoArray = new XAddressInfo[this.infosets.size()];
        Object[] objectArray = this.infosets.toArray();
        for (int i = 0; i < xAddressInfoArray.length; ++i) {
            xAddressInfoArray[i] = (XAddressInfo)objectArray[i];
        }
        return xAddressInfoArray;
    }

    public boolean contains(XAddressInfo xAddressInfo) {
        return this.infosets.contains(xAddressInfo);
    }

    public boolean containsAll(XAddressInfoSet xAddressInfoSet) {
        if (xAddressInfoSet == null) {
            return true;
        }
        Iterator iterator = xAddressInfoSet.iterator();
        while (iterator.hasNext()) {
            if (this.infosets.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.infosets.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.infosets.iterator();
        while (iterator.hasNext()) {
            XAddressInfo xAddressInfo = (XAddressInfo)iterator.next();
            stringBuffer.append(xAddressInfo.getXAddress().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof URISet) {
            bl = this.equals((XAddressInfoSet)object);
        }
        return bl;
    }

    public int hashCode() {
        return this.infosets.hashCode();
    }

    public boolean equals(XAddressInfoSet xAddressInfoSet) {
        if (xAddressInfoSet != null) {
            return this.infosets.equals(xAddressInfoSet);
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void add(XAddressInfo xAddressInfo) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Set status is read-only.");
        }
        if (xAddressInfo != null) {
            this.infosets.add(xAddressInfo);
        }
    }

    public XAddressInfo get(XAddressInfo xAddressInfo) {
        return (XAddressInfo)this.infosets.get(xAddressInfo);
    }

    public void addAll(XAddressInfoSet xAddressInfoSet) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Set status is read-only.");
        }
        if (xAddressInfoSet == null) {
            return;
        }
        this.infosets.addAll(xAddressInfoSet.infosets);
    }

    public boolean remove(XAddressInfo xAddressInfo) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Set status is read-only.");
        }
        return this.infosets.remove(xAddressInfo);
    }

    public void mergeProtocolInfo(ProtocolInfo protocolInfo) {
        if (protocolInfo == null) {
            return;
        }
        Iterator iterator = this.infosets.iterator();
        while (iterator.hasNext()) {
            ((XAddressInfo)iterator.next()).mergeProtocolInfo(protocolInfo);
        }
    }
}

