/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.Log;

public final class StringUtil {
    private static String[] encList = new String[]{"UTF-8", "ISO-8859-1"};
    public static final String[] day = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    public static final String[] month = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String[][] zone = new String[][]{{"UT", "0"}, {"GMT", "0"}, {"EST", "-5"}, {"EDT", "-4"}, {"CST", "-6"}, {"CDT", "-5"}, {"MST", "-7"}, {"MDT", "-6"}, {"PST", "-8"}, {"PDT", "-7"}, {"Z", "0"}, {"A", "-1"}, {"M", "-12"}, {"N", "+1"}, {"Y", "+12"}, {"J", "0"}};
    private static final boolean USE_LONG_CLASS_NAMES = false;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        return string != null && string2 != null && string.length() == string2.length() && string.regionMatches(true, 0, string2, 0, string.length());
    }

    public static int lastIndexOf(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0) {
            return -1;
        }
        int n = 0;
        int n2 = -1;
        while ((n = string2.indexOf(string, n)) != -1) {
            n2 = n++;
        }
        return n2;
    }

    public static final String getStringEncoding() {
        return encList[0];
    }

    public static String[] split(String string, char c) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(c, n)) == -1) break;
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        vector.addElement(string.substring(n));
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        Vector vector = StringUtil.stringToVector(string, string2);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] splitAtWhitespace(String string) {
        if (string == null) {
            return null;
        }
        if ("".equals(string = string.trim())) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList arrayList = new ArrayList();
        int n = string.length();
        int n2 = -1;
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n2 == -1) continue block3;
                    ((List)arrayList).add(string.substring(n2, i));
                    n2 = -1;
                    continue block3;
                }
                default: {
                    if (n2 != -1) continue block3;
                    n2 = i;
                }
            }
        }
        if (n2 != -1) {
            ((List)arrayList).add(string.substring(n2));
        }
        return (String[])((DataStructure)arrayList).toArray(new String[arrayList.size()]);
    }

    public static Vector stringToVector(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(string2, n)) == -1) break;
            vector.addElement(string.substring(n, n2));
            n = n2 + string2.length();
        }
        vector.addElement(string.substring(n));
        return vector;
    }

    public static String vectorToString(Vector vector, String string) {
        if (vector == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        String string2 = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string2 = string2 + enumeration.nextElement().toString() + string;
        }
        string2.trim();
        return string2;
    }

    public static String encodeURL(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n++);
                boolean bl = false;
                if (c >= '\u0000' && c <= '\u001f' || c == '\u007f') {
                    stringBuffer.append("%");
                    if (c <= '\u000f') {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Integer.toHexString(c));
                    bl = true;
                }
                if (c >= '\u0080' && c <= '\u00ff') {
                    stringBuffer.append("%");
                    if (c <= '\u000f') {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Integer.toHexString(c));
                    bl = true;
                }
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '<': 
                    case '>': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        stringBuffer.append("%");
                        if (c <= '\u000f') {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(Integer.toHexString(c));
                        bl = true;
                    }
                }
                if (bl) continue;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String decodeURL(String string) {
        try {
            return StringUtil.decodeURL(string, StringUtil.getStringEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.printStackTrace(unsupportedEncodingException);
            return string;
        }
    }

    public static String decodeURL(String string, String string2) throws UnsupportedEncodingException {
        char c;
        int n;
        if (string2.length() == 0) {
            throw new UnsupportedEncodingException("StringUtil.decodeURL: No encoding specified");
        }
        int n2 = string.length();
        for (n = 0; n < n2 && (c = string.charAt(n)) != '+' && c != '%'; ++n) {
        }
        if (n == n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        stringBuffer.append(cArray);
        byte[] byArray = null;
        while (n < n2) {
            c = string.charAt(n);
            if (c == '%') {
                try {
                    if (byArray == null) {
                        byArray = new byte[(n2 - n) / 3];
                    }
                    int n3 = 0;
                    while (n + 2 < n2 && c == '%') {
                        byArray[n3++] = (byte)Integer.parseInt(string.substring(n + 1, n + 3), 16);
                        if ((n += 3) >= n2) continue;
                        c = string.charAt(n);
                    }
                    if (n < n2 && c == '%') {
                        throw new IllegalArgumentException("StringUtil.decodeURL: Incomplete percent pattern");
                    }
                    stringBuffer.append(new String(byArray, 0, n3, string2));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("StringUtil.decodeURL: Unsupported character in percent pattern (" + numberFormatException.getMessage() + ")");
                }
            }
            if (c == '+') {
                stringBuffer.append(' ');
                ++n;
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String formatClassName(Class clazz) {
        return StringUtil.formatClassName(clazz.getName());
    }

    public static String formatClassName(String string) {
        return StringUtil.simpleClassName(string);
    }

    public static String simpleClassName(Class clazz) {
        return StringUtil.simpleClassName(clazz.getName());
    }

    public static String simpleClassName(String string) {
        if (string == null || "".equals(string)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String[] toStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.elementAt(i).toString();
        }
        return stringArray;
    }

    public static String chomp(String string) {
        if (string == null || "".equals(string)) {
            return string;
        }
        char c = string.charAt(string.length() - 1);
        if (c == '\r') {
            return string.substring(0, string.length() - 1);
        }
        if (c == '\n') {
            String string2 = string.substring(0, string.length() - 1);
            if ("".equals(string2)) {
                return string2;
            }
            c = string2.charAt(string2.length() - 1);
            if (c == '\r') {
                return string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        return string;
    }

    public static HashMap parseStringOptions(String string) {
        HashMap hashMap = new HashMap();
        if (string == null || string.length() == 0) {
            return hashMap;
        }
        while (string != null && string.length() > 0) {
            int n;
            String string2;
            int n2 = string.indexOf(45);
            int n3 = string.indexOf(32, n2);
            String string3 = string.substring(n2 + 1, n3);
            n2 = string.indexOf(45, n3 + 1);
            if (n2 == -1) {
                string2 = string.substring(n3 + 1).trim();
                if (string3.length() > 0 && string2.length() > 0) {
                    hashMap.put(string3, string2);
                }
                return hashMap;
            }
            string2 = string.substring(n3, n2).trim();
            if (string3.length() > 0 && string2.length() > 0) {
                hashMap.put(string3, string2);
            }
            if ((n = string3.length() + string2.length() + 2) > string.length()) {
                string = null;
                continue;
            }
            string = string.substring(n, string.length()).trim();
        }
        return hashMap;
    }

    public static HashMap parseStringProperties(String string) {
        HashMap hashMap = new HashMap();
        if (string == null || string.length() == 0) {
            return hashMap;
        }
        while (string != null && string.length() > 0) {
            int n;
            int n2 = string.indexOf(61);
            String string2 = string.substring(0, n2);
            int n3 = string.indexOf(61, n2 + 1);
            if (n3 == -1) {
                String string3 = string.substring(n2 + 1, string.length());
                if (string2.length() > 0 && string3.length() > 0) {
                    hashMap.put(string2, string3);
                }
                return hashMap;
            }
            int n4 = string.lastIndexOf(32, n3 - 1);
            if (n4 == -1) {
                n4 = string.lastIndexOf(32, string.length());
            }
            if (n4 == -1) {
                n4 = string.length();
            }
            String string4 = string.substring(n2 + 1, n4);
            if (string2.length() > 0 && string4.length() > 0) {
                hashMap.put(string2, string4);
            }
            if ((n = string2.length() + string4.length() + 2) > string.length()) {
                string = null;
                continue;
            }
            string = string.substring(n, string.length());
        }
        return hashMap;
    }

    public static void printStream(InputStream inputStream) {
        if (inputStream == null && Log.isDebug()) {
            Log.debug("No input stream set.", 4);
            return;
        }
        byte[] byArray = new byte[8192];
        try {
            while (inputStream.available() > 0) {
                int n = inputStream.read(byArray);
                for (int i = 0; i < n; ++i) {
                    System.out.print((char)byArray[i]);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String arrayToStringInt(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public static String arrayToStringByte(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public static String arrayToStringLong(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(lArray[i]);
            if (i >= lArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public static long getHTTPDateAsLong(String string) {
        int n;
        boolean bl = string.indexOf(44) > 0;
        String string2 = null;
        if (bl) {
            string2 = string.substring(0, 3);
            string = string.substring(5, string.length());
        }
        String[] stringArray = StringUtil.split(string, ' ');
        String[] stringArray2 = StringUtil.split(stringArray[3], ':');
        int n2 = Integer.valueOf(stringArray[0]);
        String string3 = stringArray[1];
        int n3 = 0;
        for (n = 0; n < month.length; ++n) {
            if (!month[n].equals(string3)) continue;
            n3 = n;
            break;
        }
        n = Integer.valueOf(stringArray[2]);
        int n4 = Integer.valueOf(stringArray2[0]);
        int n5 = Integer.valueOf(stringArray2[1]);
        int n6 = 0;
        if (stringArray2.length > 2) {
            n6 = Integer.valueOf(stringArray2[2]);
        }
        String string4 = stringArray[4];
        TimeZone timeZone = TimeZone.getTimeZone(string4);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(5, n2);
        calendar.set(2, n3);
        calendar.set(1, n);
        calendar.set(12, n5);
        calendar.set(11, n4);
        calendar.set(13, n6);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static String getHTTPDate(long l) {
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        TimeZone timeZone = calendar.getTimeZone();
        int n = timeZone.getRawOffset() / 1000 / 3600;
        int n2 = timeZone.getRawOffset() / 1000 / 60 % 60;
        String string = StringUtil.getInt(n);
        String string2 = StringUtil.getInt(n2);
        String string3 = string + string2;
        int n3 = calendar.get(7);
        int n4 = calendar.get(5);
        String string4 = month[calendar.get(2)];
        int n5 = calendar.get(1);
        int n6 = calendar.get(11);
        int n7 = calendar.get(12);
        int n8 = calendar.get(13);
        String string5 = day[n3 - 1] + ", " + n4 + " " + string4 + " " + n5 + " " + StringUtil.getInt(n6) + ":" + StringUtil.getInt(n7) + ":" + StringUtil.getInt(n8) + " GMT+" + string3;
        return string5;
    }

    private static String getInt(int n) {
        String string = "";
        string = n < 10 ? "0" + String.valueOf(n) : String.valueOf(n);
        return string;
    }
}

