/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.io.xml.XmlPullParserSupport;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.types.CustomAttributeParser;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.wsdl.IOType;
import org.ws4d.java.wsdl.UnsupportedBindingException;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLBinding;
import org.ws4d.java.wsdl.WSDLBindingBuilder;
import org.ws4d.java.wsdl.WSDLMessage;
import org.ws4d.java.wsdl.WSDLMessagePart;
import org.ws4d.java.wsdl.WSDLOperation;
import org.ws4d.java.wsdl.WSDLParser;
import org.ws4d.java.wsdl.WSDLPort;
import org.ws4d.java.wsdl.WSDLPortType;
import org.ws4d.java.wsdl.WSDLRepository;
import org.ws4d.java.wsdl.WSDLService;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultWSDLParser
implements WSDLParser {
    private static final int INPUT = 1;
    private static final int OUTPUT = 2;
    private static final int FAULT = 3;

    private static String getNameAttribute(ElementParser elementParser) {
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = elementParser.getAttributeNamespace(i);
            String string2 = elementParser.getAttributeName(i);
            if (!"".equals(string) || !"name".equals(string2)) continue;
            return elementParser.getAttributeValue(i);
        }
        return null;
    }

    public WSDL parse(InputStream inputStream, URI uRI, String string, boolean bl) throws XmlPullParserException, IOException {
        return this.parse0(new WSDL(), inputStream, uRI, string, bl);
    }

    public WSDL parse(XmlPullParser xmlPullParser, URI uRI, String string, boolean bl) throws XmlPullParserException, IOException {
        return this.parse0(new WSDL(), xmlPullParser, uRI, string, bl);
    }

    public WSDLMessage parseMessage(ElementParser elementParser, String string) throws XmlPullParserException, IOException {
        String string2;
        WSDLMessage wSDLMessage = new WSDLMessage();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string2 = elementParser.getAttributeNamespace(i);
            String string3 = elementParser.getAttributeName(i);
            if (!"".equals(string2) || !"name".equals(string3)) continue;
            wSDLMessage.setName(new QName(elementParser.getAttributeValue(i), string));
        }
        while (elementParser.nextTag() != 3) {
            String string4 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string4)) continue;
            if ("part".equals(string2)) {
                wSDLMessage.addPart(this.parseMessagePart(elementParser));
                continue;
            }
            if (!"documentation".equals(string2)) continue;
            new ElementParser(elementParser).consume();
        }
        return wSDLMessage;
    }

    public WSDLMessagePart parseMessagePart(ElementParser elementParser) throws XmlPullParserException, IOException {
        WSDLMessagePart wSDLMessagePart = new WSDLMessagePart();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = elementParser.getAttributeNamespace(i);
            String string2 = elementParser.getAttributeName(i);
            if (!"".equals(string)) continue;
            if ("name".equals(string2)) {
                wSDLMessagePart.setName(elementParser.getAttributeValue(i));
                continue;
            }
            if ("element".equals(string2)) {
                wSDLMessagePart.setElementName(elementParser.getAttributeValueAsQName(i));
                continue;
            }
            if (!"type".equals(string2)) continue;
            wSDLMessagePart.setTypeName(elementParser.getAttributeValueAsQName(i));
        }
        elementParser.nextTag();
        return wSDLMessagePart;
    }

    public WSDLPortType parsePortType(ElementParser elementParser, String string) throws XmlPullParserException, IOException {
        String string2;
        WSDLPortType wSDLPortType = new WSDLPortType();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            CustomAttributeParser customAttributeParser;
            string2 = elementParser.getAttributeNamespace(i);
            String string3 = elementParser.getAttributeName(i);
            String string4 = elementParser.getAttributeValue(i);
            if ("".equals(string2)) {
                if ("name".equals(string3)) {
                    wSDLPortType.setName(new QName(string4, string));
                    continue;
                }
                customAttributeParser = WSDL.getAttributeParserForNamespace(string2);
                wSDLPortType.setAttribute(new QName(string3, string2), customAttributeParser.parse(elementParser, i));
                continue;
            }
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string2)) {
                if ("EventSource".equals(string3)) {
                    wSDLPortType.setEventSource(StringUtil.equalsIgnoreCase("true", string4));
                    continue;
                }
                customAttributeParser = WSDL.getAttributeParserForNamespace(string2);
                wSDLPortType.setAttribute(new QName(string3, string2), customAttributeParser.parse(elementParser, i));
                continue;
            }
            customAttributeParser = WSDL.getAttributeParserForNamespace(string2);
            wSDLPortType.setAttribute(new QName(string3, string2), customAttributeParser.parse(elementParser, i));
        }
        while (elementParser.nextTag() != 3) {
            String string5 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string5)) continue;
            if ("operation".equals(string2)) {
                wSDLPortType.addOperation(this.parseOperation(elementParser));
                continue;
            }
            if (!"documentation".equals(string2)) continue;
            new ElementParser(elementParser).consume();
        }
        return wSDLPortType;
    }

    public WSDLOperation parseOperation(ElementParser elementParser) throws XmlPullParserException, IOException {
        String string;
        WSDLOperation wSDLOperation = new WSDLOperation();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            CustomAttributeParser customAttributeParser;
            string = elementParser.getAttributeNamespace(i);
            String string2 = elementParser.getAttributeName(i);
            String string3 = elementParser.getAttributeValue(i);
            if ("".equals(string)) {
                if ("name".equals(string2)) {
                    wSDLOperation.setName(string3);
                    continue;
                }
                customAttributeParser = WSDL.getAttributeParserForNamespace(string);
                wSDLOperation.setAttribute(new QName(string2, string), customAttributeParser.parse(elementParser, i));
                continue;
            }
            customAttributeParser = WSDL.getAttributeParserForNamespace(string);
            wSDLOperation.setAttribute(new QName(string2, string), customAttributeParser.parse(elementParser, i));
        }
        while (elementParser.nextTag() != 3) {
            String string4 = elementParser.getNamespace();
            string = elementParser.getName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string4)) continue;
            if ("input".equals(string)) {
                wSDLOperation.setInput(this.parseIOType(elementParser));
                continue;
            }
            if ("output".equals(string)) {
                wSDLOperation.setOutput(this.parseIOType(elementParser));
                continue;
            }
            if ("fault".equals(string)) {
                wSDLOperation.addFault(this.parseIOType(elementParser));
                continue;
            }
            if (!"documentation".equals(string)) continue;
            new ElementParser(elementParser).consume();
        }
        return wSDLOperation;
    }

    public IOType parseIOType(ElementParser elementParser) throws XmlPullParserException, IOException {
        String string;
        IOType iOType = new IOType();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            CustomAttributeParser customAttributeParser;
            string = elementParser.getAttributeNamespace(i);
            String string2 = elementParser.getAttributeName(i);
            String string3 = elementParser.getAttributeValue(i);
            if ("".equals(string)) {
                if ("name".equals(string2)) {
                    iOType.setName(string3);
                    continue;
                }
                if ("message".equals(string2)) {
                    iOType.setMessage(elementParser.getAttributeValueAsQName(i));
                    continue;
                }
                customAttributeParser = WSDL.getAttributeParserForNamespace(string);
                iOType.setAttribute(new QName(string2, string), customAttributeParser.parse(elementParser, i));
                continue;
            }
            if ("http://www.w3.org/2005/08/addressing".equals(string) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string)) {
                if ("Action".equals(string2)) {
                    iOType.setAction(string3);
                    continue;
                }
                customAttributeParser = WSDL.getAttributeParserForNamespace(string);
                iOType.setAttribute(new QName(string2, string), customAttributeParser.parse(elementParser, i));
                continue;
            }
            customAttributeParser = WSDL.getAttributeParserForNamespace(string);
            iOType.setAttribute(new QName(string2, string), customAttributeParser.parse(elementParser, i));
        }
        while (elementParser.nextTag() != 3) {
            String string4 = elementParser.getNamespace();
            string = elementParser.getName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string4) || !"documentation".equals(string)) continue;
            new ElementParser(elementParser).consume();
        }
        return iOType;
    }

    public WSDLBinding parseBinding(ElementParser elementParser, String string) throws XmlPullParserException, IOException, UnsupportedBindingException {
        Object object;
        String string2;
        QName qName = null;
        QName qName2 = null;
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string2 = elementParser.getAttributeNamespace(i);
            object = elementParser.getAttributeName(i);
            if (!"".equals(string2)) continue;
            if ("name".equals(object)) {
                qName = new QName(elementParser.getAttributeValue(i), string);
                continue;
            }
            if (!"type".equals(object)) continue;
            qName2 = elementParser.getAttributeValueAsQName(i);
        }
        elementParser.nextTag();
        String string3 = elementParser.getNamespace();
        string2 = elementParser.getName();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(string3) && "documentation".equals(string2)) {
            new ElementParser(elementParser).consume();
            elementParser.nextTag();
            string3 = elementParser.getNamespace();
        }
        if ((object = WSDLBinding.getBuilder(string3)) == null) {
            throw new UnsupportedBindingException(string3);
        }
        ElementParser elementParser2 = new ElementParser(elementParser);
        object.parseBindingExtension(qName, qName2, elementParser2);
        elementParser2.consume();
        while (elementParser.nextTag() != 3) {
            string3 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string3) || !"operation".equals(string2)) continue;
            String string4 = DefaultWSDLParser.getNameAttribute(elementParser);
            this.parseBindingOperation(string4, (WSDLBindingBuilder)object, elementParser);
        }
        return object.getBinding();
    }

    public void parseBindingOperation(String string, WSDLBindingBuilder wSDLBindingBuilder, ElementParser elementParser) throws XmlPullParserException, IOException, UnsupportedBindingException {
        Object object;
        int n = elementParser.nextTag();
        String string2 = elementParser.getNamespace();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(string2) && "documentation".equals(elementParser.getName())) {
            new ElementParser(elementParser).consume();
            elementParser.nextTag();
            string2 = elementParser.getNamespace();
        }
        if (string2.equals(wSDLBindingBuilder.getNamespace())) {
            object = new ElementParser(elementParser);
            wSDLBindingBuilder.parseOperationExtension(string, (ElementParser)object);
            ((ElementParser)object).consume();
            n = elementParser.nextTag();
        }
        while (n != 3) {
            string2 = elementParser.getNamespace();
            object = elementParser.getName();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(string2)) {
                String string3;
                if ("input".equals(object)) {
                    string3 = DefaultWSDLParser.getNameAttribute(elementParser);
                    this.parseBindingIOType(string3, wSDLBindingBuilder, elementParser, 1);
                } else if ("output".equals(object)) {
                    string3 = DefaultWSDLParser.getNameAttribute(elementParser);
                    this.parseBindingIOType(string3, wSDLBindingBuilder, elementParser, 2);
                } else if ("fault".equals(object)) {
                    string3 = DefaultWSDLParser.getNameAttribute(elementParser);
                    this.parseBindingIOType(string3, wSDLBindingBuilder, elementParser, 3);
                }
            }
            n = elementParser.nextTag();
        }
    }

    public void parseBindingIOType(String string, WSDLBindingBuilder wSDLBindingBuilder, ElementParser elementParser, int n) throws XmlPullParserException, IOException, UnsupportedBindingException {
        elementParser.nextTag();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(elementParser.getNamespace()) && "documentation".equals(elementParser.getName())) {
            new ElementParser(elementParser).consume();
            elementParser.nextTag();
        }
        ElementParser elementParser2 = new ElementParser(elementParser);
        switch (n) {
            case 1: {
                wSDLBindingBuilder.parseInputExtension(string, elementParser2);
                break;
            }
            case 2: {
                wSDLBindingBuilder.parseOutputExtension(string, elementParser2);
                break;
            }
            case 3: {
                wSDLBindingBuilder.parseFaultExtension(string, elementParser2);
            }
        }
        elementParser2.consume();
        elementParser.nextTag();
    }

    public WSDLService parseService(ElementParser elementParser, String string) throws XmlPullParserException, IOException, UnsupportedBindingException {
        String string2;
        WSDLService wSDLService = new WSDLService();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string2 = elementParser.getAttributeNamespace(i);
            String string3 = elementParser.getAttributeName(i);
            if (!"".equals(string2) || !"name".equals(string3)) continue;
            wSDLService.setName(new QName(elementParser.getAttributeValue(i), string));
        }
        while (elementParser.nextTag() != 3) {
            String string4 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string4)) continue;
            if ("port".equals(string2)) {
                wSDLService.addPort(this.parsePort(elementParser));
                continue;
            }
            if (!"documentation".equals(string2)) continue;
            new ElementParser(elementParser).consume();
        }
        return wSDLService;
    }

    public WSDLPort parsePort(ElementParser elementParser) throws XmlPullParserException, IOException, UnsupportedBindingException {
        Object object;
        String string;
        String string2 = null;
        QName qName = null;
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string = elementParser.getAttributeNamespace(i);
            object = elementParser.getAttributeName(i);
            if (!"".equals(string)) continue;
            if ("name".equals(object)) {
                string2 = elementParser.getAttributeValue(i);
                continue;
            }
            if (!"binding".equals(object)) continue;
            qName = elementParser.getAttributeValueAsQName(i);
        }
        elementParser.nextTag();
        String string3 = elementParser.getNamespace();
        string = elementParser.getName();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(string3) && "documentation".equals(string)) {
            new ElementParser(elementParser).consume();
            elementParser.nextTag();
            string3 = elementParser.getNamespace();
        }
        if ((object = WSDLBinding.getBuilder(string3)) == null) {
            throw new UnsupportedBindingException(string3);
        }
        ElementParser elementParser2 = new ElementParser(elementParser);
        WSDLPort wSDLPort = object.parsePortExtension(string2, qName, elementParser2);
        elementParser2.consume();
        elementParser.nextTag();
        return wSDLPort;
    }

    private WSDL parse0(WSDL wSDL, InputStream inputStream, URI uRI, String string, boolean bl) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = XmlPullParserSupport.getFactory().newPullParser();
        xmlPullParser.setInput(inputStream, null);
        xmlPullParser.nextTag();
        return this.parse0(wSDL, xmlPullParser, uRI, string, bl);
    }

    private WSDL parse0(WSDL wSDL, XmlPullParser xmlPullParser, URI uRI, String string, boolean bl) throws XmlPullParserException, IOException {
        wSDL.storeDefaultNamespaces(xmlPullParser);
        String string2 = xmlPullParser.getNamespace();
        String string3 = xmlPullParser.getName();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(string2)) {
            if ("definitions".equals(string3)) {
                int n = xmlPullParser.getAttributeCount();
                for (int i = 0; i < n; ++i) {
                    String string4 = xmlPullParser.getAttributeNamespace(i);
                    String string5 = xmlPullParser.getAttributeName(i);
                    if ("".equals(string4)) {
                        string4 = xmlPullParser.getNamespace();
                    }
                    if (!"http://schemas.xmlsoap.org/wsdl/".equals(string4)) continue;
                    if ("name".equals(string5)) {
                        if (string != null) continue;
                        wSDL.setName(xmlPullParser.getAttributeValue(i));
                        continue;
                    }
                    if (!"targetNamespace".equals(string5)) continue;
                    String string6 = xmlPullParser.getAttributeValue(i);
                    if (string == null) {
                        string = string6;
                        wSDL.setTargetNamespace(string);
                        continue;
                    }
                    if (string.equals(string6)) continue;
                    throw new XmlPullParserException("declared namespace " + string6 + " doesn't match expected namespace " + string);
                }
                this.handleDefinitions(wSDL, new ElementParser(xmlPullParser), uRI, string, bl);
            }
        } else if ("http://www.w3.org/2001/XMLSchema".equals(string2) && "schema".equals(string3)) {
            this.handleSchema(wSDL, new ElementParser(xmlPullParser), uRI, bl);
        }
        return wSDL;
    }

    private void handleDefinitions(WSDL wSDL, ElementParser elementParser, URI uRI, String string, boolean bl) throws XmlPullParserException, IOException {
        while (elementParser.nextTag() != 3) {
            String string2 = elementParser.getNamespace();
            String string3 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(string2)) {
                ElementParser elementParser2;
                if ("import".equals(string3)) {
                    this.handleImport(wSDL, elementParser, uRI, bl);
                    continue;
                }
                if ("types".equals(string3)) {
                    this.handleTypes(wSDL, elementParser, uRI, bl);
                    continue;
                }
                if ("message".equals(string3)) {
                    wSDL.addMessage(this.parseMessage(elementParser, string));
                    continue;
                }
                if ("portType".equals(string3)) {
                    wSDL.addPortType(this.parsePortType(elementParser, string));
                    continue;
                }
                if ("binding".equals(string3)) {
                    elementParser2 = new ElementParser(elementParser);
                    try {
                        wSDL.addBinding(this.parseBinding(elementParser2, string));
                    }
                    catch (UnsupportedBindingException unsupportedBindingException) {
                        Log.warn("Found unsupported binding within WSDL " + uRI + ": " + unsupportedBindingException.getMessage());
                        if (Log.isDebug()) {
                            Log.printStackTrace(unsupportedBindingException);
                        }
                        elementParser2.consume();
                    }
                    continue;
                }
                if ("service".equals(string3)) {
                    elementParser2 = new ElementParser(elementParser);
                    try {
                        wSDL.addService(this.parseService(elementParser2, string));
                    }
                    catch (UnsupportedBindingException unsupportedBindingException) {
                        Log.warn("Found unsupported service within WSDL " + uRI + ": " + unsupportedBindingException.getMessage());
                        if (Log.isDebug()) {
                            Log.printStackTrace(unsupportedBindingException);
                        }
                        elementParser2.consume();
                    }
                    continue;
                }
                if (!"documentation".equals(string3)) continue;
                new ElementParser(elementParser).consume();
                continue;
            }
            if ("http://www.w3.org/ns/ws-policy".equals(string2) || "http://schemas.xmlsoap.org/ws/2004/09/policy".equals(string2)) {
                if (!"Policy".equals(string3)) continue;
                this.handlePolicyTags(elementParser, wSDL);
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
                new ElementParser(elementParser).consume();
                continue;
            }
            this.handleUnkownTags(elementParser);
        }
    }

    protected void handlePolicyTags(ElementParser elementParser, Object object) throws XmlPullParserException, IOException {
        this.handleUnkownTags(elementParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImport(WSDL wSDL, ElementParser elementParser, URI uRI, boolean bl) throws XmlPullParserException, IOException {
        Object object;
        Object object2;
        int n;
        String string = null;
        String string2 = null;
        int n2 = elementParser.getAttributeCount();
        for (n = 0; n < n2; ++n) {
            object2 = elementParser.getAttributeNamespace(n);
            object = elementParser.getAttributeName(n);
            if (!"".equals(object2)) continue;
            if ("namespace".equals(object)) {
                string2 = elementParser.getAttributeValue(n);
                continue;
            }
            if (!"location".equals(object)) continue;
            string = elementParser.getAttributeValue(n);
        }
        wSDL.addImport(string2, string);
        if (bl) {
            if (uRI == null) {
                WSDL wSDL2 = WSDLRepository.getInstance().getWSDL(string);
                if (wSDL2 != null) {
                    wSDL.addLinkedWsdl(wSDL2);
                }
            } else {
                URI uRI2 = URI.absolutize(uRI, string);
                object2 = DPWSFramework.getResourceAsStream(uRI2);
                object = ((ResourceLoader)object2).getInputStream();
                try {
                    if (wSDL.getTargetNamespace().equals(string2)) {
                        this.parse0(wSDL, (InputStream)object, uRI2, string2, true);
                    } else {
                        WSDL wSDL3 = this.parse((InputStream)object, uRI2, null, true);
                        if (wSDL3 != null) {
                            wSDL.addLinkedWsdl(wSDL3);
                        }
                    }
                }
                finally {
                    ((InputStream)object).close();
                }
            }
        }
        n = elementParser.getDepth();
        while (elementParser.next() != 3 || elementParser.getDepth() > n) {
        }
    }

    private void handleTypes(WSDL wSDL, ElementParser elementParser, URI uRI, boolean bl) throws XmlPullParserException, IOException {
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
                if (!"schema".equals(string2)) continue;
                this.handleSchema(wSDL, new ElementParser(elementParser), uRI, bl);
                continue;
            }
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string) || !"documentation".equals(string2)) continue;
            new ElementParser(elementParser).consume();
        }
    }

    private void handleSchema(WSDL wSDL, ElementParser elementParser, URI uRI, boolean bl) throws XmlPullParserException, IOException {
        try {
            String string = elementParser.getAttributeValue(null, "targetNamespace");
            if (string == null) {
                string = wSDL.getTargetNamespace();
            }
            Schema schema = Schema.parse(elementParser, uRI, string, bl);
            wSDL.addTypes(schema);
        }
        catch (SchemaException schemaException) {
            Log.error(schemaException.getMessage());
            Log.printStackTrace(schemaException);
            throw new XmlPullParserException("Unable to parse schema import", elementParser, schemaException);
        }
    }

    private void handleUnkownTags(ElementParser elementParser) throws XmlPullParserException, IOException {
        int n = elementParser.getDepth();
        int n2 = elementParser.getEventType();
        while (n2 != 3 && n2 != 1 && elementParser.getDepth() >= n) {
            n2 = elementParser.nextTag();
            this.handleUnkownTags(elementParser);
        }
    }
}

