/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.io.xml.XmlPullParserSupport;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.wsdl.IOType;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLBinding;
import org.ws4d.java.wsdl.WSDLMessage;
import org.ws4d.java.wsdl.WSDLMessagePart;
import org.ws4d.java.wsdl.WSDLOperation;
import org.ws4d.java.wsdl.WSDLPort;
import org.ws4d.java.wsdl.WSDLPortType;
import org.ws4d.java.wsdl.WSDLSerializer;
import org.ws4d.java.wsdl.WSDLService;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DefaultWSDLSerializer
implements WSDLSerializer {
    private static void serializeInput(WSDLBinding wSDLBinding, WSDLOperation wSDLOperation, XmlSerializer xmlSerializer) throws IOException {
        IOType iOType = wSDLOperation.getInput();
        if (iOType != null) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "input");
            wSDLBinding.serializeInputExtension(iOType, xmlSerializer);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "input");
        }
    }

    private static void serializeOutput(WSDLBinding wSDLBinding, WSDLOperation wSDLOperation, XmlSerializer xmlSerializer) throws IOException {
        IOType iOType = wSDLOperation.getOutput();
        if (iOType != null) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "output");
            wSDLBinding.serializeOutputExtension(iOType, xmlSerializer);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "output");
        }
    }

    public void serialize(WSDL wSDL, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        XmlSerializer xmlSerializer;
        try {
            xmlSerializer = XmlPullParserSupport.getFactory().newSerializer();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new IOException(xmlPullParserException.getMessage());
        }
        xmlSerializer.setOutput(outputStream, "UTF-8");
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.comment("This is an auto-generated WSDL from JMEDS.\r\nCopyright (c) 2009 MATERNA Information & Communications and TU Dortmund, Dpt. of Computer Science, Chair 4, Distributed Systems.\r\nAll rights reserved.\r\nJMEDS and the accompanying materials are made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html");
        String string = wSDL.getTargetNamespace();
        HashMap hashMap = wSDL.getDefaultNamespaces();
        if (!"".equals(string) && !hashMap.containsValue("tns")) {
            xmlSerializer.setPrefix("tns", string);
        }
        Object object4 = hashMap.entrySet().iterator();
        while (object4.hasNext()) {
            object3 = (HashMap.Entry)object4.next();
            xmlSerializer.setPrefix((String)((HashMap.Entry)object3).getValue(), (String)((HashMap.Entry)object3).getKey());
        }
        object4 = wSDL.getBindings();
        while (object4.hasNext()) {
            object3 = (WSDLBinding)object4.next();
            xmlSerializer.getPrefix(((WSDLBinding)object3).getBindingNamespace(), true);
        }
        object4 = wSDL.getImports();
        object3 = ((HashMap)object4).keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            xmlSerializer.getPrefix((String)object2, true);
        }
        object3 = wSDL.getTypes();
        while (object3.hasNext()) {
            object2 = (Schema)object3.next();
            xmlSerializer.getPrefix(((Schema)object2).getTargetNamespace(), true);
        }
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "definitions");
        object3 = wSDL.getName();
        if (object3 != null && !"".equals(object3)) {
            xmlSerializer.attribute(null, "name", (String)object3);
        }
        if (!"".equals(string)) {
            xmlSerializer.attribute(null, "targetNamespace", string);
        }
        object2 = ((HashMap)object4).entrySet().iterator();
        while (object2.hasNext()) {
            object = (HashMap.Entry)object2.next();
            String string2 = (String)((HashMap.Entry)object).getKey();
            String string3 = (String)((HashMap.Entry)object).getValue();
            xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "import");
            xmlSerializer.attribute(null, "namespace", string2);
            xmlSerializer.attribute(null, "location", string3);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "import");
        }
        this.serializeTypes(wSDL, xmlSerializer);
        object2 = wSDL.getMessages();
        while (object2.hasNext()) {
            object = (WSDLMessage)object2.next();
            this.serialize((WSDLMessage)object, xmlSerializer);
        }
        object2 = wSDL.getPortTypes();
        while (object2.hasNext()) {
            object = (WSDLPortType)object2.next();
            this.serialize((WSDLPortType)object, xmlSerializer);
        }
        object2 = wSDL.getBindings();
        while (object2.hasNext()) {
            object = (WSDLBinding)object2.next();
            this.serialize((WSDLBinding)object, xmlSerializer);
        }
        object2 = wSDL.getServices();
        while (object2.hasNext()) {
            object = (WSDLService)object2.next();
            this.serialize((WSDLService)object, xmlSerializer);
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "definitions");
        xmlSerializer.endDocument();
        xmlSerializer.flush();
    }

    public void serializeTypes(WSDL wSDL, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "types");
        Iterator iterator = wSDL.getTypes();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            schema.serialize(xmlSerializer);
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "types");
    }

    public void serialize(WSDLMessage wSDLMessage, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "message");
        xmlSerializer.attribute(null, "name", wSDLMessage.getLocalName());
        Iterator iterator = wSDLMessage.getParts().iterator();
        while (iterator.hasNext()) {
            WSDLMessagePart wSDLMessagePart = (WSDLMessagePart)iterator.next();
            this.serialize(wSDLMessagePart, xmlSerializer);
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "message");
    }

    public void serialize(WSDLMessagePart wSDLMessagePart, XmlSerializer xmlSerializer) throws IOException {
        QName qName;
        String string;
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "part");
        xmlSerializer.attribute(null, "name", wSDLMessagePart.getName());
        if (!wSDLMessagePart.isElement()) {
            string = "type";
            qName = wSDLMessagePart.getTypeName();
        } else {
            string = "element";
            qName = wSDLMessagePart.getElementName();
        }
        String string2 = qName.getNamespace();
        String string3 = xmlSerializer.getPrefix(string2, false);
        String string4 = string3 == null ? qName.getLocalPart() : string3 + ":" + qName.getLocalPart();
        xmlSerializer.attribute(null, string, string4);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "part");
    }

    public void serialize(WSDLPortType wSDLPortType, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "portType");
        xmlSerializer.attribute(null, "name", wSDLPortType.getLocalName());
        if (wSDLPortType.isEventSource()) {
            xmlSerializer.attribute("http://schemas.xmlsoap.org/ws/2004/08/eventing", "EventSource", "true");
        }
        wSDLPortType.serializeAttributes(xmlSerializer);
        Iterator iterator = wSDLPortType.getOperations().iterator();
        while (iterator.hasNext()) {
            WSDLOperation wSDLOperation = (WSDLOperation)iterator.next();
            this.serialize(wSDLOperation, xmlSerializer);
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "portType");
    }

    public void serialize(WSDLOperation wSDLOperation, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "operation");
        xmlSerializer.attribute(null, "name", wSDLOperation.getName());
        wSDLOperation.serializeAttributes(xmlSerializer);
        switch (wSDLOperation.getType()) {
            case 1: {
                this.serializeIO(wSDLOperation.getInput(), xmlSerializer, "input");
                break;
            }
            case -1: 
            case 2: {
                this.serializeIO(wSDLOperation.getInput(), xmlSerializer, "input");
                this.serializeIO(wSDLOperation.getOutput(), xmlSerializer, "output");
                break;
            }
            case 3: {
                this.serializeIO(wSDLOperation.getOutput(), xmlSerializer, "output");
                this.serializeIO(wSDLOperation.getInput(), xmlSerializer, "input");
                break;
            }
            case 4: {
                this.serializeIO(wSDLOperation.getOutput(), xmlSerializer, "output");
            }
        }
        if (wSDLOperation.isBidirectional()) {
            Iterator iterator = wSDLOperation.getFaults().iterator();
            while (iterator.hasNext()) {
                IOType iOType = (IOType)iterator.next();
                this.serializeIO(iOType, xmlSerializer, "fault");
            }
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "operation");
    }

    public void serialize(IOType iOType, XmlSerializer xmlSerializer) throws IOException {
        String string = iOType.getName();
        if (string != null && iOType.isNameSet()) {
            xmlSerializer.attribute(null, "name", string);
        }
        iOType.serializeAttributes(xmlSerializer);
        QName qName = iOType.getMessageName();
        String string2 = qName.getNamespace();
        String string3 = xmlSerializer.getPrefix(string2, false);
        String string4 = string3 == null ? qName.getLocalPart() : string3 + ":" + qName.getLocalPart();
        xmlSerializer.attribute(null, "message", string4);
        String string5 = iOType.getAction();
        xmlSerializer.attribute("http://www.w3.org/2005/08/addressing", "Action", string5);
    }

    public void serialize(WSDLBinding wSDLBinding, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "binding");
        xmlSerializer.attribute(null, "name", wSDLBinding.getLocalName());
        QName qName = wSDLBinding.getTypeName();
        String string = qName.getNamespace();
        String string2 = xmlSerializer.getPrefix(string, false);
        String string3 = string2 == null ? qName.getLocalPart() : string2 + ":" + qName.getLocalPart();
        xmlSerializer.attribute(null, "type", string3);
        wSDLBinding.serializeBindingExtension(xmlSerializer);
        DataStructure dataStructure = wSDLBinding.getOperations();
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            WSDLOperation wSDLOperation = (WSDLOperation)iterator.next();
            xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "operation");
            xmlSerializer.attribute(null, "name", wSDLOperation.getName());
            wSDLBinding.serializeOperationExtension(wSDLOperation, xmlSerializer);
            switch (wSDLOperation.getType()) {
                case 1: {
                    DefaultWSDLSerializer.serializeInput(wSDLBinding, wSDLOperation, xmlSerializer);
                    break;
                }
                case -1: 
                case 2: 
                case 3: {
                    DefaultWSDLSerializer.serializeInput(wSDLBinding, wSDLOperation, xmlSerializer);
                    DefaultWSDLSerializer.serializeOutput(wSDLBinding, wSDLOperation, xmlSerializer);
                    break;
                }
                case 4: {
                    DefaultWSDLSerializer.serializeOutput(wSDLBinding, wSDLOperation, xmlSerializer);
                }
            }
            Iterator iterator2 = wSDLOperation.getFaults().iterator();
            while (iterator2.hasNext()) {
                IOType iOType = (IOType)iterator2.next();
                xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "fault");
                String string4 = iOType.getName();
                if (string4 != null) {
                    xmlSerializer.attribute(null, "name", string4);
                }
                wSDLBinding.serializeFaultExtension(iOType, xmlSerializer);
                xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "fault");
            }
            xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "operation");
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "binding");
    }

    public void serialize(WSDLService wSDLService, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "service");
        xmlSerializer.attribute(null, "name", wSDLService.getLocalName());
        Iterator iterator = wSDLService.getPorts().iterator();
        while (iterator.hasNext()) {
            WSDLPort wSDLPort = (WSDLPort)iterator.next();
            this.serialize(wSDLPort, xmlSerializer);
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "service");
    }

    public void serialize(WSDLPort wSDLPort, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", "port");
        xmlSerializer.attribute(null, "name", wSDLPort.getName());
        QName qName = wSDLPort.getBindingName();
        String string = qName.getNamespace();
        String string2 = xmlSerializer.getPrefix(string, false);
        String string3 = string2 == null ? qName.getLocalPart() : string2 + ":" + qName.getLocalPart();
        xmlSerializer.attribute(null, "binding", string3);
        wSDLPort.serializePortExtension(xmlSerializer);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", "port");
    }

    private void serializeIO(IOType iOType, XmlSerializer xmlSerializer, String string) throws IOException {
        if (iOType != null) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/wsdl/", string);
            this.serialize(iOType, xmlSerializer);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/wsdl/", string);
        }
    }
}

