package com.ebmwebsourcing.seacloud.pubsub;

import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.seacloud.model.AbstractModule;
import com.ebmwebsourcing.seacloud.model.PubSubModule;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;


public class EventCloudPubSubModuleMocked extends AbstractModule implements PubSubModule {

    private static final Logger LOG = Logger.getLogger(EventCloudPubSubModuleMocked.class.getName());

    private String eventCloudsManagementWsEndpoint;
    private Set<QName> topics;

    public EventCloudPubSubModuleMocked(List<URL> adminAddresses) throws CloudManagementException {
        super(adminAddresses);

        if (super.externalComponentAdresses.size() > 0) {
            this.eventCloudsManagementWsEndpoint = super.externalComponentAdresses.get(0).toString();
        } else {
            throw new CloudManagementException(
                "Cannot start the EventCloudPubSubModuleMocked because no Event Clouds management web service endpoint has been given");
        }
    }

    @Override
    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
            throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault,
            UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault,
            InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault,
            UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault,
            InvalidProducerPropertiesExpressionFault {

        UserManagementClientSOAP client = new UserManagementClientSOAP(eventCloudsManagementWsEndpoint);

        return client.subscribe(subscribeRequest);
    }

    @Override
    public void notify(EJaxbNotify notify) {
        UserManagementClientSOAP client = new UserManagementClientSOAP(eventCloudsManagementWsEndpoint);
        System.out.println("Send notify to eventCloud: " + eventCloudsManagementWsEndpoint);
        client.notify(notify);
    }

    @Override
    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest)
            throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        // TODO: send unsubscribe on event cloud (optional)
        return null;
    }

    @Override
    public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest)
            throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        // TODO: send getResourceProperty on event cloud (optional)
        return null;
    }

}
