//SOCEDA integration
//----------
//-- Main --
//----------
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

//Load files
load("src/util.js");
load("src/ws.js"); 
load("src/sccli.js"); // SeaCloud CLI

{
	println("--------------------------------------------");
	println("--   Welcome to Crisis Management UseCase : " + findPropertyInInstaller("installer.version") + "  --");
	println("--         http://www.soceda.org          --");
	println("--------------------------------------------");

	// Check current dir
	checkCurrentLocation();

	// Install SeaCloud CLI
	installSCCLI();

	// Start all web services
	var waiterThread = startAllWSs();

	println("Please wait until all Web Services are started ...");


	readStdin("Once ready press 'Enter' to deploy all resources of usecase (xsd, topns, bpels, ela) ...");
	deployAllResources();	
	
	println("Wait that EasierGov detect 6 eventProducers. Tape \"i\" on EasierGOV shell to see that.");
	readStdin("Once ready press 'Enter' to deploy CEP Rule of usecase ...");
	deployCEPRule();	

	readStdin("Once ready press 'Enter' to run all EDA applications ...");
	runAllEDApplications();

	// The main will terminate when the waiter thread terminates
	waiterThread.join();
}


function startAllWSs() {
	// Start WS Buisiness Providers
	var wsProcesses = runWS();
	println("WebService Providers started ...");


	// Add hook that terminates all if the current process is killed 
	var cleaner = java.lang.Thread(function () {

		println("Terminating WebService Providers ...");		
		for (x in wsProcesses) {
			var proc = wsProcesses[x];
			if (proc != null) {  
				proc.destroy();
			}
		}	
	});
	java.lang.Runtime.getRuntime().addShutdownHook(cleaner);

	// Add async waiter thread 
	var waiter = java.lang.Thread(function () {
		for (x in wsProcesses) {
			wsProcesses[x].waitFor();
		}	
	});
	waiter.start();
	return waiter;
}


function deployAllResources() {
	var scriptFile = new File(scriptsDir, "DeployAllResourcesScript.xml");
	println("SeaCloud CLI runs " + scriptFile + " ...");
	var sccliProcess = 	runDescriptor(scriptFile);		
	sccliProcess.waitFor();
}

function deployCEPRule() {
	var scriptFile = new File(scriptsDir, "DeployCEPRuleScript.xml");
	println("SeaCloud CLI runs " + scriptFile + " ...");
	var sccliProcess = 	runDescriptor(scriptFile);		
	sccliProcess.waitFor();
}

function runAllEDApplications() {
	var scriptFile = new File(scriptsDir, "RunAllEDApplicationsScript.xml");
	println("SeaCloud CLI runs " + scriptFile + " ...");
	var sccliProcess = 	runDescriptor(scriptFile);		
	sccliProcess.waitFor();
}
