package fr.mines_albi.nuclearcrisisevent.provider;

import java.util.List;
import java.util.UUID;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.petalslink.easiestdemo.wsoui.provided.notification.AbstractEventProducerNotifier;

import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import fr.mines_albi.nuclearcrisisevent.OfferEvent;
import fr.mines_albi.nuclearcrisisevent.Resources;

public class BusProviderEvent_EventProducerNotifier extends AbstractEventProducerNotifier {

	public BusProviderEvent_EventProducerNotifier(ProviderConfiguration configuration, WSOUIJaxbContextItf context) throws WSOUIException {
		super(configuration, context);
		this.getSubscriptionManager().setTopicSet(Thread.currentThread().getContextClassLoader().getResource("crisis/v3/EventTopicSet.xml"));
		this.getSubscriptionManager().setTopicNamespace(Thread.currentThread().getContextClassLoader().getResource("crisis/v3/EventTopicNS.xml"));
	}

	@Override
	public void setPeriodEvent() {
		this.setPeriodEvent(0); // Set the period to send event (in ms).
	}


	@Override
	public Object createPeriodicallyEvent() throws WSOUIException {
		AbstractJaxbModelObject event = null; // TODO: create Event.
		return event;
	}


	@Override
	public Object createEventBeforeProcessingRequest(String methodName, Object request) throws WSOUIException {
		AbstractJaxbModelObject event = null; // TODO: create Event.
		return event;
	}


	@Override
	public Object createEventBeforeSendResponse(String methodName, Object request, Object response) throws WSOUIException {
		try {
			//	return null;
			if(methodName.toLowerCase().equals("subscribe")) {
				System.out.println("maven-wsoui request: " + request);
				EJaxbSubscribe subscribe = (EJaxbSubscribe) request;
				List<QName> msgs = WSNHelper.getMessages(WSNHelper.getMessageContentInFilter(subscribe.getFilter()));
				System.out.println("maven-wsoui topic: " + msgs);
				System.out.println("maven-wsoui topic must be equals to: offerevent");
				if(!msgs.isEmpty() && msgs.get(0).getLocalPart().toLowerCase().equals("offerevent")) {
					OfferEvent event = new OfferEvent();
					event.setUid(UUID.randomUUID().toString());
					Resources value = new Resources();
					value.setQuantity(5.0);
					value.setType("truck");
					event.setProvider("bus");
					event.setResources(value);
					System.out.println("maven-wsoui methodName = " + methodName);
					System.out.println("maven-wsoui request = " + request);
					System.out.println("maven-wsoui +++++++++++++++++++++++++++++++ CREATION AND SEND OF OfferEvent EVENT");
					return event;
				}
			} else {
				return null;
			}
		} catch (WsnbException e) {
			throw new WSOUIException(e);
		}
		return null;
	}



}
