package fr.mines_albi.nuclearcrisisevent.provider;

import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;
import org.petalslink.easiestdemo.wsoui.provided.Exchange;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbGetCurrentMessage;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbGetCurrentMessageResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;

public class BusProviderEvent_ExchangeProcessor extends AbstractExchangeProcessor {

	public BusProviderEvent_ExchangeProcessor() {
		createAllExchangesFor_getCurrentMessage();
		createAllExchangesFor_subscribe();
		createAllExchangesFor_getResourceProperty();
	}


	public void createAllExchangesFor_getCurrentMessage() {
		// Add nominal business exchange
		Exchange<EJaxbGetCurrentMessage, EJaxbGetCurrentMessageResponse, ?> nominalExchange = new Exchange(new EJaxbGetCurrentMessage(), new EJaxbGetCurrentMessageResponse());
		this.addExpectedExchange("getCurrentMessage", nominalExchange);
		// Add business information on expected request: nominalExchange.getExpectedRequest().set(...)
		// TODO
		// Add business information on expected response: nominalExchange.getExpectedResponse().set(...)
		// TODO




		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault
		Exchange<EJaxbGetCurrentMessage, ?, org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault> TopicNotSupportedFaultExchange = new Exchange(new EJaxbGetCurrentMessage(), new org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault());
		this.addExpectedExchange("getCurrentMessage", TopicNotSupportedFaultExchange);
		// Add business information on expected fault: TopicNotSupportedFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault
		Exchange<EJaxbGetCurrentMessage, ?, org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault> InvalidTopicExpressionFaultExchange = new Exchange(new EJaxbGetCurrentMessage(), new org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault());
		this.addExpectedExchange("getCurrentMessage", InvalidTopicExpressionFaultExchange);
		// Add business information on expected fault: InvalidTopicExpressionFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault
		Exchange<EJaxbGetCurrentMessage, ?, org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault> ResourceUnknownFaultExchange = new Exchange(new EJaxbGetCurrentMessage(), new org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault());
		this.addExpectedExchange("getCurrentMessage", ResourceUnknownFaultExchange);
		// Add business information on expected fault: ResourceUnknownFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault
		Exchange<EJaxbGetCurrentMessage, ?, org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault> TopicExpressionDialectUnknownFaultExchange = new Exchange(new EJaxbGetCurrentMessage(), new org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault());
		this.addExpectedExchange("getCurrentMessage", TopicExpressionDialectUnknownFaultExchange);
		// Add business information on expected fault: TopicExpressionDialectUnknownFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.NoCurrentMessageOnTopicFault
		Exchange<EJaxbGetCurrentMessage, ?, org.oasis_open.docs.wsn.bw_2.NoCurrentMessageOnTopicFault> NoCurrentMessageOnTopicFaultExchange = new Exchange(new EJaxbGetCurrentMessage(), new org.oasis_open.docs.wsn.bw_2.NoCurrentMessageOnTopicFault());
		this.addExpectedExchange("getCurrentMessage", NoCurrentMessageOnTopicFaultExchange);
		// Add business information on expected fault: NoCurrentMessageOnTopicFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.MultipleTopicsSpecifiedFault
		Exchange<EJaxbGetCurrentMessage, ?, org.oasis_open.docs.wsn.bw_2.MultipleTopicsSpecifiedFault> MultipleTopicsSpecifiedFaultExchange = new Exchange(new EJaxbGetCurrentMessage(), new org.oasis_open.docs.wsn.bw_2.MultipleTopicsSpecifiedFault());
		this.addExpectedExchange("getCurrentMessage", MultipleTopicsSpecifiedFaultExchange);
		// Add business information on expected fault: MultipleTopicsSpecifiedFaultExchange.getExpectedFault().set(...)
		// TODO




		// You can add other exchanges if needed
	}


	public void createAllExchangesFor_subscribe() {
		// Add nominal business exchange
		Exchange<EJaxbSubscribe, EJaxbSubscribeResponse, ?> nominalExchange = new Exchange(new EJaxbSubscribe(), new EJaxbSubscribeResponse());
		this.addExpectedExchange("subscribe", nominalExchange);
		// Add business information on expected request: nominalExchange.getExpectedRequest().set(...)
		// TODO
		// Add business information on expected response: nominalExchange.getExpectedResponse().set(...)
		// TODO




		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault> NotifyMessageNotSupportedFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault());
		this.addExpectedExchange("subscribe", NotifyMessageNotSupportedFaultExchange);
		// Add business information on expected fault: NotifyMessageNotSupportedFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault> TopicNotSupportedFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault());
		this.addExpectedExchange("subscribe", TopicNotSupportedFaultExchange);
		// Add business information on expected fault: TopicNotSupportedFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.InvalidFilterFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.InvalidFilterFault> InvalidFilterFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.InvalidFilterFault());
		this.addExpectedExchange("subscribe", InvalidFilterFaultExchange);
		// Add business information on expected fault: InvalidFilterFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault> InvalidTopicExpressionFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault());
		this.addExpectedExchange("subscribe", InvalidTopicExpressionFaultExchange);
		// Add business information on expected fault: InvalidTopicExpressionFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault> ResourceUnknownFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault());
		this.addExpectedExchange("subscribe", ResourceUnknownFaultExchange);
		// Add business information on expected fault: ResourceUnknownFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault> TopicExpressionDialectUnknownFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault());
		this.addExpectedExchange("subscribe", TopicExpressionDialectUnknownFaultExchange);
		// Add business information on expected fault: TopicExpressionDialectUnknownFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault> UnrecognizedPolicyRequestFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault());
		this.addExpectedExchange("subscribe", UnrecognizedPolicyRequestFaultExchange);
		// Add business information on expected fault: UnrecognizedPolicyRequestFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault> SubscribeCreationFailedFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault());
		this.addExpectedExchange("subscribe", SubscribeCreationFailedFaultExchange);
		// Add business information on expected fault: SubscribeCreationFailedFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault> InvalidMessageContentExpressionFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault());
		this.addExpectedExchange("subscribe", InvalidMessageContentExpressionFaultExchange);
		// Add business information on expected fault: InvalidMessageContentExpressionFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault> UnsupportedPolicyRequestFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault());
		this.addExpectedExchange("subscribe", UnsupportedPolicyRequestFaultExchange);
		// Add business information on expected fault: UnsupportedPolicyRequestFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault> UnacceptableInitialTerminationTimeFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault());
		this.addExpectedExchange("subscribe", UnacceptableInitialTerminationTimeFaultExchange);
		// Add business information on expected fault: UnacceptableInitialTerminationTimeFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault
		Exchange<EJaxbSubscribe, ?, org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault> InvalidProducerPropertiesExpressionFaultExchange = new Exchange(new EJaxbSubscribe(), new org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault());
		this.addExpectedExchange("subscribe", InvalidProducerPropertiesExpressionFaultExchange);
		// Add business information on expected fault: InvalidProducerPropertiesExpressionFaultExchange.getExpectedFault().set(...)
		// TODO




		// You can add other exchanges if needed
	}


	public void createAllExchangesFor_getResourceProperty() {
		// Add nominal business exchange
		Exchange<javax.xml.namespace.QName, EJaxbGetResourcePropertyResponse, ?> nominalExchange = new Exchange(new javax.xml.namespace.QName(""), new EJaxbGetResourcePropertyResponse());
		this.addExpectedExchange("getResourceProperty", nominalExchange);
		// Add business information on expected request: nominalExchange.getExpectedRequest().set(...)
		// TODO
		// Add business information on expected response: nominalExchange.getExpectedResponse().set(...)
		// TODO




		// Add fault exchange for org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault
		Exchange<javax.xml.namespace.QName, ?, org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault> ResourceUnknownFaultExchange = new Exchange(new javax.xml.namespace.QName(""), new org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault());
		this.addExpectedExchange("getResourceProperty", ResourceUnknownFaultExchange);
		// Add business information on expected fault: ResourceUnknownFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault
		Exchange<javax.xml.namespace.QName, ?, org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault> InvalidResourcePropertyQNameFaultExchange = new Exchange(new javax.xml.namespace.QName(""), new org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault());
		this.addExpectedExchange("getResourceProperty", InvalidResourcePropertyQNameFaultExchange);
		// Add business information on expected fault: InvalidResourcePropertyQNameFaultExchange.getExpectedFault().set(...)
		// TODO


		// Add fault exchange for org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault
		Exchange<javax.xml.namespace.QName, ?, org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault> ResourceUnavailableFaultExchange = new Exchange(new javax.xml.namespace.QName(""), new org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault());
		this.addExpectedExchange("getResourceProperty", ResourceUnavailableFaultExchange);
		// Add business information on expected fault: ResourceUnavailableFaultExchange.getExpectedFault().set(...)
		// TODO




		// You can add other exchanges if needed
	}



}
