package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class CarProviderEvent_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_CarProviderEvent = null;
	private ProviderConfiguration confEndpointFor_CarProviderEvent = null;
	private AbstractImplementationManager<?> im = null;
	
	public CarProviderEvent_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_CarProviderEvent() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":7207/carProviderEventPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_CarProviderEvent() {
		if(this.confEndpointFor_CarProviderEvent == null) {
			this.confEndpointFor_CarProviderEvent = createDefaultProviderConfigurationFor_CarProviderEvent();
		}
		return this.confEndpointFor_CarProviderEvent;
	}


	public void start() throws WSOUIException {
		confEndpointFor_CarProviderEvent = getProviderConfigurationFor_CarProviderEvent();
		im = new CarProviderEventImplementationManager(new CarProviderEventTestImplementation(new CarProviderEvent_ExchangeProcessor()), CarProviderEvent_WSOUIService.getWSDL_LOCATION(), confEndpointFor_CarProviderEvent);
		endpointFor_CarProviderEvent = Endpoint.publish(confEndpointFor_CarProviderEvent.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_CarProviderEvent.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_CarProviderEvent);
	}


	public void stop() {
		if(endpointFor_CarProviderEvent != null) {
			endpointFor_CarProviderEvent.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		CarProviderEvent_WSOUIServer provider = new CarProviderEvent_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_CarProviderEvent().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
