package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class CarProvider_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_CarProvider = null;
	private ProviderConfiguration confEndpointFor_CarProvider = null;
	private AbstractImplementationManager<?> im = null;
	
	public CarProvider_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_CarProvider() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":7206/carProviderPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_CarProvider() {
		if(this.confEndpointFor_CarProvider == null) {
			this.confEndpointFor_CarProvider = createDefaultProviderConfigurationFor_CarProvider();
		}
		return this.confEndpointFor_CarProvider;
	}


	public void start() throws WSOUIException {
		confEndpointFor_CarProvider = getProviderConfigurationFor_CarProvider();
		im = new CarProviderImplementationManager(new CarProviderTestImplementation(new CarProvider_ExchangeProcessor()), CarProvider_WSOUIService.getWSDL_LOCATION(), confEndpointFor_CarProvider);
		endpointFor_CarProvider = Endpoint.publish(confEndpointFor_CarProvider.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_CarProvider.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_CarProvider);
	}


	public void stop() {
		if(endpointFor_CarProvider != null) {
			endpointFor_CarProvider.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		CarProvider_WSOUIServer provider = new CarProvider_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_CarProvider().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
