package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class VehicleProviderEvent_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_VehicleProviderEvent = null;
	private ProviderConfiguration confEndpointFor_VehicleProviderEvent = null;
	private AbstractImplementationManager<?> im = null;
	
	public VehicleProviderEvent_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_VehicleProviderEvent() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":7201/vehicleProviderEventPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_VehicleProviderEvent() {
		if(this.confEndpointFor_VehicleProviderEvent == null) {
			this.confEndpointFor_VehicleProviderEvent = createDefaultProviderConfigurationFor_VehicleProviderEvent();
		}
		return this.confEndpointFor_VehicleProviderEvent;
	}


	public void start() throws WSOUIException {
		confEndpointFor_VehicleProviderEvent = getProviderConfigurationFor_VehicleProviderEvent();
		im = new VehicleProviderEventImplementationManager(new VehicleProviderEventTestImplementation(new VehicleProviderEvent_ExchangeProcessor()), VehicleProviderEvent_WSOUIService.getWSDL_LOCATION(), confEndpointFor_VehicleProviderEvent);
		endpointFor_VehicleProviderEvent = Endpoint.publish(confEndpointFor_VehicleProviderEvent.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_VehicleProviderEvent.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_VehicleProviderEvent);
	}


	public void stop() {
		if(endpointFor_VehicleProviderEvent != null) {
			endpointFor_VehicleProviderEvent.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		VehicleProviderEvent_WSOUIServer provider = new VehicleProviderEvent_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_VehicleProviderEvent().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
