package org.petalslink.seacloud;

import javax.xml.bind.JAXBElement;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.petalslink.easiestdemo.wsoui.provided.notification.AbstractEventProducerNotifier;

import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;
import fr.mines_albi.nuclearcrisisevent.ReportEvent;
import fr.mines_albi.nuclearcrisisevent.Resources;
import fr.mines_albi.nuclearcrisisevent.ResourcesStatusEvent;

public class SeaCloud_EventProducerNotifier extends AbstractEventProducerNotifier {
	
	private static int cpt = 0;


	public SeaCloud_EventProducerNotifier(ProviderConfiguration configuration, WSOUIJaxbContextItf context) throws WSOUIException {
		super(configuration, context);
		this.getSubscriptionManager().setTopicSet(Thread.currentThread().getContextClassLoader().getResource("crisis/v3/EventTopicSet.xml"));
		this.getSubscriptionManager().setTopicNamespace(Thread.currentThread().getContextClassLoader().getResource("crisis/v3/EventTopicNS.xml"));
	}

	@Override
	public void setPeriodEvent() {
		this.setPeriodEvent(0); // Set the period to send event (in ms).
	}


	@Override
	public AbstractJaxbModelObject createPeriodicallyEvent() throws WSOUIException {
		AbstractJaxbModelObject event = null; // TODO: create Event.
		return event;
	}


	@Override
	public AbstractJaxbModelObject createEventBeforeProcessingRequest(String methodName, Object request) throws WSOUIException {
		ResourcesStatusEvent event = null; // TODO: create Event.
		return event;
	}


	@Override
	public AbstractJaxbModelObject createEventBeforeSendResponse(String methodName, Object request, Object response) throws WSOUIException {
		try {
			if("subscribe".equals(methodName)) {
				EJaxbSubscribe subscribeJaxb = (EJaxbSubscribe)request;
				System.out.println("topic = " + subscribeJaxb.getFilter().getAny().get(0));

				String topic = null;
				if(subscribeJaxb.getFilter().getAny().size() > 0 && subscribeJaxb.getFilter().getAny().get(0) instanceof JAXBElement) {
					JAXBElement elmt = (JAXBElement) subscribeJaxb.getFilter().getAny().get(0);
					if(elmt.getValue() instanceof EJaxbTopicExpressionType) {
						EJaxbTopicExpressionType topicExp = (EJaxbTopicExpressionType) elmt.getValue();
						if(topicExp.getContent().size() > 0) {
							topic = (String) topicExp.getContent().get(0);
						}
					} 
				}

				if(topic == null) {
					throw new WSOUIException("Impossible to find topicExpression in subscribe!!!");
				}
				System.out.println("topic = " + topic);
				if(topic.contains("consequenceEvent")) {
					System.out.println("WAIT BEFORE SEND EVENT consequenceEvent");
					Thread.sleep(1000);
					ReportEvent event = new ReportEvent();
					event.setUid("human resource " + cpt++);
					System.out.println("methodName = " + methodName);
					System.out.println("request = " + request);
					System.out.println("+++++++++++++++++++++++++++++++ CREATION AND SEND OF consequenceEvent EVENT");
					return event;
				} else if(topic.contains("resourcesEvent")) {
					System.out.println("WAIT BEFORE SEND EVENT resourceSendTopic");
					Thread.sleep(5000);
					ResourcesStatusEvent event = new ResourcesStatusEvent();
					event.setUid("human resource " + cpt++);
					Resources value = new Resources();
					value.setQuantity(5.0);
					event.setProvider("car");
					event.setResources(value);
					System.out.println("methodName = " + methodName);
					System.out.println("request = " + request);
					System.out.println("+++++++++++++++++++++++++++++++ CREATION AND SEND OF resourcesStatusEvent EVENT");
					return event;
				} 
			}
		}  catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}



}
