package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class BusProvider_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	private Endpoint endpointFor_BusProvider = null;
	private ProviderConfiguration confEndpointFor_BusProvider = null;
	private AbstractImplementationManager<?> im = null;
	
	public BusProvider_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_BusProvider() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":9101/busProviderPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_BusProvider() {
		if(this.confEndpointFor_BusProvider == null) {
			this.confEndpointFor_BusProvider = createDefaultProviderConfigurationFor_BusProvider();
		}
		return this.confEndpointFor_BusProvider;
	}


	public void start() throws WSOUIException {
		confEndpointFor_BusProvider = getProviderConfigurationFor_BusProvider();
		im = new BusProviderImplementationManager(new BusProviderTestImplementation(new BusProvider_ExchangeProcessor()), BusProvider_WSOUIService.getWSDL_LOCATION(), confEndpointFor_BusProvider);
		endpointFor_BusProvider = Endpoint.publish(confEndpointFor_BusProvider.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_BusProvider.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_BusProvider);
	}


	public void stop() {
		if(endpointFor_BusProvider != null) {
			endpointFor_BusProvider.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		BusProvider_WSOUIServer provider = new BusProvider_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_BusProvider().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
